/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.hp.octane.integrations.OctaneSDK;
import com.microfocus.application.automation.tools.octane.tests.HPRunnerType;
import hudson.model.Action;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class UftOctaneUtils {
    private UftOctaneUtils() {
    }

    public static void setUFTRunnerTypeAsParameter(@Nonnull Run<?, ?> build, @Nonnull TaskListener listener) {
        if ("org.jenkinsci.plugins.workflow.job.WorkflowRun".equals(build.getClass().getName()) && OctaneSDK.hasClients()) {
            listener.getLogger().println("Set HPRunnerType = HPRunnerType.UFT");
            ParametersAction parameterAction = (ParametersAction)build.getAction(ParametersAction.class);
            ArrayList<StringParameterValue> newParams = parameterAction != null ? new ArrayList<StringParameterValue>(parameterAction.getAllParameters()) : new ArrayList();
            newParams.add(new StringParameterValue(HPRunnerType.class.getSimpleName(), HPRunnerType.UFT.name()));
            ParametersAction newParametersAction = new ParametersAction(newParams);
            build.addOrReplaceAction((Action)newParametersAction);
            if (parameterAction == null || parameterAction.getParameter("UFT_CHECKOUT_FOLDER") == null) {
                listener.getLogger().println("NOTE : If you need to integrate test results with an Software Delivery Management pipeline, and tests are located outside of the job workspace, define a parameter  UFT_CHECKOUT_FOLDER with the path to the repository root in the file system. This enables Software Delivery Management to display the test name, rather than the full path to your test.");
                listener.getLogger().println("");
            }
        }
    }
}

