/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.microfocus.application.automation.tools.model.SvDeployModel;
import com.microfocus.application.automation.tools.model.SvServerSettingsModel;
import com.microfocus.application.automation.tools.sv.runner.AbstractSvRemoteRunner;
import com.microfocus.application.automation.tools.sv.runner.AbstractSvRunBuilder;
import com.microfocus.application.automation.tools.sv.runner.AbstractSvRunDescriptor;
import com.microfocus.sv.svconfigurator.core.IDataModel;
import com.microfocus.sv.svconfigurator.core.IPerfModel;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.processor.DeployProcessor;
import com.microfocus.sv.svconfigurator.processor.DeployProcessorInput;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.util.ProjectUtils;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SvDeployBuilder
extends AbstractSvRunBuilder<SvDeployModel> {
    @DataBoundConstructor
    public SvDeployBuilder(String serverName, boolean force, String service, String projectPath, String projectPassword, boolean firstAgentFallback) {
        super(new SvDeployModel(serverName, force, service, projectPath, projectPassword, firstAgentFallback));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    protected RemoteRunner getRemoteRunner(@Nonnull FilePath workspace, TaskListener listener, SvServerSettingsModel server) {
        return new RemoteRunner((SvDeployModel)this.model, workspace, listener, server);
    }

    @Override
    protected void logConfig(PrintStream logger, String prefix) {
        super.logConfig(logger, prefix);
        logger.println(prefix + "First agent fallback: " + ((SvDeployModel)this.model).isFirstAgentFallback());
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractSvRunDescriptor {
        public DescriptorImpl() {
            super("SV: Deploy Virtual Service");
        }

        public FormValidation doCheckProjectPath(@QueryParameter String projectPath) {
            if (StringUtils.isBlank((String)projectPath)) {
                return FormValidation.error((String)"Project path cannot be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckService(@QueryParameter String service) {
            if (StringUtils.isBlank((String)service)) {
                return FormValidation.ok((String)"All services from project will be deployed if no service is specified");
            }
            return FormValidation.ok();
        }
    }

    private static class RemoteRunner
    extends AbstractSvRemoteRunner<SvDeployModel> {
        private RemoteRunner(SvDeployModel model, FilePath workspace, TaskListener listener, SvServerSettingsModel server) {
            super(listener, model, workspace, server);
        }

        public String call() throws Exception {
            PrintStream logger = this.listener.getLogger();
            IProject project = this.loadProject(this.workspace);
            this.printProjectContent(project, logger);
            this.deployServiceFromProject(project, logger);
            return null;
        }

        private void printProjectContent(IProject project, PrintStream logger) {
            logger.println("  Project content:");
            for (IService service : project.getServices()) {
                logger.println("    Service: " + service.getName() + " [" + service.getId() + "]");
                for (IDataModel dataModel : service.getDataModels()) {
                    logger.println("      DM: " + dataModel.getName() + " [" + dataModel.getId() + "]");
                }
                for (IPerfModel perfModel : service.getPerfModels()) {
                    logger.println("      PM: " + perfModel.getName() + " [" + perfModel.getId() + "]");
                }
            }
        }

        private Iterable<IService> getServiceList(IProject project) {
            if (((SvDeployModel)this.model).getService() == null) {
                return project.getServices();
            }
            ArrayList<IService> list = new ArrayList<IService>();
            list.add((IService)ProjectUtils.findProjElem((Collection)project.getServices(), (String)((SvDeployModel)this.model).getService()));
            return list;
        }

        private void deployServiceFromProject(IProject project, PrintStream logger) throws Exception {
            DeployProcessor processor = new DeployProcessor(null);
            ICommandExecutor commandExecutor = this.createCommandExecutor();
            for (IService service : this.getServiceList(project)) {
                logger.printf("  Deploying service '%s' [%s] %n", service.getName(), service.getId());
                DeployProcessorInput deployInput = new DeployProcessorInput(((SvDeployModel)this.model).isForce(), false, project, ((SvDeployModel)this.model).getService(), null, false);
                deployInput.setFirstAgentFailover(((SvDeployModel)this.model).isFirstAgentFallback());
                processor.process(deployInput, commandExecutor);
            }
        }
    }
}

