/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.microfocus.application.automation.tools.model.SvChangeModeModel;
import com.microfocus.application.automation.tools.model.SvDataModelSelection;
import com.microfocus.application.automation.tools.model.SvPerformanceModelSelection;
import com.microfocus.application.automation.tools.model.SvServerSettingsModel;
import com.microfocus.application.automation.tools.model.SvServiceSelectionModel;
import com.microfocus.application.automation.tools.sv.runner.AbstractSvRemoteRunner;
import com.microfocus.application.automation.tools.sv.runner.AbstractSvRunBuilder;
import com.microfocus.application.automation.tools.sv.runner.AbstractSvRunDescriptor;
import com.microfocus.application.automation.tools.sv.runner.ServiceInfo;
import com.microfocus.sv.svconfigurator.core.IProjectElement;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeConfiguration;
import com.microfocus.sv.svconfigurator.processor.ChmodeProcessor;
import com.microfocus.sv.svconfigurator.processor.ChmodeProcessorInput;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.PrintStream;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SvChangeModeBuilder
extends AbstractSvRunBuilder<SvChangeModeModel> {
    private static final Logger LOG = Logger.getLogger(SvChangeModeBuilder.class.getName());

    @DataBoundConstructor
    public SvChangeModeBuilder(String serverName, boolean force, ServiceRuntimeConfiguration.RuntimeMode mode, SvDataModelSelection dataModel, SvPerformanceModelSelection performanceModel, SvServiceSelectionModel serviceSelection) {
        super(new SvChangeModeModel(serverName, force, mode, dataModel, performanceModel, serviceSelection));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public SvDataModelSelection getDataModel() {
        return ((SvChangeModeModel)this.model).getDataModel();
    }

    public SvPerformanceModelSelection getPerformanceModel() {
        return ((SvChangeModeModel)this.model).getPerformanceModel();
    }

    protected RemoteRunner getRemoteRunner(@Nonnull FilePath workspace, TaskListener listener, SvServerSettingsModel server) {
        return new RemoteRunner((SvChangeModeModel)this.model, workspace, listener, server);
    }

    @Override
    protected void logConfig(PrintStream logger, String prefix) {
        super.logConfig(logger, prefix);
        logger.println(prefix + "Mode: " + ((SvChangeModeModel)this.model).getMode().toString());
        logger.println(prefix + "Data model: " + ((SvChangeModeModel)this.model).getDataModel().toString());
        logger.println(prefix + "Performance model: " + ((SvChangeModeModel)this.model).getPerformanceModel().toString());
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractSvRunDescriptor {
        public DescriptorImpl() {
            super("SV: Change Mode of Virtual Service");
        }

        public FormValidation doCheckDataModel(@QueryParameter String value, @QueryParameter(value="mode") String mode, @QueryParameter(value="serviceSelectionKind") String kind) {
            if (StringUtils.isNotBlank((String)mode)) {
                ServiceRuntimeConfiguration.RuntimeMode runtimeMode = ServiceRuntimeConfiguration.RuntimeMode.valueOf((String)mode);
                if ((ServiceRuntimeConfiguration.RuntimeMode.SIMULATING == runtimeMode || ServiceRuntimeConfiguration.RuntimeMode.LEARNING == runtimeMode) && StringUtils.isBlank((String)value)) {
                    return FormValidation.ok((String)"First data model will be used if not specified");
                }
                if (ServiceRuntimeConfiguration.RuntimeMode.STAND_BY == runtimeMode && StringUtils.isNotBlank((String)value)) {
                    return FormValidation.warning((String)"Data model will not be used in Stand-By mode");
                }
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillModeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Stand-By", ServiceRuntimeConfiguration.RuntimeMode.STAND_BY.toString());
            items.add("Simulate", ServiceRuntimeConfiguration.RuntimeMode.SIMULATING.toString());
            items.add("Learn", ServiceRuntimeConfiguration.RuntimeMode.LEARNING.toString());
            items.add("Offline", ServiceRuntimeConfiguration.RuntimeMode.OFFLINE.toString());
            return items;
        }
    }

    private static class RemoteRunner
    extends AbstractSvRemoteRunner<SvChangeModeModel> {
        private RemoteRunner(SvChangeModeModel model, FilePath workspace, TaskListener listener, SvServerSettingsModel server) {
            super(listener, model, workspace, server);
        }

        public String call() throws Exception {
            PrintStream logger = this.listener.getLogger();
            ICommandExecutor exec = this.createCommandExecutor();
            for (ServiceInfo service : this.getServiceList(false, logger, this.workspace)) {
                this.changeServiceMode(service, logger, exec);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changeServiceMode(ServiceInfo serviceInfo, PrintStream logger, ICommandExecutor commandExecutor) throws Exception {
            String dataModel = ((SvChangeModeModel)this.model).getDataModel().getSelectedModelName();
            String performanceModel = ((SvChangeModeModel)this.model).getPerformanceModel().getSelectedModelName();
            boolean useDefaultDataModel = ((SvChangeModeModel)this.model).getDataModel().isDefaultSelected();
            boolean useDefaultPerformanceModel = ((SvChangeModeModel)this.model).getPerformanceModel().isDefaultSelected();
            ServiceRuntimeConfiguration.RuntimeMode targetMode = this.getTargetMode();
            ChmodeProcessorInput chmodeInput = new ChmodeProcessorInput(((SvChangeModeModel)this.model).isForce(), null, serviceInfo.getId(), dataModel, performanceModel, targetMode, useDefaultDataModel, useDefaultPerformanceModel);
            logger.printf("    Changing mode of service '%s' [%s] to %s mode%n", serviceInfo.getName(), serviceInfo.getId(), ((SvChangeModeModel)this.model).getMode());
            ChmodeProcessor processor = new ChmodeProcessor(null);
            try {
                processor.process(chmodeInput, commandExecutor);
            }
            finally {
                this.printServiceStatus(logger, serviceInfo, commandExecutor);
            }
        }

        private ServiceRuntimeConfiguration.RuntimeMode getTargetMode() {
            if (((SvChangeModeModel)this.model).getMode() == ServiceRuntimeConfiguration.RuntimeMode.SIMULATING && !((SvChangeModeModel)this.model).getPerformanceModel().isNoneSelected() && ((SvChangeModeModel)this.model).getDataModel().isNoneSelected()) {
                return ServiceRuntimeConfiguration.RuntimeMode.STAND_BY;
            }
            return ((SvChangeModeModel)this.model).getMode();
        }

        private void printServiceStatus(PrintStream logger, ServiceInfo serviceInfo, ICommandExecutor commandExecutor) {
            try {
                IService service = commandExecutor.findService(serviceInfo.getId(), null);
                ServiceRuntimeConfiguration info = commandExecutor.getServiceRuntimeInfo(service);
                ServiceRuntimeConfiguration.RuntimeMode mode = this.getDisplayRuntimeMode(info);
                logger.printf("    Service '%s' [%s] is in %s mode%n", service.getName(), service.getId(), mode);
                if (mode == ServiceRuntimeConfiguration.RuntimeMode.LEARNING || mode == ServiceRuntimeConfiguration.RuntimeMode.SIMULATING) {
                    logger.println("      Data model: " + this.getModelName(service.getDataModels(), info.getDataModelId()));
                    logger.println("      Performance model: " + this.getModelName(service.getPerfModels(), info.getPerfModelId()));
                }
                if (info.getDeploymentErrorMessage() != null) {
                    logger.println("      Error message: " + info.getDeploymentErrorMessage());
                }
            }
            catch (Exception e) {
                String msg = String.format("Failed to get detail of service '%s' [%s]", serviceInfo.getName(), serviceInfo.getId());
                logger.printf("      %s: %s%n", msg, e.getMessage());
                LOG.log(Level.SEVERE, msg, e);
            }
        }

        private ServiceRuntimeConfiguration.RuntimeMode getDisplayRuntimeMode(ServiceRuntimeConfiguration info) {
            return info.getRuntimeMode() == ServiceRuntimeConfiguration.RuntimeMode.STAND_BY && info.getPerfModelId() != null ? ServiceRuntimeConfiguration.RuntimeMode.SIMULATING : info.getRuntimeMode();
        }

        private String getModelName(Collection<? extends IProjectElement> models, String modelId) {
            for (IProjectElement iProjectElement : models) {
                if (!iProjectElement.getId().equals(modelId)) continue;
                return String.format("'%s' [%s]", iProjectElement.getName(), modelId);
            }
            return null;
        }
    }
}

