/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.exceptions.SonarIntegrationException;
import com.microfocus.application.automation.tools.octane.actions.WebhookAction;
import com.microfocus.application.automation.tools.octane.model.SonarHelper;
import com.microfocus.application.automation.tools.sse.common.StringUtils;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SonarOctaneListener
extends Builder
implements SimpleBuildStep {
    public String sonarToken;
    public String sonarServerUrl;
    boolean pushVulnerabilities;
    boolean pushCoverage;
    private boolean skipWebhookCreation;
    private Set<SonarHelper.DataType> dataTypeSet = new HashSet<SonarHelper.DataType>();

    @DataBoundConstructor
    public SonarOctaneListener() {
    }

    @DataBoundSetter
    public void setSonarToken(String sonarToken) {
        this.sonarToken = sonarToken;
    }

    @DataBoundSetter
    public void setSonarServerUrl(String sonarServerUrl) {
        this.sonarServerUrl = sonarServerUrl;
    }

    @DataBoundSetter
    public void setSkipWebhookCreation(boolean skipWebhookCreation) {
        this.skipWebhookCreation = skipWebhookCreation;
    }

    @DataBoundSetter
    public void setPushVulnerabilities(boolean pushVulnerabilities) {
        this.pushVulnerabilities = pushVulnerabilities;
        if (pushVulnerabilities) {
            this.dataTypeSet.add(SonarHelper.DataType.VULNERABILITIES);
        } else {
            this.dataTypeSet.remove((Object)SonarHelper.DataType.VULNERABILITIES);
        }
    }

    @DataBoundSetter
    public void setPushCoverage(boolean pushCoverage) {
        this.pushCoverage = pushCoverage;
        if (pushCoverage) {
            this.dataTypeSet.add(SonarHelper.DataType.COVERAGE);
        } else {
            this.dataTypeSet.remove((Object)SonarHelper.DataType.COVERAGE);
        }
    }

    public String getSonarToken() {
        return this.sonarToken;
    }

    public String getSonarServerUrl() {
        return this.sonarServerUrl;
    }

    public boolean isPushVulnerabilities() {
        return this.pushVulnerabilities;
    }

    public boolean isPushCoverage() {
        return this.pushCoverage;
    }

    private void initializeSonarDetails(@Nonnull Run<?, ?> run, TaskListener listener) throws InterruptedException {
        ExtensionList allConfigurations = GlobalConfiguration.all();
        if (allConfigurations != null) {
            SonarHelper adapter = new SonarHelper(run, listener);
            this.setSonarServerUrl(StringUtils.isNullOrEmpty(adapter.getServerUrl()) ? this.sonarServerUrl : adapter.getServerUrl());
            this.setSonarToken(StringUtils.isNullOrEmpty(adapter.getServerToken()) ? this.sonarToken : adapter.getServerToken());
        }
    }

    private String getBuildNumber(Run<?, ?> run) {
        if (run instanceof AbstractBuild) {
            AbstractBuild abstractBuild = (AbstractBuild)run;
            return String.valueOf(abstractBuild.getNumber());
        }
        return "";
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        if (!OctaneSDK.hasClients()) {
            return;
        }
        PrintStream logger = listener.getLogger();
        this.initializeSonarDetails(run, listener);
        String jenkinsRoot = Jenkins.get().getRootUrl();
        String callbackWebHooksURL = jenkinsRoot + "webhooks/notify";
        if (StringUtils.isNullOrEmpty(this.sonarServerUrl) || StringUtils.isNullOrEmpty(this.sonarToken)) {
            logger.println("Webhook registration in sonarQube for build " + this.getBuildNumber(run) + " failed, missing sonarQube server url or sonarQube authentication token");
        } else if (!this.skipWebhookCreation) {
            logger.println("callback URL for jenkins resource will be set to: " + callbackWebHooksURL + " in sonarQube server with URL: " + this.sonarServerUrl);
            try {
                ((OctaneClient)OctaneSDK.getClients().get(0)).getSonarService().ensureSonarWebhookExist(callbackWebHooksURL, this.getSonarServerUrl(), this.getSonarToken());
            }
            catch (SonarIntegrationException e) {
                logger.println("Webhook registration in sonarQube for build " + this.getBuildNumber(run) + " failed: " + e.getMessage());
            }
        } else {
            logger.println("Webhook creation is skipped. Be sure that Sonar server " + this.sonarServerUrl + " has configured webhook to: " + callbackWebHooksURL);
        }
        run.addAction((Action)new WebhookAction(true, this.getSonarServerUrl(), this.dataTypeSet));
    }

    public SonarDescriptor getDescriptor() {
        return (SonarDescriptor)super.getDescriptor();
    }

    public boolean isSkipWebhookCreation() {
        return this.skipWebhookCreation;
    }

    @Symbol(value={"addALMOctaneSonarQubeListener"})
    @Extension
    public static class SonarDescriptor
    extends BuildStepDescriptor<Builder> {
        public SonarDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return "OpenText Software Delivery Management SonarQube listener";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }
    }
}

