/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.microfocus.application.automation.tools.AlmToolsUtils;
import com.microfocus.application.automation.tools.EncryptionUtils;
import com.microfocus.application.automation.tools.JenkinsUtils;
import com.microfocus.application.automation.tools.Messages;
import com.microfocus.application.automation.tools.lr.model.ScriptRTSSetModel;
import com.microfocus.application.automation.tools.lr.model.SummaryDataLogModel;
import com.microfocus.application.automation.tools.mc.JobConfigurationProxy;
import com.microfocus.application.automation.tools.model.AuthModel;
import com.microfocus.application.automation.tools.model.CloudBrowserModel;
import com.microfocus.application.automation.tools.model.EnumDescription;
import com.microfocus.application.automation.tools.model.FileSystemTestSetModel;
import com.microfocus.application.automation.tools.model.MCServerSettingsModel;
import com.microfocus.application.automation.tools.model.ProxySettings;
import com.microfocus.application.automation.tools.model.RunFromFileSystemModel;
import com.microfocus.application.automation.tools.run.AlmRunTypes;
import com.microfocus.application.automation.tools.run.UftOctaneUtils;
import com.microfocus.application.automation.tools.settings.MCServerSettingsGlobalConfiguration;
import com.microfocus.application.automation.tools.sse.common.StringUtils;
import com.microfocus.application.automation.tools.uft.model.SpecifyParametersModel;
import com.microfocus.application.automation.tools.uft.model.UftRunAsUser;
import com.microfocus.application.automation.tools.uft.model.UftSettingsModel;
import com.microfocus.application.automation.tools.uft.utils.UftToolUtils;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class RunFromFileBuilder
extends Builder
implements SimpleBuildStep {
    private static final String LRANALYSIS_LAUNCHER_EXE = "LRAnalysisLauncher.exe";
    public static final String HP_TOOLS_LAUNCHER_EXE = "HpToolsLauncher.exe";
    public static final String HP_TOOLS_LAUNCHER_EXE_CFG = "HpToolsLauncher.exe.config";
    private RunFromFileSystemModel runFromFileModel;
    private FileSystemTestSetModel fileSystemTestSetModel;
    private SpecifyParametersModel specifyParametersModel;
    private boolean isParallelRunnerEnabled;
    private boolean areParametersEnabled;
    private boolean isPdfEnabled;
    private SummaryDataLogModel summaryDataLogModel;
    private ScriptRTSSetModel scriptRTSSetModel;
    private UftSettingsModel uftSettingsModel;
    private Map<Long, String> resultFileNames;

    @DataBoundConstructor
    public RunFromFileBuilder(String fsTests, boolean isParallelRunnerEnabled, boolean areParametersEnabled, boolean isPdfEnabled, SpecifyParametersModel specifyParametersModel, FileSystemTestSetModel fileSystemTestSetModel, SummaryDataLogModel summaryDataLogModel, ScriptRTSSetModel scriptRTSSetModel, UftSettingsModel uftSettingsModel) {
        this.runFromFileModel = new RunFromFileSystemModel(fsTests);
        this.specifyParametersModel = specifyParametersModel;
        this.fileSystemTestSetModel = fileSystemTestSetModel;
        this.isParallelRunnerEnabled = isParallelRunnerEnabled;
        this.isPdfEnabled = isPdfEnabled;
        this.areParametersEnabled = areParametersEnabled;
        this.summaryDataLogModel = summaryDataLogModel;
        this.scriptRTSSetModel = scriptRTSSetModel;
        this.uftSettingsModel = uftSettingsModel;
        if (uftSettingsModel != null) {
            uftSettingsModel.setFsTestPath(this.getFsTests());
        }
        this.resultFileNames = new HashMap<Long, String>();
    }

    public RunFromFileBuilder(String fsTests) {
        this.runFromFileModel = new RunFromFileSystemModel(fsTests);
    }

    public RunFromFileBuilder(RunFromFileSystemModel runFromFileModel) {
        this.runFromFileModel = runFromFileModel;
    }

    @Deprecated
    public RunFromFileBuilder(String fsTests, String fsTimeout, String fsUftRunMode, String controllerPollingInterval, String perScenarioTimeOut, String ignoreErrorStrings, String displayController, String analysisTemplate, String mcServerName, AuthModel authModel, String workspaceId, String fsDeviceId, String fsTargetLab, String fsManufacturerAndModel, String fsOs, String fsAutActions, String fsLaunchAppName, String fsDevicesMetrics, String fsInstrumented, String fsExtraApps, String fsJobId, ProxySettings proxySettings, boolean useSSL, boolean isPdfEnabled, boolean isParallelRunnerEnabled, String fsReportPath, CloudBrowserModel cloudBrowserModel) {
        this.isParallelRunnerEnabled = isParallelRunnerEnabled;
        this.isPdfEnabled = isPdfEnabled;
        this.runFromFileModel = new RunFromFileSystemModel(fsTests, fsTimeout, fsUftRunMode, controllerPollingInterval, perScenarioTimeOut, ignoreErrorStrings, displayController, analysisTemplate, mcServerName, authModel, workspaceId, fsDeviceId, fsTargetLab, fsManufacturerAndModel, fsOs, fsAutActions, fsLaunchAppName, fsDevicesMetrics, fsInstrumented, fsExtraApps, fsJobId, proxySettings, useSSL, fsReportPath, cloudBrowserModel);
    }

    private static void replaceTestWithMtbxFile(FilePath workspace, Properties props, String content, String key, String time, int index) throws Exception {
        if (UftToolUtils.isMtbxContent(content)) {
            try {
                Object prefx = index > 0 ? index + "_" : "";
                String mtbxFilePath = (String)prefx + RunFromFileBuilder.createMtbxFileInWs(workspace, content, time);
                props.setProperty(key, mtbxFilePath);
            }
            catch (IOException | InterruptedException e) {
                throw new Exception(e);
            }
        }
    }

    private static void replaceTestWithMtbxFile(FilePath workspace, Properties props, String content, String key, String time) throws Exception {
        RunFromFileBuilder.replaceTestWithMtbxFile(workspace, props, content, key, time, 0);
    }

    private static String createMtbxFileInWs(FilePath workspace, String mtbxContent, String timeString) throws IOException, InterruptedException {
        String fileName = "test_suite_" + timeString + ".mtbx";
        FilePath remoteFile = workspace.child(fileName);
        String mtbxContentUpdated = mtbxContent.replace("${WORKSPACE}", workspace.getRemote());
        if (mtbxContent.contains("${workspace}")) {
            mtbxContentUpdated = mtbxContent.replace("${workspace}", workspace.getRemote());
        }
        try (InputStream in = IOUtils.toInputStream((String)mtbxContentUpdated, (Charset)StandardCharsets.UTF_8);){
            remoteFile.copyFrom(in);
        }
        return remoteFile.getRemote();
    }

    public FileSystemTestSetModel getFileSystemTestSetModel() {
        return this.fileSystemTestSetModel;
    }

    public boolean getIsParallelRunnerEnabled() {
        return this.isParallelRunnerEnabled;
    }

    @DataBoundSetter
    private void setIsParallelRunnerEnabled(boolean isParallelRunnerEnabled) {
        this.isParallelRunnerEnabled = isParallelRunnerEnabled;
    }

    public boolean getIsPdfEnabled() {
        return this.isPdfEnabled;
    }

    @DataBoundSetter
    private void setIsPdfEnabled(boolean enablePDF) {
        this.isPdfEnabled = enablePDF;
    }

    public String getAnalysisTemplate() {
        return this.runFromFileModel.getAnalysisTemplate();
    }

    @DataBoundSetter
    public void setAnalysisTemplate(String analysisTemplate) {
        this.runFromFileModel.setAnalysisTemplate(analysisTemplate);
    }

    public SummaryDataLogModel getSummaryDataLogModel() {
        return this.summaryDataLogModel;
    }

    public void setSummaryDataLogModel(SummaryDataLogModel summaryDataLogModel) {
        this.summaryDataLogModel = summaryDataLogModel;
    }

    public ScriptRTSSetModel getScriptRTSSetModel() {
        return this.scriptRTSSetModel;
    }

    public void setScriptRTSSetModel(ScriptRTSSetModel scriptRTSSetModel) {
        this.scriptRTSSetModel = scriptRTSSetModel;
    }

    public UftSettingsModel getUftSettingsModel() {
        return this.uftSettingsModel;
    }

    @DataBoundSetter
    public void setUftSettingsModel(UftSettingsModel uftSettingsModel) {
        this.uftSettingsModel = uftSettingsModel;
    }

    public String getFsTimeout() {
        return this.runFromFileModel.getFsTimeout();
    }

    @DataBoundSetter
    public void setFsTimeout(String fsTimeout) {
        this.runFromFileModel.setFsTimeout(fsTimeout);
    }

    public String getFsTests() {
        return this.runFromFileModel.getFsTests();
    }

    public void setFsTests(String fsTests) {
        this.runFromFileModel.setFsTests(fsTests);
    }

    public String getControllerPollingInterval() {
        return this.runFromFileModel.getControllerPollingInterval();
    }

    @DataBoundSetter
    public void setControllerPollingInterval(String controllerPollingInterval) {
        this.runFromFileModel.setControllerPollingInterval(controllerPollingInterval);
    }

    public String getPerScenarioTimeOut() {
        return this.runFromFileModel.getPerScenarioTimeOut();
    }

    @DataBoundSetter
    public void setPerScenarioTimeOut(String perScenarioTimeOut) {
        this.runFromFileModel.setPerScenarioTimeOut(perScenarioTimeOut);
    }

    public String getDisplayController() {
        return this.runFromFileModel.getDisplayController();
    }

    @DataBoundSetter
    public void setDisplayController(String displayController) {
        this.runFromFileModel.setDisplayController(displayController);
    }

    public String getFsAutActions() {
        return this.runFromFileModel.getFsAutActions();
    }

    @DataBoundSetter
    public void setFsAutActions(String fsAutActions) {
        this.runFromFileModel.setFsAutActions(fsAutActions);
    }

    public String getFsDeviceId() {
        return this.runFromFileModel.getFsDeviceId();
    }

    @DataBoundSetter
    public void setFsDeviceId(String fsDeviceId) {
        this.runFromFileModel.setFsDeviceId(fsDeviceId);
    }

    public String getFsDevicesMetrics() {
        return this.runFromFileModel.getFsDevicesMetrics();
    }

    @DataBoundSetter
    public void setFsDevicesMetrics(String fsDevicesMetrics) {
        this.runFromFileModel.setFsDevicesMetrics(fsDevicesMetrics);
    }

    public String getFsExtraApps() {
        return this.runFromFileModel.getFsExtraApps();
    }

    @DataBoundSetter
    public void setFsExtraApps(String fsExtraApps) {
        this.runFromFileModel.setFsExtraApps(fsExtraApps);
    }

    public String getFsOs() {
        return this.runFromFileModel.getFsOs();
    }

    @DataBoundSetter
    public void setFsOs(String fsOs) {
        this.runFromFileModel.setFsOs(fsOs);
    }

    public String getFsInstrumented() {
        return this.runFromFileModel.getFsInstrumented();
    }

    @DataBoundSetter
    public void setFsInstrumented(String fsInstrumented) {
        this.runFromFileModel.setFsInstrumented(fsInstrumented);
    }

    public String getFsJobId() {
        return this.runFromFileModel.getFsJobId();
    }

    @DataBoundSetter
    public void setFsJobId(String fsJobId) {
        this.runFromFileModel.setFsJobId(fsJobId);
    }

    public String getFsUftRunMode() {
        return this.runFromFileModel.getFsUftRunMode();
    }

    @DataBoundSetter
    public void setFsUftRunMode(String fsUftRunMode) {
        this.runFromFileModel.setFsUftRunMode(fsUftRunMode);
    }

    public String getIgnoreErrorStrings() {
        return this.runFromFileModel.getIgnoreErrorStrings();
    }

    @DataBoundSetter
    public void setIgnoreErrorStrings(String ignoreErrorStrings) {
        this.runFromFileModel.setIgnoreErrorStrings(ignoreErrorStrings);
    }

    public String getMcServerName() {
        return this.runFromFileModel.getMcServerName();
    }

    @DataBoundSetter
    public void setMcServerName(String mcServerName) {
        this.runFromFileModel.setMcServerName(mcServerName);
    }

    public String getFsManufacturerAndModel() {
        return this.runFromFileModel.getFsManufacturerAndModel();
    }

    @DataBoundSetter
    public void setFsManufacturerAndModel(String fsManufacturerAndModel) {
        this.runFromFileModel.setFsManufacturerAndModel(fsManufacturerAndModel);
    }

    public String getFsLaunchAppName() {
        return this.runFromFileModel.getFsLaunchAppName();
    }

    @DataBoundSetter
    public void setFsLaunchAppName(String fsLaunchAppName) {
        this.runFromFileModel.setFsLaunchAppName(fsLaunchAppName);
    }

    public ProxySettings getProxySettings() {
        return this.runFromFileModel.getProxySettings();
    }

    @DataBoundSetter
    public void setProxySettings(ProxySettings proxySettings) {
        this.runFromFileModel.setProxySettings(proxySettings);
    }

    public String getFsTargetLab() {
        return this.runFromFileModel.getFsTargetLab();
    }

    public AuthModel getAuthModel() {
        return this.runFromFileModel.getAuthModel();
    }

    @DataBoundSetter
    public void setAuthModel(AuthModel authModel) {
        this.runFromFileModel.setAuthModel(authModel);
    }

    @DataBoundSetter
    public void setFsTargetLab(String fsTargetLab) {
        this.runFromFileModel.setFsTargetLab(fsTargetLab);
    }

    public boolean getUseSSL() {
        return this.runFromFileModel.isUseSSL();
    }

    public String getWorkspaceId() {
        return this.runFromFileModel.getWorkspaceId();
    }

    public String getWorkspaceName() {
        return this.runFromFileModel.getWorkspaceName();
    }

    public String getFsReportPath() {
        return this.runFromFileModel.getFsReportPath();
    }

    @DataBoundSetter
    public void setFsReportPath(String fsReportPath) {
        this.runFromFileModel.setFsReportPath(fsReportPath);
    }

    public CloudBrowserModel getCloudBrowserModel() {
        return this.runFromFileModel.getCloudBrowserModel();
    }

    @DataBoundSetter
    public void setCloudBrowserModel(CloudBrowserModel cloudBrowserModel) {
        this.runFromFileModel.setCloudBrowserModel(cloudBrowserModel);
    }

    public String getOutEncoding() {
        return this.runFromFileModel.getOutEncoding();
    }

    @DataBoundSetter
    public void setOutEncoding(String encoding) {
        this.runFromFileModel.setOutEncoding(encoding);
    }

    @DataBoundSetter
    public void setUseSSL(boolean useSSL) {
        this.runFromFileModel.setUseSSL(useSSL);
    }

    @DataBoundSetter
    public void setWorkspaceId(String workspaceId) {
        this.runFromFileModel.setWorkspaceId(workspaceId);
    }

    @DataBoundSetter
    public void setWorkspaceName(String workspaceName) {
        this.runFromFileModel.setWorkspaceName(workspaceName);
    }

    public Map<Long, String> getResultFileNames() {
        return this.resultFileNames;
    }

    @DataBoundSetter
    public void setResultFileNames(Map<Long, String> results) {
        this.resultFileNames = results;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException {
        String strProps;
        String testPath;
        String selectedNode;
        boolean isPrintTestParams;
        String plainTextToken;
        ParameterValue octaneFrameworkParam;
        PrintStream out = listener.getLogger();
        UftOctaneUtils.setUFTRunnerTypeAsParameter(build, listener);
        MCServerSettingsModel mcServerSettingsModel = this.getMCServerSettingsModel();
        EnvVars env = null;
        try {
            env = build.getEnvironment(listener);
        }
        catch (IOException | InterruptedException e) {
            listener.error("Failed loading build environment: " + e.getMessage());
        }
        Node currNode = JenkinsUtils.getCurrentNode(workspace);
        if (currNode == null) {
            listener.error("Failed to get current executor node.");
            return;
        }
        ParametersAction parameterAction = (ParametersAction)build.getAction(ParametersAction.class);
        ParameterValue parameterValue = octaneFrameworkParam = parameterAction != null ? parameterAction.getParameter("octaneTestRunnerFramework") : null;
        if (octaneFrameworkParam != null && octaneFrameworkParam.getValue().equals("MBT")) {
            String testsToRunConverted;
            String string = testsToRunConverted = env == null ? null : (String)env.get((Object)"testsToRunConverted");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)testsToRunConverted)) {
                out.println(RunFromFileBuilder.class.getSimpleName() + " : No UFT tests were found");
                return;
            }
        }
        Properties mergedProps = new Properties();
        if (mcServerSettingsModel != null) {
            String mcServerUrl = mcServerSettingsModel.getProperties().getProperty("MobileHostAddress");
            JSONObject jobDetails = this.runFromFileModel.getJobDetails(mcServerUrl);
            mergedProps.setProperty("mobileinfo", jobDetails != null ? jobDetails.toJSONString() : "");
            mergedProps.setProperty("MobileHostAddress", mcServerUrl);
            CloudBrowserModel cbm = this.getCloudBrowserModel();
            if (cbm != null) {
                String cb = String.format("\"url=%s;os=%s;type=%s;version=%s;region=%s\"", cbm.getUrl(), cbm.getOs(), cbm.getType(), cbm.getVersion(), cbm.getRegion());
                mergedProps.setProperty("cloudBrowser", cb);
            }
        }
        String plainTextPwd = this.runFromFileModel.getMcPassword() == null ? null : Secret.fromString((String)this.runFromFileModel.getMcPassword()).getPlainText();
        String string = plainTextToken = this.runFromFileModel.getMcExecToken() == null ? null : Secret.fromString((String)this.runFromFileModel.getMcExecToken()).getPlainText();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)plainTextPwd)) {
            try {
                String encPassword = EncryptionUtils.encrypt(plainTextPwd, currNode);
                mergedProps.put("MobilePassword", encPassword);
            }
            catch (Exception e) {
                build.setResult(Result.FAILURE);
                listener.fatalError("Problem in Functional Testing Lab password encryption: " + e.getMessage() + ".");
                return;
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)plainTextToken)) {
            try {
                String encToken = EncryptionUtils.encrypt(plainTextToken, currNode);
                mergedProps.put("MobileExecToken", encToken);
            }
            catch (Exception e) {
                build.setResult(Result.FAILURE);
                listener.fatalError("Problem in Functional Testing Lab execution token encryption: " + e.getMessage() + ".");
                return;
            }
        }
        if (env == null) {
            listener.fatalError("Environment not set");
            throw new IOException("Env Null - something went wrong with fetching jenkins build environment");
        }
        if (build instanceof AbstractBuild) {
            VariableResolver e = ((AbstractBuild)build).getBuildVariableResolver();
        }
        mergedProps.putAll((Map<?, ?>)Objects.requireNonNull(this.runFromFileModel).getProperties(env, currNode));
        if (this.areParametersEnabled) {
            try {
                this.specifyParametersModel.addProperties(mergedProps, "Test", currNode);
            }
            catch (Exception e) {
                listener.error("Error occurred while parsing parameter input, reverting back to empty array.");
            }
        }
        mergedProps.put("printTestParams", (isPrintTestParams = UftToolUtils.isPrintTestParams(build, listener)) ? "1" : "0");
        boolean isLeaveUftOpenIfVisible = UftToolUtils.leaveUftOpenIfVisible(build, listener);
        mergedProps.put("LEAVE_UFT_OPEN_IF_VISIBLE", isLeaveUftOpenIfVisible ? "1" : "0");
        try {
            UftRunAsUser uftRunAsUser = UftToolUtils.getRunAsUser(build, listener);
            if (uftRunAsUser != null) {
                if (isLeaveUftOpenIfVisible) {
                    out.println("Warning: If LEAVE_UFT_OPEN_IF_VISIBLE is set, FT will not be relaunched under the specified user if it is already running and visible.");
                }
                mergedProps.put("uftRunAsUserName", uftRunAsUser.getUsername());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)uftRunAsUser.getEncodedPassword())) {
                    mergedProps.put("uftRunAsUserEncodedPassword", uftRunAsUser.getEncodedPasswordAsEncrypted(currNode));
                } else if (uftRunAsUser.getPassword() != null) {
                    mergedProps.put("uftRunAsUserPassword", uftRunAsUser.getPasswordAsEncrypted(currNode));
                }
            }
        }
        catch (EncryptionUtils.EncryptionException | IllegalArgumentException e) {
            build.setResult(Result.FAILURE);
            listener.fatalError(String.format("Build parameters check failed: %s.", e.getMessage()));
            return;
        }
        int idx = 0;
        for (String key : env.keySet()) {
            mergedProps.put("JenkinsEnv" + ++idx, key + ";" + (String)env.get((Object)key));
        }
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("ddMMyyyyHHmmssSSS");
        String time = formatter.format((Object)now);
        String propsFileName = String.format("props%s.txt", time);
        String resFileName = String.format("Results%s_%d.xml", time, build.getNumber());
        long threadId = Thread.currentThread().getId();
        if (this.resultFileNames == null) {
            this.resultFileNames = new HashMap<Long, String>();
        }
        this.resultFileNames.put(threadId, resFileName);
        mergedProps.put("runType", AlmRunTypes.RunType.FileSystem.toString());
        if (this.summaryDataLogModel != null) {
            this.summaryDataLogModel.addToProps(mergedProps);
        }
        if (this.scriptRTSSetModel != null) {
            this.scriptRTSSetModel.addScriptsToProps(mergedProps, env);
        }
        mergedProps.put("resultsFilename", resFileName);
        if (this.isParallelRunnerEnabled) {
            this.fileSystemTestSetModel.addTestSetProperties(mergedProps, env);
            for (int index = 1; index < this.fileSystemTestSetModel.getFileSystemTestSet().size(); ++index) {
                String key = "Test" + index;
                String content = mergedProps.getProperty(key + index, "");
                try {
                    RunFromFileBuilder.replaceTestWithMtbxFile(workspace, mergedProps, content, key, time, index);
                    continue;
                }
                catch (Exception e) {
                    build.setResult(Result.FAILURE);
                    listener.error("Failed to save MTBX file : " + e.getMessage());
                }
            }
        } else {
            String firstTestKey = "Test1";
            String firstTestContent = mergedProps.getProperty(firstTestKey, "");
            try {
                RunFromFileBuilder.replaceTestWithMtbxFile(workspace, mergedProps, firstTestContent, firstTestKey, time);
            }
            catch (Exception e) {
                build.setResult(Result.FAILURE);
                listener.error("Failed to save MTBX file : " + e.getMessage());
            }
        }
        if (this.uftSettingsModel != null) {
            this.uftSettingsModel.addToProperties(mergedProps);
        }
        if ((selectedNode = (String)env.get((Object)"NODE_NAME")) == null) {
            try {
                selectedNode = launcher.getComputer().getName();
            }
            catch (Exception e) {
                listener.error("Failed to get selected node for UFT execution : " + e.getMessage());
            }
        }
        int index = 1;
        while (mergedProps.getProperty("CleanupTest" + index) != null) {
            testPath = mergedProps.getProperty("CleanupTest" + index);
            List<String> cleanupTests = UftToolUtils.getBuildTests(selectedNode, testPath);
            for (String test : cleanupTests) {
                UftToolUtils.deleteReportFoldersFromNode(selectedNode, test, listener);
            }
            ++index;
        }
        index = 1;
        while (mergedProps.getProperty("Test" + index) != null) {
            testPath = mergedProps.getProperty("Test" + index);
            List<String> buildTests = UftToolUtils.getBuildTests(selectedNode, testPath);
            for (String test : buildTests) {
                UftToolUtils.deleteReportFoldersFromNode(selectedNode, test, listener);
            }
            ++index;
        }
        String fsUftExportPdf = Boolean.toString(this.getIsPdfEnabled());
        mergedProps.setProperty("fsUftExportPdf", fsUftExportPdf);
        mergedProps.setProperty("numOfTests", String.valueOf(index - 1));
        try {
            strProps = AlmToolsUtils.getPropsAsString(mergedProps);
        }
        catch (IOException e) {
            build.setResult(Result.FAILURE);
            listener.error("Failed to store properties on agent machine: " + String.valueOf(e));
            return;
        }
        URL cmdExeUrl = Jenkins.get().pluginManager.uberClassLoader.getResource(HP_TOOLS_LAUNCHER_EXE);
        if (cmdExeUrl == null) {
            listener.fatalError("HpToolsLauncher.exe not found in resources");
            return;
        }
        URL cmdExeCfgUrl = Jenkins.get().pluginManager.uberClassLoader.getResource(HP_TOOLS_LAUNCHER_EXE_CFG);
        if (cmdExeCfgUrl == null) {
            listener.fatalError("HpToolsLauncher.exe.config not found in resources");
            return;
        }
        URL cmdExe2Url = Jenkins.get().pluginManager.uberClassLoader.getResource(LRANALYSIS_LAUNCHER_EXE);
        if (cmdExe2Url == null) {
            listener.fatalError("LRAnalysisLauncher.exenot found in resources");
            return;
        }
        FilePath fileProps = workspace.child(propsFileName);
        FilePath cmdLineExe = workspace.child(HP_TOOLS_LAUNCHER_EXE);
        FilePath cmdLineExeCfg = workspace.child(HP_TOOLS_LAUNCHER_EXE_CFG);
        FilePath cmdLineExe2 = workspace.child(LRANALYSIS_LAUNCHER_EXE);
        try {
            if (!AlmToolsUtils.tryCreatePropsFile(listener, strProps, fileProps)) {
                build.setResult(Result.FAILURE);
                return;
            }
            cmdLineExe.copyFrom(cmdExeUrl);
            cmdLineExeCfg.copyFrom(cmdExeCfgUrl);
            cmdLineExe2.copyFrom(cmdExe2Url);
        }
        catch (IOException | InterruptedException e) {
            build.setResult(Result.FAILURE);
            listener.error("Failed to copy props file or UFT tools to agent machine. " + String.valueOf(e));
        }
        try {
            AlmToolsUtils.runOnBuildEnv(build, launcher, listener, cmdLineExe, propsFileName, currNode, this.runFromFileModel.getOutEncoding());
        }
        catch (IOException ioe) {
            Util.displayIOException((IOException)ioe, (TaskListener)listener);
            build.setResult(Result.FAILURE);
            listener.error("Failed running HpToolsLauncher " + ioe.getMessage());
        }
        catch (InterruptedException e) {
            build.setResult(Result.ABORTED);
            listener.error("Failed running HpToolsLauncher - build aborted " + org.apache.commons.lang3.StringUtils.defaultString((String)e.getMessage()));
            try {
                AlmToolsUtils.runHpToolsAborterOnBuildEnv(build, launcher, listener, propsFileName, workspace);
            }
            catch (IOException e1) {
                Util.displayIOException((IOException)e1, (TaskListener)listener);
                build.setResult(Result.FAILURE);
            }
            catch (InterruptedException e1) {
                listener.error("Failed running HpToolsAborter " + e1.getMessage());
            }
        }
    }

    public MCServerSettingsModel getMCServerSettingsModel() {
        for (MCServerSettingsModel mcServer : this.getDescriptor().getMcServers()) {
            if (this.runFromFileModel == null || this.runFromFileModel.getMcServerName() == null || mcServer.getMcServerName() == null || !this.runFromFileModel.getMcServerName().equals(mcServer.getMcServerName())) continue;
            return mcServer;
        }
        return null;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public RunFromFileSystemModel getRunFromFileModel() {
        return this.runFromFileModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRunResultsFileName() {
        RunFromFileBuilder runFromFileBuilder = this;
        synchronized (runFromFileBuilder) {
            long threadId = Thread.currentThread().getId();
            String fileName = this.resultFileNames.get(threadId);
            return fileName;
        }
    }

    public boolean isAreParametersEnabled() {
        return this.areParametersEnabled;
    }

    public void setAreParametersEnabled(boolean areParametersEnabled) {
        this.areParametersEnabled = areParametersEnabled;
    }

    public SpecifyParametersModel getSpecifyParametersModel() {
        return this.specifyParametersModel;
    }

    @Symbol(value={"runFromFSBuilder"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        JobConfigurationProxy instance = JobConfigurationProxy.getInstance();

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @JavaScriptMethod
        public Map<String, String> getJobId(String mcUrl, String mcUserName, String mcPassword, String accessKey, String authType, boolean useProxyAuth, String proxyAddress, String proxyUserName, String proxyPassword, String previousJobId) {
            AuthModel authModel = new AuthModel(mcUserName, mcPassword, accessKey, authType);
            ProxySettings proxy = new ProxySettings(useProxyAuth, proxyAddress, proxyUserName, proxyPassword);
            Map<String, String> map = new HashMap<String, String>();
            String jobIdKey = "jobId";
            try {
                JSONObject jobJSON;
                JSONObject loginJson = this.instance.loginToMC(mcUrl, authModel, proxy);
                Map<String, String> initHeaders = this.instance.initHeaders(authModel, loginJson);
                if (initHeaders != null) {
                    map = initHeaders;
                    boolean serverOnSaaS = this.instance.isServerOnSaaS(initHeaders, mcUrl, proxy);
                    map.put("isSaaS", String.valueOf(serverOnSaaS));
                    if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)accessKey)) {
                        AtomicReference<String> tenantIdValue = new AtomicReference<String>("");
                        Arrays.stream(accessKey.split(";")).forEach(str -> {
                            if (str.toLowerCase().contains("tenant")) {
                                tenantIdValue.set(str.substring(8));
                            }
                        });
                        if (tenantIdValue.get() != null) {
                            map.put("TENANT_ID_COOKIE", tenantIdValue.get());
                        }
                    }
                }
                String jobId = null != previousJobId && !previousJobId.isEmpty() ? ((jobJSON = this.instance.getJobByIdWithHeaders(mcUrl, proxy, previousJobId, initHeaders)) != null && previousJobId.equals(jobJSON.getAsString("id")) ? previousJobId : this.instance.createTempJobWithHeaders(mcUrl, proxy, initHeaders)) : this.instance.createTempJobWithHeaders(mcUrl, proxy, initHeaders);
                map.put(jobIdKey, jobId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return map;
        }

        @JavaScriptMethod
        public JSONArray getValidWorkspaces(String mcUrl, String authType, String mcUserName, String mcPassword, String mcExecToken, boolean useProxy, String proxyAddress, boolean useAuthentication, String proxyUserName, String proxyPassword) {
            JSONArray workspaces = null;
            for (MCServerSettingsModel mcServer : this.getMcServers()) {
                if (StringUtils.isNullOrEmpty(mcUrl) || !mcUrl.equals(mcServer.getMcServerName())) continue;
                mcUrl = mcServer.getMcServerUrl();
            }
            AuthModel authModel = new AuthModel(mcUserName, mcPassword, mcExecToken, authType);
            ProxySettings proxySettings = new ProxySettings(useAuthentication, proxyAddress, proxyUserName, proxyPassword);
            try {
                JobConfigurationProxy job = JobConfigurationProxy.getInstance();
                workspaces = job.getAllValidWorkspaces(mcUrl, authModel, proxySettings);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.changeResult(workspaces);
        }

        private JSONArray changeResult(JSONArray workspaces) {
            JSONArray result = new JSONArray();
            if (workspaces != null) {
                for (int i = 0; i < workspaces.size(); ++i) {
                    JSONObject workspace = (JSONObject)workspaces.get(i);
                    if (workspace.getAsString("name").equals("Shared assets")) continue;
                    result.add((Object)workspace);
                }
            }
            return result;
        }

        @JavaScriptMethod
        public JSONObject populateAppAndDevice(String mcUrl, String mcUserName, String mcPassword, String accessKey, String authType, boolean useProxyAuth, String proxyAddress, String proxyUserName, String proxyPassword, String jobId) {
            AuthModel authModel = new AuthModel(mcUserName, mcPassword, accessKey, authType);
            ProxySettings proxy = new ProxySettings(useProxyAuth, proxyAddress, proxyUserName, proxyPassword);
            return this.instance.getJobJSONData(mcUrl, authModel, proxy, jobId);
        }

        @JavaScriptMethod
        public String getMcServerUrl(String serverName) {
            MCServerSettingsModel[] servers;
            String serverUrl = "";
            for (MCServerSettingsModel mcServer : servers = MCServerSettingsGlobalConfiguration.getInstance().getInstallations()) {
                if (!mcServer.getMcServerName().equals(serverName)) continue;
                serverUrl = mcServer.getMcServerUrl().trim();
                break;
            }
            return serverUrl;
        }

        @JavaScriptMethod
        public JSONObject getBrowserLab(String serverName, String accessKey, boolean useProxyAuth, String proxyAddr, String proxyUserName, String proxyPassword) {
            String serverUrl = this.getMcServerUrl(serverName);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)serverUrl)) {
                serverUrl = org.apache.commons.lang3.StringUtils.stripEnd((String)serverUrl, (String)"/");
                ProxySettings proxy = new ProxySettings(useProxyAuth, proxyAddr, proxyUserName, proxyPassword);
                return this.instance.getBrowserLab(serverUrl, accessKey, proxy);
            }
            return null;
        }

        public String getDisplayName() {
            return Messages.RunFromFileBuilderStepName(Messages.CompanyName());
        }

        public FormValidation doCheckFsTests(@QueryParameter String value) {
            return FormValidation.ok();
        }

        public FormValidation doCheckIgnoreErrorStrings(@QueryParameter String value) {
            return FormValidation.ok();
        }

        public FormValidation doCheckFsTimeout(@QueryParameter String value) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)value)) {
                return FormValidation.ok();
            }
            String sanitizedValue = value.trim();
            if (sanitizedValue.length() > 0 && sanitizedValue.charAt(0) == '-') {
                sanitizedValue = sanitizedValue.substring(1);
            }
            if (!this.isParameterizedValue(sanitizedValue) && !org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)sanitizedValue)) {
                return FormValidation.error((String)"Timeout must be a parameter or a number, e.g.: 23, $Timeout or ${Timeout}.");
            }
            return FormValidation.ok();
        }

        public boolean hasMCServers() {
            return MCServerSettingsGlobalConfiguration.getInstance().hasMCServers();
        }

        public MCServerSettingsModel[] getMcServers() {
            MCServerSettingsModel emptySrv = new MCServerSettingsModel("", "");
            MCServerSettingsModel[] servers = MCServerSettingsGlobalConfiguration.getInstance().getInstallations();
            if (servers == null) {
                servers = new MCServerSettingsModel[]{};
            }
            int nbOfServers = servers.length;
            MCServerSettingsModel[] all = new MCServerSettingsModel[nbOfServers + 1];
            all[0] = emptySrv;
            for (int i = 0; i < servers.length; ++i) {
                all[i + 1] = servers[i];
            }
            return all;
        }

        public FormValidation doCheckControllerPollingInterval(@QueryParameter String value) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)value)) {
                return FormValidation.ok();
            }
            if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)value)) {
                return FormValidation.error((String)"Controller Polling Interval must be a number");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPerScenarioTimeOut(@QueryParameter String value) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)value)) {
                return FormValidation.ok();
            }
            if (!this.isParameterizedValue(value) && !org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)value)) {
                return FormValidation.error((String)"Per Scenario Timeout must be a parameter or a number, e.g.: 23, $ScenarioDuration or ${ScenarioDuration}.");
            }
            return FormValidation.ok();
        }

        public boolean isParameterizedValue(String value) {
            return value.matches("^\\$\\{[\\w-. ]*}$|^\\$[\\w-.]*$");
        }

        public List<EnumDescription> getFsUftRunModes() {
            return RunFromFileSystemModel.fsUftRunModes;
        }

        public List<EnumDescription> getFsTestTypes() {
            return UftSettingsModel.fsTestTypes;
        }

        public List<String> getNodes() {
            return UftToolUtils.getNodesList();
        }

        public List<String> getEncodings() {
            return RunFromFileSystemModel.encodings;
        }

        public boolean getHasConfigurePermission() {
            return JenkinsUtils.hasItemConfigurePermission();
        }
    }
}

