/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.microfocus.application.automation.tools.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import jenkins.tasks.SimpleBuildStep;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class RunFromCodelessBuilder
extends Builder
implements SimpleBuildStep {
    private static final String RUN_MSG_TEMPLATE = "Running codeless for test: %s, path: %s%n";
    private static final String RESULT_MSG_TEMPLATE = "Codeless returned code: %d%n";
    private static final String CODELESS_BATCH_FILE = "CodelessExecuter.bat";

    @DataBoundConstructor
    public RunFromCodelessBuilder() {
    }

    public void perform(@NonNull Run<?, ?> build, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener taskListener) throws InterruptedException, IOException {
        FilePath parentFolder = workspace.child(String.format("codeless_%s", build.getNumber()));
        if (!parentFolder.exists()) {
            taskListener.getLogger().println(RunFromCodelessBuilder.class.getSimpleName() + " : No codeless tests were found");
            return;
        }
        FilePath[] list = parentFolder.list("mbt.json");
        if (list.length == 0) {
            taskListener.getLogger().println(RunFromCodelessBuilder.class.getSimpleName() + " : mbt.json file was not found");
            return;
        }
        FilePath mbtJsonFile = list[0];
        JSONArray mbtJsonArr = (JSONArray)JSONValue.parse((InputStream)mbtJsonFile.read());
        PrintStream out = taskListener.getLogger();
        Result currentResult = Result.NOT_BUILT;
        for (Object o : mbtJsonArr) {
            JSONObject jsonObject = (JSONObject)o;
            String testName = jsonObject.getAsString("testName");
            String filePath = jsonObject.getAsString("path");
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(CODELESS_BATCH_FILE);
            args.add(filePath);
            try {
                out.printf(RUN_MSG_TEMPLATE, testName, filePath);
                int returnCode = launcher.launch().cmds(args).stdout((OutputStream)out).pwd(parentFolder).join();
                out.printf(RESULT_MSG_TEMPLATE, returnCode);
                currentResult = this.getResultFromCodeless(returnCode, currentResult);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)taskListener);
                build.setResult(Result.FAILURE);
                taskListener.error("Failed running {} with exception {}", new Object[]{CODELESS_BATCH_FILE, e});
            }
            catch (InterruptedException e) {
                build.setResult(Result.ABORTED);
                taskListener.error("Failed running {} - build aborted {}", new Object[]{CODELESS_BATCH_FILE, e});
                Thread.currentThread().interrupt();
            }
        }
        build.setResult(currentResult);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private Result getResultFromCodeless(int reportCode, Result currentResult) {
        Result codelessResult = this.convertReportCode(reportCode);
        if (currentResult.equals(Result.NOT_BUILT)) {
            return codelessResult;
        }
        if (currentResult.equals(Result.SUCCESS) && codelessResult.equals(Result.FAILURE) || currentResult.equals(Result.FAILURE) && codelessResult.equals(Result.SUCCESS)) {
            return Result.UNSTABLE;
        }
        return codelessResult;
    }

    private Result convertReportCode(int reportCode) {
        switch (reportCode) {
            case 0: {
                return Result.SUCCESS;
            }
            case 1: {
                return Result.FAILURE;
            }
            case -1: {
                return Result.ABORTED;
            }
        }
        return Result.SUCCESS;
    }

    @Symbol(value={"runFromCodelessBuilder"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.RunFromCodelessBuilderStepName(Messages.CompanyName());
        }
    }
}

