/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.microfocus.application.automation.tools.AlmToolsUtils;
import com.microfocus.application.automation.tools.EncryptionUtils;
import com.microfocus.application.automation.tools.JenkinsUtils;
import com.microfocus.application.automation.tools.Messages;
import com.microfocus.application.automation.tools.model.AlmServerSettingsModel;
import com.microfocus.application.automation.tools.model.CredentialsModel;
import com.microfocus.application.automation.tools.model.CredentialsScope;
import com.microfocus.application.automation.tools.model.EnumDescription;
import com.microfocus.application.automation.tools.model.RunFromAlmModel;
import com.microfocus.application.automation.tools.model.SSOCredentialsModel;
import com.microfocus.application.automation.tools.run.AlmRunTypes;
import com.microfocus.application.automation.tools.settings.AlmServerSettingsGlobalConfiguration;
import com.microfocus.application.automation.tools.uft.model.FilterTestsModel;
import com.microfocus.application.automation.tools.uft.model.SpecifyParametersModel;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class RunFromAlmBuilder
extends Builder
implements SimpleBuildStep {
    public RunFromAlmModel runFromAlmModel;
    private boolean isFilterTestsEnabled;
    private boolean areParametersEnabled;
    private FilterTestsModel filterTestsModel;
    private SpecifyParametersModel specifyParametersModel;
    private static final String HP_TOOLS_LAUNCHER_EXE = "HpToolsLauncher.exe";
    private static final String HP_TOOLS_LAUNCHER_EXE_CFG = "HpToolsLauncher.exe.config";
    private String resultsFileName = "ApiResults.xml";
    private AlmServerSettingsModel almServerSettingsModel;

    @DataBoundConstructor
    public RunFromAlmBuilder(String almServerName, String almCredentialsScope, String almUserName, String almPassword, String almDomain, String almProject, String almTestSets, String almRunResultsMode, String almTimeout, String almRunMode, String almRunHost, String almClientID, String almApiKey, boolean isSSOEnabled, boolean isFilterTestsEnabled, boolean areParametersEnabled, FilterTestsModel filterTestsModel, SpecifyParametersModel specifyParametersModel, AlmServerSettingsModel almServerSettingsModel) {
        this.isFilterTestsEnabled = isFilterTestsEnabled;
        this.areParametersEnabled = areParametersEnabled;
        this.filterTestsModel = filterTestsModel;
        this.specifyParametersModel = specifyParametersModel;
        this.almServerSettingsModel = almServerSettingsModel;
        CredentialsScope almCredScope = StringUtils.isBlank((String)almCredentialsScope) ? this.findMostSuitableCredentialsScope(almServerName, almUserName, almClientID, isSSOEnabled) : CredentialsScope.valueOf(almCredentialsScope.toUpperCase());
        this.runFromAlmModel = new RunFromAlmModel(almServerName, almUserName, almPassword, almDomain, almProject, almTestSets, almRunResultsMode, almTimeout, almRunMode, almRunHost, isSSOEnabled, almClientID, almApiKey, almCredScope);
    }

    public CredentialsScope getCredentialsScopeOrDefault() {
        CredentialsScope scope = this.runFromAlmModel.getCredentialsScope();
        return scope == null ? this.findMostSuitableCredentialsScope(this.getAlmServerName(), this.getAlmUserName(), this.getAlmClientID(), this.getIsSSOEnabled()) : scope;
    }

    private AlmServerSettingsModel findAlmServerSettingsModel(String serverName) {
        Stream<AlmServerSettingsModel> models = Arrays.stream(AlmServerSettingsGlobalConfiguration.getInstance().getInstallations());
        return models.filter(m -> m.getAlmServerName().equals(serverName)).findFirst().orElse(null);
    }

    private boolean isUserNameDefinedAtSystemLevel(String serverName, String userName) {
        AlmServerSettingsModel model = this.findAlmServerSettingsModel(serverName);
        if (model != null) {
            return model.getAlmCredentials().stream().anyMatch(c -> c.getAlmUsername().equals(userName));
        }
        return false;
    }

    private boolean isClientIdDefinedAtSystemLevel(String serverName, String clientId) {
        AlmServerSettingsModel model = this.findAlmServerSettingsModel(serverName);
        if (model != null) {
            return model.getAlmSSOCredentials().stream().anyMatch(c -> c.getAlmClientID().equals(clientId));
        }
        return false;
    }

    private CredentialsScope findMostSuitableCredentialsScope(String serverName, String userName, String clientId, boolean isSSOEnabled) {
        if (isSSOEnabled) {
            return this.isClientIdDefinedAtSystemLevel(serverName, clientId) ? CredentialsScope.SYSTEM : CredentialsScope.JOB;
        }
        return this.isUserNameDefinedAtSystemLevel(serverName, userName) ? CredentialsScope.SYSTEM : CredentialsScope.JOB;
    }

    public String getAlmServerName() {
        return this.runFromAlmModel.getAlmServerName();
    }

    public boolean getIsSSOEnabled() {
        return this.runFromAlmModel.isSSOEnabled();
    }

    public void setIsSSOEnabled(Boolean isSSOEnabled) {
        this.runFromAlmModel.setIsSSOEnabled(isSSOEnabled);
    }

    @DataBoundSetter
    public void setAlmServerSettingsModel(AlmServerSettingsModel almServerSettingsModel) {
        this.almServerSettingsModel = almServerSettingsModel;
    }

    public String getAlmCredentialsScope() {
        return this.runFromAlmModel.getCredentialsScopeValue();
    }

    public String getAlmUserName() {
        return this.runFromAlmModel.getAlmUserName();
    }

    public String getAlmPassword() {
        return this.runFromAlmModel.getPasswordEncryptedValue();
    }

    public String getAlmClientID() {
        return this.runFromAlmModel.getAlmClientID();
    }

    public String getAlmApiKey() {
        return this.runFromAlmModel.getApiKeyEncryptedValue();
    }

    public String getAlmDomain() {
        return this.runFromAlmModel.getAlmDomain();
    }

    public String getAlmProject() {
        return this.runFromAlmModel.getAlmProject();
    }

    public String getAlmTestSets() {
        return this.runFromAlmModel.getAlmTestSets();
    }

    public String getAlmRunResultsMode() {
        return this.runFromAlmModel.getAlmRunResultsMode();
    }

    public String getAlmTimeout() {
        return this.runFromAlmModel.getAlmTimeout();
    }

    public String getAlmRunMode() {
        return this.runFromAlmModel.getAlmRunMode();
    }

    public String getAlmRunHost() {
        return this.runFromAlmModel.getAlmRunHost();
    }

    public boolean getIsFilterTestsEnabled() {
        return this.isFilterTestsEnabled;
    }

    @DataBoundSetter
    public void setIsFilterTestsEnabled(boolean isFilterTestsEnabled) {
        this.isFilterTestsEnabled = isFilterTestsEnabled;
    }

    public FilterTestsModel getFilterTestsModel() {
        return this.filterTestsModel;
    }

    @DataBoundSetter
    public void setFilterTestsModel(FilterTestsModel filterTestsModel) {
        this.filterTestsModel = filterTestsModel;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String strProps;
        EnvVars env;
        AlmServerSettingsModel almServerSettingsModel = this.getAlmServerSettingsModel();
        if (almServerSettingsModel == null) {
            listener.fatalError("An ALM server is not defined. Go to Manage Jenkins->Configure System and define your ALM server under OpenText\\u2122 Application Quality Management");
            build.setResult(Result.FAILURE);
            return;
        }
        Node currNode = JenkinsUtils.getCurrentNode(workspace);
        if (currNode == null) {
            listener.error("Failed to get current executor node.");
            return;
        }
        try {
            env = build.getEnvironment(listener);
        }
        catch (IOException e2) {
            throw new IOException("Env Null - something went wrong with fetching jenkins build environment");
        }
        VariableResolver.ByMap varResolver = new VariableResolver.ByMap((Map)build.getEnvironment(listener));
        Properties mergedProps = new Properties();
        mergedProps.putAll((Map<?, ?>)almServerSettingsModel.getProperties());
        mergedProps.putAll((Map<?, ?>)this.runFromAlmModel.getProperties(env, (VariableResolver<String>)varResolver));
        CredentialsScope scope = this.getCredentialsScopeOrDefault();
        try {
            Optional<CredentialsModel> cred;
            String almPassword = this.runFromAlmModel.getPasswordPlainText();
            if (scope == CredentialsScope.SYSTEM && (cred = almServerSettingsModel.getAlmCredentials().stream().filter(c -> c.getAlmUsername().equals(this.runFromAlmModel.getAlmUserName())).findFirst()).isPresent()) {
                almPassword = cred.get().getAlmPasswordPlainText();
            }
            String encAlmPass = EncryptionUtils.encrypt(almPassword, currNode);
            mergedProps.remove("almPassword");
            mergedProps.put("almPassword", encAlmPass);
        }
        catch (Exception e) {
            build.setResult(Result.FAILURE);
            listener.fatalError("Issue with ALM Password encryption: " + e.getMessage() + ".");
            return;
        }
        try {
            Optional<SSOCredentialsModel> cred;
            String almApiKeySecret = this.runFromAlmModel.getApiKeyPlainText();
            if (scope == CredentialsScope.SYSTEM && (cred = almServerSettingsModel.getAlmSSOCredentials().stream().filter(c -> c.getAlmClientID().equals(this.runFromAlmModel.getAlmClientID())).findFirst()).isPresent()) {
                almApiKeySecret = cred.get().getAlmApiKeySecretPlainText();
            }
            String encAlmApiKey = EncryptionUtils.encrypt(almApiKeySecret, currNode);
            mergedProps.remove("almApiKeySecret");
            mergedProps.put("almApiKeySecret", encAlmApiKey);
            mergedProps.put("almClientID", this.getAlmClientID());
        }
        catch (Exception e) {
            build.setResult(Result.FAILURE);
            listener.fatalError("Issue with apiKey encryption: " + e.getMessage() + ".");
            return;
        }
        if (this.isFilterTestsEnabled) {
            this.filterTestsModel.addProperties(mergedProps);
        } else {
            mergedProps.put("FilterTests", "false");
        }
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("ddMMyyyyHHmmssSSS");
        String time = formatter.format((Object)now);
        String propsFileName = String.format("props%s.txt", time);
        this.resultsFileName = String.format("Results%s_%d.xml", time, build.getNumber());
        ParametersAction parameterAction = (ParametersAction)build.getAction(ParametersAction.class);
        ArrayList<StringParameterValue> newParams = parameterAction != null ? new ArrayList<StringParameterValue>(parameterAction.getAllParameters()) : new ArrayList();
        newParams.add(new StringParameterValue("buildStepName", "RunFromAlmBuilder"));
        newParams.add(new StringParameterValue("resultsFilename", this.resultsFileName));
        build.addOrReplaceAction((Action)new ParametersAction(newParams));
        mergedProps.put("runType", AlmRunTypes.RunType.Alm.toString());
        mergedProps.put("resultsFilename", this.resultsFileName);
        if (this.areParametersEnabled) {
            try {
                this.specifyParametersModel.addProperties(mergedProps, "TestSet", currNode);
            }
            catch (Exception e) {
                listener.error("Error occurred while parsing parameter input, reverting back to empty array.");
            }
        }
        try {
            strProps = AlmToolsUtils.getPropsAsString(mergedProps);
        }
        catch (IOException e) {
            build.setResult(Result.FAILURE);
            listener.error("Failed to store properties on agent machine: " + String.valueOf(e));
            return;
        }
        URL cmdExeUrl = Hudson.getInstance().pluginManager.uberClassLoader.getResource(HP_TOOLS_LAUNCHER_EXE);
        if (cmdExeUrl == null) {
            build.setResult(Result.FAILURE);
            listener.fatalError("HpToolsLauncher.exe not found in resources");
            return;
        }
        URL cmdExeCfgUrl = Hudson.getInstance().pluginManager.uberClassLoader.getResource(HP_TOOLS_LAUNCHER_EXE_CFG);
        if (cmdExeCfgUrl == null) {
            build.setResult(Result.FAILURE);
            listener.fatalError("HpToolsLauncher.exe.config not found in resources");
            return;
        }
        FilePath fileProps = workspace.child(propsFileName);
        FilePath cmdLineExe = workspace.child(HP_TOOLS_LAUNCHER_EXE);
        FilePath cmdLineExeCfg = workspace.child(HP_TOOLS_LAUNCHER_EXE_CFG);
        try {
            if (!AlmToolsUtils.tryCreatePropsFile(listener, strProps, fileProps)) {
                build.setResult(Result.FAILURE);
                return;
            }
            cmdLineExe.copyFrom(cmdExeUrl);
            cmdLineExeCfg.copyFrom(cmdExeCfgUrl);
        }
        catch (IOException | InterruptedException e) {
            build.setResult(Result.FAILURE);
            listener.error("Failed to copy props file or Functional Testing tools to agent machine. " + String.valueOf(e));
            return;
        }
        try {
            AlmToolsUtils.runOnBuildEnv(build, launcher, listener, cmdLineExe, propsFileName, currNode);
        }
        catch (IOException ioe) {
            Util.displayIOException((IOException)ioe, (TaskListener)listener);
            build.setResult(Result.FAILURE);
        }
        catch (InterruptedException e) {
            build.setResult(Result.ABORTED);
            try {
                AlmToolsUtils.runHpToolsAborterOnBuildEnv(build, launcher, listener, propsFileName, workspace);
            }
            catch (IOException e1) {
                Util.displayIOException((IOException)e1, (TaskListener)listener);
                build.setResult(Result.FAILURE);
            }
            catch (InterruptedException e1) {
                listener.error("Failed running HpToolsAborter " + e1.getMessage());
            }
        }
    }

    public AlmServerSettingsModel getAlmServerSettingsModel() {
        if (this.runFromAlmModel != null) {
            return this.findAlmServerSettingsModel(this.getAlmServerName());
        }
        return null;
    }

    public RunFromAlmModel getRunFromAlmModel() {
        return this.runFromAlmModel;
    }

    public boolean isAreParametersEnabled() {
        return this.areParametersEnabled;
    }

    public void setAreParametersEnabled(boolean areParametersEnabled) {
        this.areParametersEnabled = areParametersEnabled;
    }

    public SpecifyParametersModel getSpecifyParametersModel() {
        return this.specifyParametersModel;
    }

    public String getRunResultsFileName() {
        return this.resultsFileName;
    }

    @Extension
    @Symbol(value={"runFromAlmBuilder"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.RunFromAlmBuilderStepName(Messages.CompanyName());
        }

        public boolean hasAlmServers() {
            return AlmServerSettingsGlobalConfiguration.getInstance().hasAlmServers();
        }

        public Stream<AlmServerSettingsModel> getAlmServers() {
            return Arrays.stream(AlmServerSettingsGlobalConfiguration.getInstance().getInstallations()).sorted();
        }

        private AlmServerSettingsModel findAlmServer(String almServerName) {
            return StringUtils.isBlank((String)almServerName) ? (AlmServerSettingsModel)this.getAlmServers().findFirst().orElse(null) : (AlmServerSettingsModel)this.getAlmServers().filter(s -> s.getAlmServerName().equals(almServerName)).findFirst().orElse(null);
        }

        public ListBoxModel doFillAlmServerNameItems(@AncestorInPath Item item) {
            ListBoxModel m = new ListBoxModel();
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return m;
            }
            this.getAlmServers().forEachOrdered(s -> m.add(s.getAlmServerName()));
            return m;
        }

        public ListBoxModel doFillAlmUserNameItems(@QueryParameter String almServerName, @AncestorInPath Item item) {
            ListBoxModel m = new ListBoxModel();
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return m;
            }
            if (this.hasAlmServers()) {
                AlmServerSettingsModel model = this.findAlmServer(almServerName);
                if (model != null && !model.getAlmCredentials().isEmpty()) {
                    model.getAlmCredentials().forEach(cm -> m.add(cm.getAlmUsername()));
                } else if (StringUtils.isNotBlank((String)almServerName)) {
                    m.add("No username defined in Jenkins Configure System page");
                }
            }
            return m;
        }

        public ListBoxModel doFillAlmClientIDItems(@QueryParameter String almServerName, @AncestorInPath Item item) {
            ListBoxModel m = new ListBoxModel();
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return m;
            }
            if (this.hasAlmServers()) {
                AlmServerSettingsModel model = this.findAlmServer(almServerName);
                if (model != null && !model.getAlmSSOCredentials().isEmpty()) {
                    model.getAlmSSOCredentials().forEach(cm -> m.add(cm.getAlmClientID()));
                } else {
                    m.add("No client ID defined in Jenkins Configure System page");
                }
            }
            return m;
        }

        public FormValidation doCheckAlmTimeout(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            String val1 = value.trim();
            if (val1.length() > 0 && val1.charAt(0) == '-') {
                val1 = val1.substring(1);
            }
            if (!StringUtils.isNumeric((String)val1) && !val1.equals("")) {
                return FormValidation.error((String)"Timeout value must be a number");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAlmDomain(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Domain must be set");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAlmProject(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Project must be set");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAlmTestSets(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Test sets are missing");
            }
            String[] testSetsArr = value.replaceAll("\r", "").split("\n");
            for (int i = 0; i < testSetsArr.length; ++i) {
                if (!StringUtils.isBlank((String)testSetsArr[i])) continue;
                return FormValidation.error((String)"Test sets should not contains empty lines");
            }
            return FormValidation.ok();
        }

        public List<EnumDescription> getAlmRunModes() {
            return RunFromAlmModel.runModes;
        }

        public List<CredentialsScope> getAlmCredentialScopes() {
            return Arrays.asList(CredentialsScope.values());
        }

        public boolean getHasConfigurePermission() {
            return JenkinsUtils.hasItemConfigurePermission();
        }
    }
}

