/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LrScriptResultsParser {
    public static final String LR_SCRIPT_RESULT_FILENAME = "Results.xml";
    public static final String LR_SCRIPT_PASSED_STATUS = "Passed";
    public static final String LR_SCRIPT_REPORT_PASSED_STATUS = "passed";
    public static final String LR_SCRIPT_REPORT_FAILED_STATUS = "failed";
    private TaskListener _logger;
    private String _scriptName;

    public LrScriptResultsParser(TaskListener listener) {
        this._logger = listener;
    }

    public void parseScriptResult(String scriptName, FilePath workspace) throws InterruptedException {
        this._scriptName = scriptName;
        this.invoke(workspace);
    }

    public void invoke(FilePath ws_filePath) throws InterruptedException {
        FilePath sourceFile = ws_filePath.child(this._scriptName).child(LR_SCRIPT_RESULT_FILENAME);
        FilePath targetFile = ws_filePath.child(this._scriptName).child("JunitResult.xml");
        this.parse(sourceFile, targetFile);
    }

    public void parse(FilePath scriptName, FilePath outputFile) throws InterruptedException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        try {
            dbFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(scriptName.read());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Document newDoc = dbf.newDocumentBuilder().newDocument();
            doc.getDocumentElement().normalize();
            NodeList actionNodes = doc.getElementsByTagName("Action");
            Element testSuits = newDoc.createElement("testsuites");
            LrScriptResultsParser.parseScriptAction(newDoc, actionNodes, testSuits, scriptName.getParent().getBaseName());
            Element reportSummaryNode = (Element)doc.getElementsByTagName("Summary").item(actionNodes.getLength());
            testSuits.setAttribute(LR_SCRIPT_REPORT_PASSED_STATUS, reportSummaryNode.getAttribute(LR_SCRIPT_REPORT_PASSED_STATUS));
            testSuits.setAttribute("failures", reportSummaryNode.getAttribute(LR_SCRIPT_REPORT_FAILED_STATUS));
            testSuits.setAttribute("name", scriptName.getParent().getBaseName());
            testSuits.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            testSuits.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            int tests = Integer.parseInt(reportSummaryNode.getAttribute(LR_SCRIPT_REPORT_FAILED_STATUS)) + Integer.parseInt(reportSummaryNode.getAttribute(LR_SCRIPT_REPORT_PASSED_STATUS));
            testSuits.setAttribute("tests", String.valueOf(tests));
            newDoc.appendChild(testSuits);
            newDoc.setXmlVersion("1.0");
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(newDoc);
            StreamResult result = new StreamResult(outputFile.write());
            transformer.transform(source, result);
        }
        catch (SAXException e) {
            this.log("XML reader error");
            this.log(e);
        }
        catch (ParserConfigurationException e) {
            this.log("XML parser error");
            this.log(e);
        }
        catch (IOException e) {
            this.log("IO error");
            this.log(e);
        }
        catch (TransformerConfigurationException tce) {
            this.log("* Transformer Factory error");
            this.log(" " + tce.getMessage());
            Throwable x = tce;
            if (tce.getException() != null) {
                x = tce.getException();
            }
            this.log(x);
        }
        catch (TransformerException te) {
            this.log("* Transformation error");
            this.log(" " + te.getMessage());
            Throwable x = te;
            if (te.getException() != null) {
                x = te.getException();
            }
            this.log(x);
        }
    }

    private void log(Object msg) {
        this._logger.error(msg.toString());
    }

    private static void parseScriptAction(Document newDoc, NodeList actionNodes, Element rootnode, String scriptName) {
        for (int i = 0; i < actionNodes.getLength(); ++i) {
            Element action = (Element)actionNodes.item(i);
            NodeList actionProps = action.getElementsByTagName("AName");
            Element actionName = (Element)actionProps.item(0);
            Element testSuite = newDoc.createElement("testsuite");
            String suiteName = LrScriptResultsParser.getCharacterDataFromElement(actionName);
            testSuite.setAttribute("name", suiteName);
            NodeList stepNodes = action.getElementsByTagName("Step");
            LrScriptResultsParser.parseScriptActionStep(newDoc, testSuite, stepNodes, scriptName + "." + suiteName);
            Element suiteSummaryNode = (Element)action.getElementsByTagName("Summary").item(0);
            testSuite.setAttribute(LR_SCRIPT_REPORT_PASSED_STATUS, suiteSummaryNode.getAttribute(LR_SCRIPT_REPORT_PASSED_STATUS));
            testSuite.setAttribute("failures", suiteSummaryNode.getAttribute(LR_SCRIPT_REPORT_FAILED_STATUS));
            int tests = Integer.parseInt(suiteSummaryNode.getAttribute(LR_SCRIPT_REPORT_FAILED_STATUS)) + Integer.parseInt(suiteSummaryNode.getAttribute(LR_SCRIPT_REPORT_PASSED_STATUS));
            testSuite.setAttribute("package", scriptName);
            testSuite.setAttribute("tests", String.valueOf(tests));
            if (tests <= 0) continue;
            rootnode.appendChild(testSuite);
        }
    }

    private static void parseScriptActionStep(Document newDoc, Element testSuite, NodeList stepNodes, String className) {
        for (int j = 0; j < stepNodes.getLength(); ++j) {
            Element step = (Element)stepNodes.item(j);
            Element objNode = (Element)step.getElementsByTagName("Obj").item(0);
            Element testCase = newDoc.createElement("testcase");
            testCase.setAttribute("name", LrScriptResultsParser.getStepDataFromElement(objNode));
            Element nodeArgs = (Element)step.getElementsByTagName("NodeArgs").item(0);
            String stepStatus = nodeArgs.getAttribute("status");
            if (stepStatus.equals(LR_SCRIPT_PASSED_STATUS)) {
                stepStatus = "pass";
            } else {
                stepStatus = "fail";
                Element failureMessage = newDoc.createElement("failure");
                failureMessage.setAttribute("message", "");
                testCase.appendChild(failureMessage);
            }
            testCase.setAttribute("status", stepStatus);
            testCase.setAttribute("classname", className);
            testSuite.appendChild(testCase);
        }
    }

    private static String getStepDataFromElement(Element e) {
        String stepName = LrScriptResultsParser.getCharacterDataFromElement(e);
        stepName = stepName.replace("Url: ", "");
        return stepName;
    }

    private static String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "";
    }

    public void parse(File scriptName, File outputFile) throws InterruptedException {
        this.parse(new FilePath(scriptName.getAbsoluteFile()), new FilePath(outputFile.getAbsoluteFile()));
    }

    public void setScriptName(String _scriptName) {
        this._scriptName = _scriptName;
    }
}

