/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.XmlFile;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class JobConfigRebrander
extends Builder
implements SimpleBuildStep {
    private static final String MICROFOCUS = ".microfocus.";
    private static final String HPE_HP_REGEX = "\\.hp\\.|\\.hpe\\.";
    private Run<?, ?> build;

    @DataBoundConstructor
    public JobConfigRebrander() {
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        File[] subdirs;
        this.build = run;
        File root = Jenkins.getInstance().getRootDir();
        this.convertXmlFilesAtRootDir(listener, root);
        File projectsDir = new File(root, "jobs");
        for (File subdir : subdirs = projectsDir.listFiles()) {
            this.convertSpecifiedXmlFile(listener, subdir, "config.xml");
            File buildsFolder = new File(subdir, "builds");
            File[] builds = buildsFolder.listFiles();
            if (builds == null) continue;
            for (File buildDir : builds) {
                this.convertSpecifiedXmlFile(listener, buildDir, "build.xml");
            }
        }
    }

    private void convertSpecifiedXmlFile(@Nonnull TaskListener listener, File dir, String xmlFileName) {
        XmlFile xmlFile = new XmlFile(new File(dir, xmlFileName));
        if (xmlFile.exists()) {
            this.convertOldNameToNewName(listener, xmlFile);
        }
    }

    private void convertXmlFilesAtRootDir(@Nonnull TaskListener listener, File root) {
        try {
            File[] files;
            for (File file : files = root.listFiles(pathname -> {
                String name = pathname.getName().toLowerCase();
                return (name.startsWith("com.hpe") || name.startsWith("com.hp")) && name.endsWith(".xml") && pathname.isFile();
            })) {
                String newFileName = file.toString().replaceAll(HPE_HP_REGEX, MICROFOCUS);
                File replacedFile = new File(newFileName);
                this.removeXmlFileIfExists(listener, newFileName, replacedFile);
                this.convertXmlFileIfNotExists(listener, file, replacedFile);
            }
        }
        catch (NullPointerException | SecurityException e) {
            listener.error("Failed to convert Global Settings configurations to microfocus: %s", new Object[]{e.getMessage()});
            this.build.setResult(Result.FAILURE);
        }
    }

    private void convertXmlFileIfNotExists(@Nonnull TaskListener listener, File file, File replacedFile) {
        if (!replacedFile.exists() && file.renameTo(replacedFile)) {
            XmlFile xmlFile = new XmlFile(replacedFile);
            this.convertOldNameToNewName(listener, xmlFile);
        }
    }

    private void removeXmlFileIfExists(@Nonnull TaskListener listener, String newFileName, File replacedFile) {
        if (replacedFile.exists()) {
            try {
                Files.delete(Paths.get(replacedFile.getAbsolutePath(), new String[0]));
            }
            catch (IOException | SecurityException e) {
                listener.error("Failed to delete %s when doing Global Settings configurations convert: %s", new Object[]{newFileName, e.getMessage()});
                this.build.setResult(Result.UNSTABLE);
            }
        }
    }

    private void convertOldNameToNewName(@Nonnull TaskListener listener, XmlFile confXmlFile) {
        try {
            String configuration = FileUtils.readFileToString((File)confXmlFile.getFile());
            String newConfiguration = configuration.replaceAll(HPE_HP_REGEX, MICROFOCUS);
            FileUtils.writeStringToFile((File)confXmlFile.getFile(), (String)newConfiguration);
        }
        catch (IOException e) {
            listener.error("Failed to convert job configuration format to microfocus: %s", new Object[]{e.getMessage()});
            this.build.setResult(Result.FAILURE);
        }
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public Descriptor() {
            this.load();
        }

        public String getDisplayName() {
            return "Fix old OpenText Jenkins builds";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return false;
        }
    }
}

