/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.microfocus.application.automation.tools.Messages;
import com.microfocus.application.automation.tools.model.AUTEnvironmentModelResolver;
import com.microfocus.application.automation.tools.model.AUTEnvironmentResolvedModel;
import com.microfocus.application.automation.tools.model.AlmServerSettingsModel;
import com.microfocus.application.automation.tools.model.AutEnvironmentModel;
import com.microfocus.application.automation.tools.settings.AlmServerSettingsGlobalConfiguration;
import com.microfocus.application.automation.tools.sse.autenvironment.AUTEnvironmentBuilderPerformer;
import com.microfocus.application.automation.tools.sse.common.StringUtils;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

public class AutEnvironmentBuilder
extends Builder {
    private final AutEnvironmentModel autEnvironmentModel;

    @DataBoundConstructor
    public AutEnvironmentBuilder(AutEnvironmentModel autEnvironmentModel) {
        this.autEnvironmentModel = autEnvironmentModel;
    }

    public AutEnvironmentModel getAutEnvironmentModel() {
        return this.autEnvironmentModel;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.autEnvironmentModel.setAlmServerUrl(this.getServerUrl(this.autEnvironmentModel.getAlmServerName()));
        PrintStream logger = listener.getLogger();
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        this.execute(build, envVars, this.autEnvironmentModel, logger);
        return true;
    }

    public String getServerUrl(String almServerName) {
        String ret = "";
        AlmServerSettingsModel[] almServers = this.getDescriptor().getAlmServers();
        if (almServers != null && almServers.length > 0) {
            for (AlmServerSettingsModel almServer : almServers) {
                if (!almServerName.equals(almServer.getAlmServerName())) continue;
                ret = almServer.getAlmServerUrl();
                break;
            }
        }
        return ret;
    }

    private void execute(AbstractBuild<?, ?> build, EnvVars envVars, AutEnvironmentModel autEnvironmentModel, final PrintStream printStreamLogger) {
        Logger logger = new Logger(){

            @Override
            public void log(String message) {
                printStreamLogger.println(message);
            }

            @Override
            public void error(String message) {
                this.log(message);
            }
        };
        try {
            VariableResolver.ByMap variableResolver = new VariableResolver.ByMap((Map)envVars);
            AUTEnvironmentResolvedModel autEnvModel = AUTEnvironmentModelResolver.resolveModel(autEnvironmentModel, (VariableResolver<String>)variableResolver);
            AUTEnvironmentBuilderPerformer performer = new AUTEnvironmentBuilderPerformer(autEnvModel, (VariableResolver<String>)variableResolver, logger);
            performer.start(envVars);
            this.assignOutputValue(build, performer, autEnvModel.getOutputParameter(), logger);
        }
        catch (Exception e) {
            logger.log(String.format("Build failed: %s", e.getMessage()));
            build.setResult(Result.FAILURE);
        }
    }

    private void assignOutputValue(AbstractBuild<?, ?> build, AUTEnvironmentBuilderPerformer performer, String outputParameterName, Logger logger) {
        if (StringUtils.isNullOrEmpty(outputParameterName)) {
            logger.log("No environment variable was specified for getting the AUT Environment Configuration ID");
            return;
        }
        ParametersAction oldParametersAction = (ParametersAction)build.getAction(ParametersAction.class);
        if (oldParametersAction != null && oldParametersAction.getParameter(outputParameterName) != null) {
            ArrayList<StringParameterValue> parametersList = new ArrayList<StringParameterValue>(oldParametersAction.getParameters());
            for (ParameterValue parameterValue : parametersList) {
                if (!parameterValue.getName().equals(outputParameterName)) continue;
                if (!(parameterValue instanceof StringParameterValue)) {
                    logger.log(String.format("Can't assign value to %s because it's type is not 'String Parameter'", outputParameterName));
                    return;
                }
                parametersList.remove(parameterValue);
                parametersList.add(new StringParameterValue(parameterValue.getName(), performer.getAutEnvironmentConfigurationIdToReturn(), parameterValue.getDescription()));
                break;
            }
            build.getActions().remove(oldParametersAction);
            build.addAction((Action)new ParametersAction(parametersList));
        } else {
            logger.log(String.format("Can't assign created AUT Environment Configuration ID to: [%s] because there's no such parameter for this build", outputParameterName));
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.AutEnvironmentBuilderStepName(Messages.CompanyName());
        }

        public AlmServerSettingsModel[] getAlmServers() {
            return AlmServerSettingsGlobalConfiguration.getInstance().getInstallations();
        }
    }
}

