/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results.service;

import com.microfocus.application.automation.tools.rest.RestClient;
import com.microfocus.application.automation.tools.results.service.rest.CreateAttachment;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import hudson.FilePath;
import hudson.model.Run;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.DirectoryScanner;

public class AttachmentUploadService {
    private Run<?, ?> run;
    private FilePath workspace;
    private RestClient restClient;
    private Logger logger;
    private static AttachmentUploadService aus;

    public static void init(Run<?, ?> run, FilePath workspace, RestClient restClient, Logger logger) {
        aus = new AttachmentUploadService(run, workspace, restClient, logger);
    }

    public static AttachmentUploadService getInstance() {
        return aus;
    }

    private AttachmentUploadService(Run<?, ?> run, FilePath workspace, RestClient restClient, Logger logger) {
        this.run = run;
        this.workspace = workspace;
        this.restClient = restClient;
        this.logger = logger;
    }

    public boolean upload(String fileName, String entityCollectionName, String entityId) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.run.getRootDir());
        ds.setIncludes(new String[]{fileName});
        ds.scan();
        boolean result = true;
        if (ds.getIncludedFilesCount() > 0) {
            for (int i = 0; i < ds.getIncludedFilesCount(); ++i) {
                String filePath = this.run.getRootDir().getAbsolutePath() + File.separator + ds.getIncludedFiles()[i];
                this.logger.log("INFO: Fould file: " + filePath);
                try (FileInputStream in = new FileInputStream(new File(filePath));){
                    result = this.upload(IOUtils.toByteArray((InputStream)in), ds.getIncludedFiles()[i], entityCollectionName, entityId);
                    continue;
                }
                catch (IOException e) {
                    this.logger.log("ERR: Read file failed. " + e.getMessage());
                    result = false;
                }
            }
        } else {
            FilePath[] fileList = new FilePath[]{};
            try {
                fileList = this.workspace.list(fileName);
            }
            catch (IOException | InterruptedException e) {
                this.logger.log("ERR: List  " + fileName + " in workspace failed. " + e.getMessage());
                result = false;
            }
            for (FilePath f : fileList) {
                this.logger.log("INFO: Fould file: " + f.getRemote() + "| name: " + f.getName());
                try (InputStream in = f.read();){
                    this.logger.log("INFO: InputSteam read get: " + in.toString());
                    result = this.upload(IOUtils.toByteArray((InputStream)in), f.getName(), entityCollectionName, entityId);
                }
                catch (IOException | InterruptedException e) {
                    this.logger.log("ERR: Read file failed. " + e.getMessage());
                    result = false;
                }
            }
        }
        return result;
    }

    private boolean upload(byte[] fileContent, String filename, String entityCollectionName, String entityId) {
        this.logger.log("INFO: Uploading file: " + filename);
        CreateAttachment ca = new CreateAttachment(entityCollectionName, this.restClient, entityId, filename, fileContent);
        Response re = ca.perform();
        if (re.getStatusCode() != 201) {
            this.logger.log("INFO: Stauts " + re.getStatusCode());
            this.logger.log("ERR: Attachment upload failed. " + String.valueOf(re.getFailure()));
            this.logger.log("ERR: " + new String(re.getData()));
            return false;
        }
        this.logger.log("INFO: Attachment upload success.");
        return true;
    }
}

