/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results.parser.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtil {
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss";

    public static SimpleDateFormat getDateFormatter() {
        return new SimpleDateFormat(DATE_FORMAT);
    }

    public static SimpleDateFormat getDateFormatter(String format) {
        return new SimpleDateFormat(format);
    }

    public static String dateToString(Date date) {
        try {
            return date == null ? "" : TimeUtil.getDateFormatter().format(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Date stringToDate(String source) {
        TimeZone localTimeZone = TimeUtil.getDateFormatter().getTimeZone();
        return TimeUtil.stringToDate(source, localTimeZone);
    }

    public static DateFormat getFullTimestampFormatter(Locale locale) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2, locale);
        String localeString = locale.toString();
        if (localeString.equals("zh_SG")) {
            return new SimpleDateFormat("dd/MM/yyyy a hh:mm");
        }
        if (localeString.equals("ko")) {
            return TimeUtil.changeDateFormatPattern(dateFormat, "y+\\. *M+\\. *d+", DATE_FORMAT);
        }
        return TimeUtil.changeDateFormatPattern(dateFormat, "y+", "yyyy");
    }

    private static DateFormat changeDateFormatPattern(DateFormat dateFormat, String regex, String replacement) {
        if (dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormat;
            String pattern = simpleDateFormat.toPattern().replaceAll(regex, replacement);
            simpleDateFormat.applyPattern(pattern);
            return simpleDateFormat;
        }
        return dateFormat;
    }

    public static SimpleDateFormat getFullTimestampFormatter() {
        return new SimpleDateFormat(DATE_TIME_FORMAT);
    }

    public static SimpleDateFormat getTimeFormatter() {
        return new SimpleDateFormat(TIME_FORMAT);
    }

    public static Date stringToDate(String source, TimeZone timeZone) {
        Date result;
        block6: {
            if (source == null) {
                throw new IllegalArgumentException("null argument not allowed");
            }
            try {
                boolean hasColon = source.indexOf(58) != -1;
                boolean hasMinusSign = source.indexOf(45) != -1;
                int length = source.length();
                if (length == DATE_TIME_FORMAT.length() || hasColon && hasMinusSign) {
                    SimpleDateFormat fullTimestampFormatter = TimeUtil.getFullTimestampFormatter();
                    fullTimestampFormatter.setTimeZone(timeZone);
                    result = fullTimestampFormatter.parse(source);
                    break block6;
                }
                if (source.length() == DATE_FORMAT.length() || hasMinusSign) {
                    SimpleDateFormat dateFormatter = TimeUtil.getDateFormatter();
                    dateFormatter.setTimeZone(timeZone);
                    result = dateFormatter.parse(source);
                    break block6;
                }
                if (source.length() == TIME_FORMAT.length() || hasColon) {
                    SimpleDateFormat timeFormatter = TimeUtil.getTimeFormatter();
                    timeFormatter.setTimeZone(timeZone);
                    result = timeFormatter.parse(source);
                    break block6;
                }
                throw new IllegalArgumentException("unsupported date format: \"" + source + "\"");
            }
            catch (ParseException e) {
                return new Date();
            }
        }
        return result;
    }

    public static String timeToString(Date date) {
        try {
            return date == null ? "" : TimeUtil.getTimeFormatter().format(date);
        }
        catch (Exception e) {
            return "";
        }
    }
}

