/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results.parser.util;

import com.microfocus.application.automation.tools.results.parser.util.TimeUtil;
import com.microfocus.application.automation.tools.results.service.almentities.AlmRun;
import com.microfocus.application.automation.tools.results.service.almentities.AlmRunImpl;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTest;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestImpl;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class ParserUtil {
    public static char nameConnector = (char)95;
    public static char[] testNameInvalidChars = new char[]{'\\', '/', ':', '\"', '?', '\'', '<', '>', '|', '*', '%'};
    public static char[] testSetNameInvalidChars = new char[]{'\\', '^', ',', '\"', '*'};

    public static String repaceInvalidChars(char[] invalidChars, char newChar, String source) {
        StringBuffer temp = new StringBuffer(source);
        for (int i = 0; i < temp.length(); ++i) {
            for (int j = 0; j < invalidChars.length; ++j) {
                if (temp.charAt(i) != invalidChars[j]) continue;
                temp.setCharAt(i, newChar);
            }
        }
        return temp.toString();
    }

    public static String replaceInvalidCharsForTestSetName(String testsetName) {
        return ParserUtil.repaceInvalidChars(testSetNameInvalidChars, nameConnector, testsetName);
    }

    public static String replaceInvalidCharsForTestName(String testName) {
        return ParserUtil.repaceInvalidChars(testNameInvalidChars, nameConnector, testName);
    }

    public static AlmTest createExternalTest(String inputClassName, String inputMethodName, String testingFramework, String testingTool) {
        AlmTestImpl test = new AlmTestImpl();
        String packageName = "";
        String className = ParserUtil.replaceInvalidCharsForTestName(inputClassName);
        String methodName = ParserUtil.replaceInvalidCharsForTestName(inputMethodName);
        String temp = className;
        int indexDot = temp.lastIndexOf(".");
        if (indexDot >= 0) {
            packageName = temp.substring(0, indexDot);
            className = temp.substring(indexDot + 1);
        }
        String testName = className + "_" + methodName;
        test.setFieldValue("ut-package-name", packageName);
        test.setFieldValue("name", testName);
        test.setFieldValue("subtype-id", "EXTERNAL-TEST");
        test.setFieldValue("testing-framework", testingFramework);
        test.setFieldValue("testing-tool", testingTool);
        test.setFieldValue("ut-class-name", className);
        test.setFieldValue("ut-method-name", methodName);
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String marshallerObject(Class c, Object o) {
        Object s = "<?xml version=\"1.0\" ?>";
        try {
            JAXBContext jaxbContext;
            Thread t = Thread.currentThread();
            ClassLoader orig = t.getContextClassLoader();
            t.setContextClassLoader(ParserUtil.class.getClassLoader());
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{c});
            }
            finally {
                t.setContextClassLoader(orig);
            }
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"utf-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.fragment", (Object)true);
            StringWriter baos = new StringWriter();
            marshaller.marshal(o, (Writer)baos);
            s = (String)s + baos.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public static AlmRun createRun(String runStatus, String execDateTime, String duration, String detail) {
        Date executeDate;
        AlmRunImpl run = new AlmRunImpl();
        run.setFieldValue("subtype-id", "hp.qc.run.external-test");
        run.setFieldValue("status", runStatus);
        run.setFieldValue("detail", detail);
        if (execDateTime != null && execDateTime.length() > 0) {
            execDateTime = execDateTime.replaceAll("T", " ");
            executeDate = TimeUtil.stringToDate(execDateTime);
        } else {
            executeDate = new Date(System.currentTimeMillis());
        }
        run.setFieldValue("execution-date", TimeUtil.dateToString(executeDate));
        run.setFieldValue("execution-time", TimeUtil.timeToString(executeDate));
        if (duration != null && duration.length() > 0) {
            Float durationTime = Float.valueOf(0.0f);
            try {
                durationTime = Float.valueOf(duration);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            run.setFieldValue("duration", String.valueOf(durationTime.intValue()));
        } else {
            run.setFieldValue("duration", String.valueOf(0));
        }
        return run;
    }
}

