/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results.parser.testngxml;

import com.microfocus.application.automation.tools.results.parser.ReportParseException;
import com.microfocus.application.automation.tools.results.parser.ReportParser;
import com.microfocus.application.automation.tools.results.parser.testngxml.TestngResults;
import com.microfocus.application.automation.tools.results.parser.util.ParserUtil;
import com.microfocus.application.automation.tools.results.service.almentities.AlmRun;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTest;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestInstanceImpl;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSet;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSetImpl;
import com.microfocus.application.automation.tools.results.service.almentities.IAlmConsts;
import com.microfocus.application.automation.tools.sse.sdk.Base64Encoder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class TestNGXmlReportParserImpl
implements ReportParser {
    @Override
    public List<AlmTestSet> parseTestSets(InputStream reportInputStream, String testingFramework, String testingTool) throws ReportParseException {
        try {
            return this.parseTestSetFromTestNGXmlReport(reportInputStream, testingFramework, testingTool);
        }
        catch (Throwable e) {
            throw new ReportParseException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestngResults parseFromTestNGXmlReport(InputStream reportInputStream) throws JAXBException {
        JAXBContext jaxbContext;
        Thread t = Thread.currentThread();
        ClassLoader orig = t.getContextClassLoader();
        t.setContextClassLoader(TestNGXmlReportParserImpl.class.getClassLoader());
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TestngResults.class});
        }
        finally {
            t.setContextClassLoader(orig);
        }
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (TestngResults)unmarshaller.unmarshal(reportInputStream);
    }

    private AlmTest createExternalTestForTestNGXmlReport(String className, String methodName, String testingFramework, String testingTool) {
        return ParserUtil.createExternalTest(className, methodName, testingFramework, testingTool);
    }

    private ArrayList<AlmTestSet> parseTestSetFromTestNGXmlReport(InputStream reportInputStream, String testingFramework, String testingTool) throws JAXBException {
        TestngResults testngresults = this.parseFromTestNGXmlReport(reportInputStream);
        ArrayList<AlmTestSet> testSets = new ArrayList<AlmTestSet>();
        for (TestngResults.Suite suite : testngresults.suite) {
            AlmTestSetImpl testSet = new AlmTestSetImpl();
            testSet.setFieldValue("name", suite.getName());
            testSet.setFieldValue("subtype-id", "hp.qc.test-set.external");
            testSets.add(testSet);
            for (TestngResults.Suite.Test t : suite.getTest()) {
                for (TestngResults.Suite.Test.Class c : t.getClazz()) {
                    for (TestngResults.Suite.Test.Class.TestMethod tm : c.getTestMethod()) {
                        AlmTestInstanceImpl testInstance = new AlmTestInstanceImpl();
                        testInstance.setFieldValue("subtype-id", "hp.qc.test-instance.external-test");
                        testSet.addRelatedEntity("TESTSET_TO_TESTINSTANCE_CONTAINMENT_RELATION", testInstance);
                        AlmTest test = this.createExternalTestForTestNGXmlReport(c.getName(), tm.getName(), testingFramework, testingTool);
                        testInstance.addRelatedEntity("TEST_TO_TESTINSTANCE_REALIZATION_RELATION", test);
                        AlmRun run = ParserUtil.createRun(this.getRunStatus(tm), tm.getStartedAt(), String.valueOf(tm.getDurationMs()), this.getRunDetail(tm));
                        testInstance.addRelatedEntity("TESTINSTANCE_TO_RUN_REALIZATION_RELATION", run);
                    }
                }
            }
        }
        return testSets;
    }

    private String getRunStatus(TestngResults.Suite.Test.Class.TestMethod tm) {
        String status = tm.getStatus();
        if (status != null && status.length() > 0) {
            if ("PASS".equalsIgnoreCase(status = status.trim())) {
                return IAlmConsts.IStatuses.PASSED.value();
            }
            if ("FAIL".equalsIgnoreCase(status)) {
                return IAlmConsts.IStatuses.FAILED.value();
            }
            return IAlmConsts.IStatuses.NO_RUN.value();
        }
        return IAlmConsts.IStatuses.NO_RUN.value();
    }

    private String getRunDetail(TestngResults.Suite.Test.Class.TestMethod tm) {
        String detail = ParserUtil.marshallerObject(TestngResults.Suite.Test.Class.TestMethod.class, tm);
        return Base64Encoder.encode(detail.getBytes());
    }
}

