/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results.parser.nunit;

import com.microfocus.application.automation.tools.results.parser.ReportParseException;
import com.microfocus.application.automation.tools.results.parser.ReportParser;
import com.microfocus.application.automation.tools.results.parser.nunit.ResultType;
import com.microfocus.application.automation.tools.results.parser.nunit.ResultsType;
import com.microfocus.application.automation.tools.results.parser.nunit.TestCaseType;
import com.microfocus.application.automation.tools.results.parser.nunit.TestSuiteType;
import com.microfocus.application.automation.tools.results.parser.util.ParserUtil;
import com.microfocus.application.automation.tools.results.parser.util.TimeUtil;
import com.microfocus.application.automation.tools.results.service.almentities.AlmRun;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTest;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestInstanceImpl;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSet;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSetImpl;
import com.microfocus.application.automation.tools.results.service.almentities.IAlmConsts;
import com.microfocus.application.automation.tools.sse.sdk.Base64Encoder;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class NUnitReportParserImpl
implements ReportParser {
    private static String[] supportedDateFormat = new String[]{"yyyy-MM-dd", "yyyy/MM/dd"};
    private static String[] supportedTimeFormat = new String[]{"HH:mm:ss", "hh:mm:ss"};

    @Override
    public List<AlmTestSet> parseTestSets(InputStream reportInputStream, String testingFramework, String testingTool) throws ReportParseException {
        try {
            return this.parseTestSetFromNUnitReport(reportInputStream, testingFramework, testingTool);
        }
        catch (Throwable e) {
            throw new ReportParseException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultType parseFromNUnitReport(InputStream reportInputStream) throws JAXBException {
        JAXBContext jaxbContext;
        Thread t = Thread.currentThread();
        ClassLoader orig = t.getContextClassLoader();
        t.setContextClassLoader(NUnitReportParserImpl.class.getClassLoader());
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ResultType.class});
        }
        finally {
            t.setContextClassLoader(orig);
        }
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (ResultType)unmarshaller.unmarshal(reportInputStream);
    }

    private AlmTest createExternalTestForNUnitReport(TestCaseType testcase, String testingFramework, String testingTool) {
        String temp = testcase.getName();
        String methodName = "";
        String className = "";
        int indexMethod = temp.lastIndexOf(".");
        if (indexMethod >= 0) {
            methodName = temp.substring(indexMethod + 1);
            className = temp.substring(0, indexMethod);
        }
        return ParserUtil.createExternalTest(className, methodName, testingFramework, testingTool);
    }

    private void createTestSetAndTest(TestSuiteType testSuite, String uplevelSuiteName, String execDate, String execTime, List<AlmTestSet> testsets, String testingFramework, String testingTool) {
        ResultsType resultsOfSuite = testSuite.getResults();
        List<TestCaseType> testcases = resultsOfSuite.getTestCase();
        List<TestSuiteType> testSuites = resultsOfSuite.getTestSuite();
        String currentSuiteName = testSuite.getName();
        int index = currentSuiteName.lastIndexOf("\\");
        if (index >= 0) {
            currentSuiteName = currentSuiteName.substring(index + 1);
        }
        Object testsetName = currentSuiteName;
        if (uplevelSuiteName != null && uplevelSuiteName.length() > 0) {
            testsetName = uplevelSuiteName + "_" + currentSuiteName;
        }
        if (testcases != null && testcases.size() > 0) {
            AlmTestSetImpl testSet = new AlmTestSetImpl();
            testSet.setFieldValue("name", (String)testsetName);
            testSet.setFieldValue("subtype-id", "hp.qc.test-set.external");
            testsets.add(testSet);
            for (TestCaseType testcase : testcases) {
                AlmTestInstanceImpl testInstance = new AlmTestInstanceImpl();
                testInstance.setFieldValue("subtype-id", "hp.qc.test-instance.external-test");
                testSet.addRelatedEntity("TESTSET_TO_TESTINSTANCE_CONTAINMENT_RELATION", testInstance);
                AlmTest test = this.createExternalTestForNUnitReport(testcase, testingFramework, testingTool);
                testInstance.addRelatedEntity("TEST_TO_TESTINSTANCE_REALIZATION_RELATION", test);
                Object execDateTime = "";
                if (execDate != null && execTime != null) {
                    execDateTime = execDate + " " + execTime;
                }
                AlmRun run = ParserUtil.createRun(this.getRunStatus(testcase), (String)execDateTime, String.valueOf(testcase.getTime()), this.getRunDetail(testcase));
                testInstance.addRelatedEntity("TESTINSTANCE_TO_RUN_REALIZATION_RELATION", run);
            }
        }
        for (TestSuiteType s : testSuites) {
            this.createTestSetAndTest(s, (String)testsetName, execDate, execTime, testsets, testingFramework, testingTool);
        }
    }

    private Date getDate(int dateFormat, String dateStr) {
        DateFormat df = DateFormat.getDateInstance(dateFormat);
        Date date = null;
        try {
            date = df.parse(dateStr);
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Date getTime(int timeFormat, String dateStr) {
        DateFormat df = DateFormat.getTimeInstance(timeFormat);
        Date date = null;
        try {
            date = df.parse(dateStr);
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Date getDateBySupportedDateFormat(String dateStr) {
        for (String format : supportedDateFormat) {
            try {
                Date date = TimeUtil.getDateFormatter(format).parse(dateStr);
                return date;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private Date getTimeBySupportedTimeFormat(String timeStr) {
        for (String format : supportedTimeFormat) {
            try {
                Date date = TimeUtil.getDateFormatter(format).parse(timeStr);
                return date;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private String convertDateString(String dateStr) {
        Date date = null;
        date = this.getDate(1, dateStr);
        if (date == null) {
            date = this.getDate(2, dateStr);
        }
        if (date == null) {
            date = this.getDate(3, dateStr);
        }
        if (date == null) {
            date = this.getDate(0, dateStr);
        }
        if (date == null) {
            date = this.getDateBySupportedDateFormat(dateStr);
        }
        if (date != null) {
            return TimeUtil.getDateFormatter().format(date);
        }
        return null;
    }

    private String convertTimeString(String timeStr) {
        Date time = null;
        time = this.getTime(1, timeStr);
        if (time == null) {
            time = this.getTime(2, timeStr);
        }
        if (time == null) {
            time = this.getTime(3, timeStr);
        }
        if (time == null) {
            time = this.getTime(0, timeStr);
        }
        if (time == null) {
            time = this.getTimeBySupportedTimeFormat(timeStr);
        }
        if (time != null) {
            return TimeUtil.getTimeFormatter().format(time);
        }
        return null;
    }

    private ArrayList<AlmTestSet> parseTestSetFromNUnitReport(InputStream reportInputStream, String testingFramework, String testingTool) throws JAXBException {
        ResultType results = this.parseFromNUnitReport(reportInputStream);
        TestSuiteType testSuite = results.getTestSuite();
        String dateStr = results.getDate();
        String timeStr = results.getTime();
        String convertedDate = this.convertDateString(dateStr);
        String convertedTime = this.convertTimeString(timeStr);
        if (convertedDate == null || convertedTime == null) {
            Date executeDate = new Date(System.currentTimeMillis());
            convertedDate = TimeUtil.dateToString(executeDate);
            convertedTime = TimeUtil.timeToString(executeDate);
        }
        ArrayList<AlmTestSet> testSets = new ArrayList<AlmTestSet>();
        this.createTestSetAndTest(testSuite, "", convertedDate, convertedTime, testSets, testingFramework, testingTool);
        return testSets;
    }

    private String getRunStatus(TestCaseType testcase) {
        String executed = testcase.getExecuted();
        if ("True".equalsIgnoreCase(executed)) {
            String success = testcase.getSuccess();
            if ("True".equalsIgnoreCase(success)) {
                return IAlmConsts.IStatuses.PASSED.value();
            }
            return IAlmConsts.IStatuses.FAILED.value();
        }
        return IAlmConsts.IStatuses.NO_RUN.value();
    }

    private String getRunDetail(TestCaseType testcase) {
        String detail = ParserUtil.marshallerObject(TestCaseType.class, testcase);
        return Base64Encoder.encode(detail.getBytes());
    }
}

