/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results.parser.mavensurefire;

import com.microfocus.application.automation.tools.results.parser.ReportParseException;
import com.microfocus.application.automation.tools.results.parser.ReportParser;
import com.microfocus.application.automation.tools.results.parser.mavensurefire.Testcase;
import com.microfocus.application.automation.tools.results.parser.mavensurefire.Testsuite;
import com.microfocus.application.automation.tools.results.parser.util.ParserUtil;
import com.microfocus.application.automation.tools.results.service.almentities.AlmRun;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTest;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestInstanceImpl;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSet;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSetImpl;
import com.microfocus.application.automation.tools.results.service.almentities.IAlmConsts;
import com.microfocus.application.automation.tools.sse.sdk.Base64Encoder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class MavenSureFireReportParserImpl
implements ReportParser {
    @Override
    public List<AlmTestSet> parseTestSets(InputStream reportInputStream, String testingFramework, String testingTool) throws ReportParseException {
        try {
            return this.parseTestSetsFromMavenSurefirePluginJUnitReport(reportInputStream, testingFramework, testingTool);
        }
        catch (Exception e) {
            throw new ReportParseException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Testsuite parseFromMavenSurefirePluginJUnitReport(InputStream reportInputStream) throws JAXBException {
        JAXBContext jaxbContext;
        Thread t = Thread.currentThread();
        ClassLoader orig = t.getContextClassLoader();
        t.setContextClassLoader(MavenSureFireReportParserImpl.class.getClassLoader());
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Testsuite.class});
        }
        finally {
            t.setContextClassLoader(orig);
        }
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (Testsuite)unmarshaller.unmarshal(reportInputStream);
    }

    private AlmTest createExternalTestForMavenSurefirePluginJUnit(Testcase tc, String testingFramework, String testingTool) {
        return ParserUtil.createExternalTest(tc.getClassname(), tc.getName(), testingFramework, testingTool);
    }

    private ArrayList<AlmTestSet> parseTestSetsFromMavenSurefirePluginJUnitReport(InputStream reportInputStream, String testingFramework, String testingTool) throws JAXBException {
        Testsuite testsuite = this.parseFromMavenSurefirePluginJUnitReport(reportInputStream);
        ArrayList<AlmTestSet> testSets = new ArrayList<AlmTestSet>();
        AlmTestSetImpl testSet = new AlmTestSetImpl();
        testSet.setFieldValue("name", testsuite.getName());
        testSet.setFieldValue("subtype-id", "hp.qc.test-set.external");
        testSets.add(testSet);
        for (Testcase tc : testsuite.getTestcase()) {
            AlmTestInstanceImpl testInstance = new AlmTestInstanceImpl();
            testInstance.setFieldValue("subtype-id", "hp.qc.test-instance.external-test");
            testSet.addRelatedEntity("TESTSET_TO_TESTINSTANCE_CONTAINMENT_RELATION", testInstance);
            AlmTest test = this.createExternalTestForMavenSurefirePluginJUnit(tc, testingFramework, testingTool);
            testInstance.addRelatedEntity("TEST_TO_TESTINSTANCE_REALIZATION_RELATION", test);
            AlmRun run = ParserUtil.createRun(this.getRunStatus(tc), testsuite.getTimestamp(), tc.getTime(), this.getRunDetail(tc));
            testInstance.addRelatedEntity("TESTINSTANCE_TO_RUN_REALIZATION_RELATION", run);
        }
        return testSets;
    }

    private String getRunStatus(Testcase testcase) {
        String result;
        if (testcase.getError().size() > 0) {
            return IAlmConsts.IStatuses.FAILED.value();
        }
        if (testcase.getFailure().size() > 0) {
            return IAlmConsts.IStatuses.FAILED.value();
        }
        if (testcase.getStatus() == null) {
            return IAlmConsts.IStatuses.PASSED.value();
        }
        String status = testcase.getStatus();
        if (status != null) {
            if ((status = status.trim()).length() > 0) {
                try {
                    result = IAlmConsts.IStatuses.valueOf(status.toUpperCase()).value();
                }
                catch (IllegalArgumentException e) {
                    result = status;
                }
            } else {
                result = IAlmConsts.IStatuses.PASSED.value();
            }
        } else {
            result = IAlmConsts.IStatuses.PASSED.value();
        }
        return result;
    }

    private String getRunDetail(Testcase testcase) {
        String detail = ParserUtil.marshallerObject(Testcase.class, testcase);
        return Base64Encoder.encode(detail.getBytes());
    }
}

