/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results.parser.antjunit;

import com.microfocus.application.automation.tools.results.parser.ReportParseException;
import com.microfocus.application.automation.tools.results.parser.ReportParser;
import com.microfocus.application.automation.tools.results.parser.antjunit.Testcase;
import com.microfocus.application.automation.tools.results.parser.antjunit.Testsuite;
import com.microfocus.application.automation.tools.results.parser.antjunit.Testsuites;
import com.microfocus.application.automation.tools.results.parser.util.ParserUtil;
import com.microfocus.application.automation.tools.results.service.almentities.AlmRun;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTest;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestInstanceImpl;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSet;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSetImpl;
import com.microfocus.application.automation.tools.results.service.almentities.IAlmConsts;
import com.microfocus.application.automation.tools.sse.sdk.Base64Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class AntJUnitReportParserImpl
implements ReportParser {
    @Override
    public List<AlmTestSet> parseTestSets(InputStream reportInputStream, String testingFramework, String testingTool) throws ReportParseException {
        try {
            ArrayList<AlmTestSet> arrayList = this.parseTestSetsFromAntJUnitReport(reportInputStream, testingFramework, testingTool);
            return arrayList;
        }
        catch (Exception e) {
            throw new ReportParseException(e);
        }
        finally {
            try {
                if (reportInputStream != null) {
                    reportInputStream.close();
                }
            }
            catch (IOException e) {
                throw new ReportParseException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Testsuites parseFromAntJUnitReport(InputStream reportInputStream) throws JAXBException {
        JAXBContext jaxbContext;
        Thread t = Thread.currentThread();
        ClassLoader orig = t.getContextClassLoader();
        t.setContextClassLoader(AntJUnitReportParserImpl.class.getClassLoader());
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Testsuites.class});
        }
        finally {
            t.setContextClassLoader(orig);
        }
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (Testsuites)unmarshaller.unmarshal(reportInputStream);
    }

    private AlmTest createExternalTestForAntJUnit(Testcase tc, String testingFramework, String testingTool) {
        return ParserUtil.createExternalTest(tc.getClassname(), tc.getName(), testingFramework, testingTool);
    }

    private String getRunDetail(Testcase tc) {
        String detail = ParserUtil.marshallerObject(Testcase.class, tc);
        return Base64Encoder.encode(detail.getBytes());
    }

    private ArrayList<AlmTestSet> parseTestSetsFromAntJUnitReport(InputStream reportInputStream, String testingFramework, String testingTool) throws JAXBException {
        Testsuites testsuites = this.parseFromAntJUnitReport(reportInputStream);
        ArrayList<AlmTestSet> testSets = new ArrayList<AlmTestSet>();
        for (Testsuite ts : testsuites.getTestsuite()) {
            AlmTestSetImpl testSet = new AlmTestSetImpl();
            testSet.setFieldValue("name", ParserUtil.replaceInvalidCharsForTestSetName(ts.getName()));
            testSet.setFieldValue("subtype-id", "hp.qc.test-set.external");
            testSets.add(testSet);
            for (Testcase tc : ts.getTestcase()) {
                AlmTestInstanceImpl testInstance = new AlmTestInstanceImpl();
                testInstance.setFieldValue("subtype-id", "hp.qc.test-instance.external-test");
                testSet.addRelatedEntity("TESTSET_TO_TESTINSTANCE_CONTAINMENT_RELATION", testInstance);
                AlmTest test = this.createExternalTestForAntJUnit(tc, testingFramework, testingTool);
                testInstance.addRelatedEntity("TEST_TO_TESTINSTANCE_REALIZATION_RELATION", test);
                AlmRun run = ParserUtil.createRun(this.getRunStatus(tc), ts.getTimestamp(), tc.getTime(), this.getRunDetail(tc));
                testInstance.addRelatedEntity("TESTINSTANCE_TO_RUN_REALIZATION_RELATION", run);
            }
        }
        return testSets;
    }

    private String getRunStatus(Testcase testcase) {
        if (testcase.getError().size() > 0) {
            return IAlmConsts.IStatuses.FAILED.value();
        }
        if (testcase.getFailure().size() > 0) {
            return IAlmConsts.IStatuses.FAILED.value();
        }
        String result = null;
        String status = testcase.getStatus();
        if (status == null) {
            result = IAlmConsts.IStatuses.PASSED.value();
        } else if ((status = status.trim()).length() > 0) {
            try {
                result = IAlmConsts.IStatuses.valueOf(status.toUpperCase()).value();
            }
            catch (IllegalArgumentException e) {
                result = status;
            }
        } else {
            result = IAlmConsts.IStatuses.PASSED.value();
        }
        return result;
    }
}

