/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results.lrscriptresultparser;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class LrScriptResultsSanitizer
extends FilterReader {
    public LrScriptResultsSanitizer(Reader in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        char[] buf = new char[1];
        int result = this.read(buf, 0, 1);
        if (result == -1) {
            return -1;
        }
        return buf[0];
    }

    @Override
    public int read(char[] buf, int from, int len) throws IOException {
        int numchars = 0;
        while (numchars == 0) {
            numchars = this.in.read(buf, from, len);
            if (numchars == -1) {
                return -1;
            }
            int last = from;
            for (int i = from; i < from + numchars; ++i) {
                if (LrScriptResultsSanitizer.isBadXMLChar(buf[i])) continue;
                buf[last] = buf[i];
                ++last;
            }
            numchars = last - from;
        }
        return numchars;
    }

    private static boolean isBadXMLChar(char current) {
        switch (current) {
            case '\t': 
            case '\n': 
            case '\r': {
                return false;
            }
        }
        return !(current >= '\ue000' && current <= '\ufffd' || current >= ' ' && current <= '\ud7ff');
    }
}

