/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.cloudbees.plugins.credentials.matchers.IdMatcher;
import com.microfocus.application.automation.tools.model.AlmServerSettingsModel;
import com.microfocus.application.automation.tools.model.EnumDescription;
import com.microfocus.application.automation.tools.model.UploadTestResultToAlmModel;
import com.microfocus.application.automation.tools.results.service.AlmRestInfo;
import com.microfocus.application.automation.tools.results.service.AlmRestTool;
import com.microfocus.application.automation.tools.results.service.AttachmentUploadService;
import com.microfocus.application.automation.tools.results.service.DefaultExternalEntityUploadServiceImpl;
import com.microfocus.application.automation.tools.results.service.ExternalEntityUploadLogger;
import com.microfocus.application.automation.tools.settings.AlmServerSettingsGlobalConfiguration;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.test.TestResultAggregator;
import hudson.tasks.test.TestResultProjectAction;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TestResultToALMUploader
extends Recorder
implements Serializable,
MatrixAggregatable,
SimpleBuildStep {
    private static final long serialVersionUID = 1L;
    private UploadTestResultToAlmModel uploadTestResultToAlmModel;
    private String almServerName;
    private String credentialsId;
    private String almDomain;
    private String clientType;
    private String almProject;
    private String testingFramework;
    private String testingTool;
    private String almTestFolder;
    private String almTestSetFolder;
    private String almTimeout;
    private String testingResultFile;
    private String testingAttachments;
    private String jenkinsServerUrl;

    public UploadTestResultToAlmModel getUploadTestResultToAlmModel() {
        return this.uploadTestResultToAlmModel;
    }

    public void setUploadTestResultToAlmModel(UploadTestResultToAlmModel uploadTestResultToAlmModel) {
        this.uploadTestResultToAlmModel = uploadTestResultToAlmModel;
    }

    public String getAlmServerName() {
        return this.almServerName;
    }

    public void setAlmServerName(String almServerName) {
        this.almServerName = almServerName;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getAlmDomain() {
        return this.almDomain;
    }

    public void setAlmDomain(String almDomain) {
        this.almDomain = almDomain;
    }

    public String getClientType() {
        return this.clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public String getAlmProject() {
        return this.almProject;
    }

    public void setAlmProject(String almProject) {
        this.almProject = almProject;
    }

    public String getTestingFramework() {
        return this.testingFramework;
    }

    public void setTestingFramework(String testingFramework) {
        this.testingFramework = testingFramework;
    }

    public String getTestingTool() {
        return this.testingTool;
    }

    public void setTestingTool(String testingTool) {
        this.testingTool = testingTool;
    }

    public String getAlmTestFolder() {
        return this.almTestFolder;
    }

    public void setAlmTestFolder(String almTestFolder) {
        this.almTestFolder = almTestFolder;
    }

    public String getAlmTestSetFolder() {
        return this.almTestSetFolder;
    }

    public void setAlmTestSetFolder(String almTestSetFolder) {
        this.almTestSetFolder = almTestSetFolder;
    }

    public String getAlmTimeout() {
        return this.almTimeout;
    }

    public void setAlmTimeout(String almTimeout) {
        this.almTimeout = almTimeout;
    }

    public String getTestingResultFile() {
        return this.testingResultFile;
    }

    public void setTestingResultFile(String testingResultFile) {
        this.testingResultFile = testingResultFile;
    }

    public String getTestingAttachments() {
        return this.testingAttachments;
    }

    public void setTestingAttachments(String testingAttachments) {
        this.testingAttachments = testingAttachments;
    }

    public String getJenkinsServerUrl() {
        return this.jenkinsServerUrl;
    }

    public void setJenkinsServerUrl(String jenkinsServerUrl) {
        this.jenkinsServerUrl = jenkinsServerUrl;
    }

    @DataBoundConstructor
    public TestResultToALMUploader(String almServerName, String credentialsId, String almDomain, String clientType, String almProject, String testingFramework, String testingTool, String almTestFolder, String almTestSetFolder, String almTimeout, String testingResultFile, String testingAttachments, String jenkinsServerUrl) {
        this.almServerName = almServerName;
        this.credentialsId = credentialsId;
        this.almDomain = almDomain;
        this.clientType = clientType;
        this.almProject = almProject;
        this.testingFramework = testingFramework;
        this.testingTool = testingTool;
        this.almTestFolder = almTestFolder;
        this.almTestSetFolder = almTestSetFolder;
        this.almTimeout = almTimeout;
        this.testingResultFile = testingResultFile;
        this.testingAttachments = testingAttachments;
        this.jenkinsServerUrl = jenkinsServerUrl;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        ExternalEntityUploadLogger logger = new ExternalEntityUploadLogger(listener.getLogger());
        if (StringUtils.isBlank((String)this.credentialsId)) {
            logger.log("INFO: credentials is not configured.");
            build.setResult(Result.UNSTABLE);
            return;
        }
        UsernamePasswordCredentials credentials = this.getCredentialsById(this.credentialsId, build, logger);
        logger.log(String.format("INFO: 'Upload test result to ALM' Post Build Step is being invoked by %s.", credentials.getUsername()));
        List<String> importedTestsetIds = null;
        this.uploadTestResultToAlmModel = new UploadTestResultToAlmModel(this.almServerName, credentials.getUsername(), credentials.getPassword().getPlainText(), this.almDomain, this.clientType, this.almProject, this.testingFramework, this.testingTool, this.almTestFolder, this.almTestSetFolder, this.almTimeout, this.testingResultFile, this.testingAttachments, this.jenkinsServerUrl);
        VariableResolver.ByMap varResolver = new VariableResolver.ByMap((Map)build.getEnvironment(listener));
        String serverUrl = this.getAlmServerUrl(this.uploadTestResultToAlmModel.getAlmServerName());
        Object runUrl = "";
        String tempUrl = Util.replaceMacro((String)this.uploadTestResultToAlmModel.getJenkinsServerUrl(), (VariableResolver)varResolver);
        if (tempUrl != null && tempUrl.length() > 0) {
            runUrl = tempUrl.charAt(tempUrl.length() - 1) != '/' ? tempUrl + "/" + build.getUrl() : tempUrl + build.getUrl();
        }
        File root = build.getRootDir();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(root);
        ds.setIncludes(new String[]{this.uploadTestResultToAlmModel.getTestingResultFile()});
        ds.scan();
        if (ds.getIncludedFilesCount() == 0) {
            logger.log("INFO: No Test Report found.");
            build.setResult(Result.UNSTABLE);
        } else {
            logger.log("INFO: " + ds.getIncludedFilesCount() + " test result file found.");
            String[] files = ds.getIncludedFiles();
            AlmRestInfo loginInfo = new AlmRestInfo(serverUrl, Util.replaceMacro((String)this.uploadTestResultToAlmModel.getAlmDomain(), (VariableResolver)varResolver), this.clientType, Util.replaceMacro((String)this.uploadTestResultToAlmModel.getAlmProject(), (VariableResolver)varResolver), this.uploadTestResultToAlmModel.getAlmUserName(), this.uploadTestResultToAlmModel.getAlmPassword(), Util.replaceMacro((String)this.uploadTestResultToAlmModel.getAlmTestSetFolder(), (VariableResolver)varResolver));
            AlmRestTool almRestTool = new AlmRestTool(loginInfo, (Logger)logger);
            for (String fileName : files) {
                String fullpath = root.getAbsolutePath() + File.separator + fileName;
                logger.log("INFO: Start to upload " + fullpath);
                DefaultExternalEntityUploadServiceImpl service = new DefaultExternalEntityUploadServiceImpl(almRestTool, workspace, logger);
                try {
                    importedTestsetIds = service.uploadExternalTestSet(loginInfo, fullpath, Util.replaceMacro((String)this.uploadTestResultToAlmModel.getAlmTestSetFolder(), (VariableResolver)varResolver), Util.replaceMacro((String)this.uploadTestResultToAlmModel.getAlmTestFolder(), (VariableResolver)varResolver), this.uploadTestResultToAlmModel.getTestingFramework(), this.uploadTestResultToAlmModel.getTestingTool(), String.valueOf(build.getNumber()), build.getParent().getDisplayName(), (String)runUrl);
                    logger.log("INFO: Uploaded " + fullpath + ".");
                }
                catch (Exception e) {
                    logger.log("ERR: There's exception while uploading " + fullpath + ". " + e.getMessage());
                    build.setResult(Result.UNSTABLE);
                }
            }
            String testingAttachment = this.uploadTestResultToAlmModel.getTestingAttachments();
            if (importedTestsetIds != null && !importedTestsetIds.isEmpty() && testingAttachment != null && !testingAttachment.isEmpty()) {
                AttachmentUploadService.init(build, workspace, almRestTool.getRestClient(), logger);
                if (!AttachmentUploadService.getInstance().upload(testingAttachment, "test-sets", (String)importedTestsetIds.get(0))) {
                    build.setResult(Result.UNSTABLE);
                }
            }
        }
        logger.log("INFO: 'Upload test result to ALM' Completed.");
    }

    private UsernamePasswordCredentials getCredentialsById(String credentialsId, Run<?, ?> run, ExternalEntityUploadLogger logger) {
        UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StandardUsernamePasswordCredentials.class, run, (List)URIRequirementBuilder.create().build());
        if (credentials == null) {
            logger.log("Can not find credentials with the credentialsId:" + credentialsId);
        }
        return credentials;
    }

    private String getAlmServerUrl(String almServerName) {
        AlmServerSettingsModel[] almServers = AlmServerSettingsGlobalConfiguration.getInstance().getInstallations();
        if (almServers != null && almServers.length > 0) {
            for (AlmServerSettingsModel almServerModel : almServers) {
                if (!almServerName.equalsIgnoreCase(almServerModel.getAlmServerName())) continue;
                return almServerModel.getAlmServerUrl();
            }
        }
        return "";
    }

    public AlmServerSettingsModel getAlmServerSettingsModel() {
        for (AlmServerSettingsModel almServer : this.getDescriptor().getAlmServers()) {
            if (!this.almServerName.equals(almServer.getAlmServerName())) continue;
            return almServer;
        }
        return null;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new TestResultProjectAction(project);
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new TestResultAggregator(build, launcher, listener);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    @Extension
    @Symbol(value={"uploadResultToALM"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Upload test result to ALM";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean hasAlmServers() {
            return AlmServerSettingsGlobalConfiguration.getInstance().hasAlmServers();
        }

        public AlmServerSettingsModel[] getAlmServers() {
            return AlmServerSettingsGlobalConfiguration.getInstance().getInstallations();
        }

        public FormValidation doCheckAlmUserName(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"User name must be set");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAlmDomain(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Domain must be set");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAlmProject(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Project must be set");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAlmTestFolder(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"TestFolder are missing");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAlmTestSetFolder(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"TestSetFolder are missing");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTestingResultFile(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Testing result file must be set");
            }
            return FormValidation.ok();
        }

        public List<EnumDescription> getTestingFrameworks() {
            return UploadTestResultToAlmModel.testingFrameworks;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String credentialsId) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardUsernameListBoxModel().includeEmptyValue().includeAs(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM, project, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.create().build()).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String value) {
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM), (List)URIRequirementBuilder.create().build(), (CredentialsMatcher)new IdMatcher(value))) {
                if (!StringUtils.equals((String)value, (String)o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Cannot find any credentials with id " + value));
        }
    }
}

