/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results;

import com.microfocus.application.automation.tools.results.DetailReport;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.tasks.test.TestResultProjectAction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class RichReportAction
implements Action,
SimpleBuildStep.LastBuildAction {
    private static final String RICH_REPORT_FOLDER = "RichReport";
    private static final String REPORT_INDEX = "report.index";
    private Map<String, DetailReport> richReportMap = new LinkedHashMap<String, DetailReport>();
    private final List<TestResultProjectAction> projectActionList;
    private final Run<?, ?> build;

    public RichReportAction(Run<?, ?> build) throws IOException {
        File indexFile;
        this.build = build;
        File reportFolder = new File(build.getRootDir(), RICH_REPORT_FOLDER);
        if (reportFolder.exists() && (indexFile = new File(reportFolder, REPORT_INDEX)).exists()) {
            File file = new File(build.getRootDir(), RICH_REPORT_FOLDER);
            DirectoryBrowserSupport dbs = new DirectoryBrowserSupport((ModelObject)this, new FilePath(file), "report", "graph.gif", false);
            this.createRichIndexFile(build, indexFile, dbs);
        }
        this.projectActionList = new ArrayList<TestResultProjectAction>();
    }

    private void createRichIndexFile(Run<?, ?> build, File indexFile, DirectoryBrowserSupport dbs) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(indexFile));
        boolean rolling = true;
        while ((line = br.readLine()) != null) {
            String[] values = line.split("\t");
            if (values.length < 1) continue;
            DetailReport report = new DetailReport(build, values[0], dbs);
            if (rolling) {
                report.setColor("#FFF");
                rolling = false;
            } else {
                report.setColor("#F1F1F1");
                rolling = true;
            }
            switch (values.length) {
                case 4: {
                    report.updateReport(values[1], values[2], values[3]);
                    break;
                }
                case 3: {
                    report.updateReport(values[1], values[2], "##");
                    break;
                }
                case 2: {
                    report.updateReport(values[1], "##", "##");
                }
            }
            this.richReportMap.put(values[0], report);
        }
        br.close();
    }

    public String getIconFileName() {
        return "/plugin/hp-application-automation-tools-plugin/PerformanceReport/LoadRunner.png";
    }

    public String getDisplayName() {
        return "Rich Report";
    }

    public String getUrlName() {
        return RICH_REPORT_FOLDER;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public Map<String, DetailReport> getRichReportMap() {
        return this.richReportMap;
    }

    public Object getDynamic(String name, StaplerRequest req, StaplerResponse rsp) {
        if (this.richReportMap.containsKey(name)) {
            return this.richReportMap.get(name);
        }
        return null;
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.emptySet();
    }
}

