/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results;

import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.XpathReader;
import com.microfocus.application.automation.tools.settings.RunnerMiscSettingsGlobalConfiguration;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReportMetaData {
    private String folderPath;
    private String disPlayName;
    private String urlName;
    private String resourceURL;
    private String dateTime;
    private String status;
    private Boolean isHtmlReport;
    private Boolean isParallelRunnerReport;
    private String archiveUrl;
    private final Set<String> stResFolders = new HashSet<String>();
    private static final String RUN_API_TEST_XPATH_EXPRESSION = "//Data[Name='RunAPITest']/Extension/StepCustomData";
    private static final String FAILED_TO_PROCESS_XML_REPORT = "Failed to process run_results.xml report: ";
    private static final String ST_RES = "..\\StRes";

    public String getFolderPath() {
        return this.folderPath;
    }

    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    public String getDisPlayName() {
        return this.disPlayName;
    }

    public void setDisPlayName(String disPlayName) {
        this.disPlayName = disPlayName;
    }

    public String getUrlName() {
        return this.urlName;
    }

    public void setUrlName(String urlName) {
        this.urlName = urlName;
    }

    public String getResourceURL() {
        return this.resourceURL;
    }

    public void setResourceURL(String resourceURL) {
        this.resourceURL = resourceURL;
    }

    private static LocalDateTime tryParseDate(String date) {
        for (String pattern : RunnerMiscSettingsGlobalConfiguration.DEFAULT_UFT_DATE_PATTERNS) {
            try {
                return LocalDateTime.parse(date, DateTimeFormatter.ofPattern(pattern));
            }
            catch (IllegalArgumentException | DateTimeException runtimeException) {
            }
        }
        return null;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public String getFormattedDateTime() {
        LocalDateTime dt = ReportMetaData.tryParseDate(this.dateTime);
        if (dt == null) {
            return this.dateTime;
        }
        try {
            return dt.format(RunnerMiscSettingsGlobalConfiguration.getInstance().getDateFormatter());
        }
        catch (NullPointerException ignored) {
            return this.dateTime;
        }
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean getIsHtmlReport() {
        return this.isHtmlReport;
    }

    public void setIsHtmlReport(Boolean isHtmlReport) {
        this.isHtmlReport = isHtmlReport;
    }

    public Boolean getIsParallelRunnerReport() {
        return this.isParallelRunnerReport;
    }

    public void setIsParallelRunnerReport(Boolean parallelRunnerReport) {
        this.isParallelRunnerReport = parallelRunnerReport;
    }

    public String getArchiveUrl() {
        return this.archiveUrl;
    }

    public void setArchiveUrl(String archiveUrl) {
        this.archiveUrl = archiveUrl;
    }

    public boolean hasArchiveUrl() {
        return this.archiveUrl != null && !this.archiveUrl.equals("");
    }

    public Set<String> getStResFolders() {
        return this.stResFolders;
    }

    public void computeStResFolders(FilePath xmlReport, TaskListener listener) throws InterruptedException {
        try {
            if (xmlReport.exists()) {
                XpathReader xr = new XpathReader(xmlReport);
                NodeList nodes = xr.getNodeListFromNode(RUN_API_TEST_XPATH_EXPRESSION, xr.getDoc());
                for (int x = 0; x < nodes.getLength(); ++x) {
                    String val = nodes.item(x).getTextContent();
                    if (!val.startsWith(ST_RES)) continue;
                    this.stResFolders.add(val.substring(3));
                }
            }
        }
        catch (IOException | NullPointerException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            listener.error(FAILED_TO_PROCESS_XML_REPORT + String.valueOf(e));
        }
    }
}

