/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results;

import com.microfocus.application.automation.tools.results.LrGraphUtils;
import com.microfocus.application.automation.tools.results.PerformanceJobReportAction;
import com.microfocus.application.automation.tools.results.projectparser.performance.AvgTransactionResponseTime;
import com.microfocus.application.automation.tools.results.projectparser.performance.GoalResult;
import com.microfocus.application.automation.tools.results.projectparser.performance.JobLrScenarioResult;
import com.microfocus.application.automation.tools.results.projectparser.performance.LrJobResults;
import com.microfocus.application.automation.tools.results.projectparser.performance.LrProjectScenarioResults;
import com.microfocus.application.automation.tools.results.projectparser.performance.LrTest;
import com.microfocus.application.automation.tools.results.projectparser.performance.PercentileTransactionWholeRun;
import com.microfocus.application.automation.tools.results.projectparser.performance.ProjectLrResults;
import com.microfocus.application.automation.tools.results.projectparser.performance.TimeRangeResult;
import com.microfocus.application.automation.tools.results.projectparser.performance.WholeRunResult;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.RunList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class PerformanceProjectAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(PerformanceProjectAction.class.getName());
    private static final int MAX_DISPLAY_BUILDS = 20;
    public final Job<?, ?> currentProject;
    private ArrayList<LrJobResults> jobLrResults;
    private int lastBuildId = -1;
    private ArrayList<Integer> _workedBuilds = new ArrayList();
    private ProjectLrResults _projectResult;
    private Collection<Action> projectActions;

    public PerformanceProjectAction(Job<?, ?> job) {
        this.jobLrResults = new ArrayList();
        this.currentProject = job;
        this.projectActions = new ArrayList<Action>();
    }

    private void updateLastBuild() {
    }

    @JavaScriptMethod
    public JSONArray getScenarioList() {
        JSONArray scenarioList = new JSONArray();
        for (String scenarioName : this._projectResult.getScenarioResults().keySet()) {
            JSONObject scenario = new JSONObject();
            scenario.put("ScenarioName", (Object)scenarioName);
            scenarioList.add((Object)scenario);
        }
        return scenarioList;
    }

    @JavaScriptMethod
    public JSONObject getGraphData() {
        JSONObject projectDataSet = new JSONObject();
        if (this._projectResult == null) {
            return new JSONObject();
        }
        for (Map.Entry<String, LrProjectScenarioResults> scenarioResults : this._projectResult.getScenarioResults().entrySet()) {
            JSONObject scenarioData = new JSONObject();
            JSONObject scenarioStats = new JSONObject();
            scenarioData.put("scenarioStats", (Object)scenarioStats);
            JSONObject scenarioGraphData = new JSONObject();
            LrGraphUtils.constructTotalHitsGraph(scenarioResults, scenarioGraphData);
            LrGraphUtils.constructAvgHitsGraph(scenarioResults, scenarioGraphData);
            LrGraphUtils.constructTotalThroughputGraph(scenarioResults, scenarioGraphData);
            LrGraphUtils.constructAverageThroughput(scenarioResults, scenarioGraphData);
            LrGraphUtils.constructErrorGraph(scenarioResults, scenarioGraphData);
            LrGraphUtils.constructAvgTransactionGraph(scenarioResults, scenarioGraphData);
            LrGraphUtils.constructPercentileTransactionGraph(scenarioResults, scenarioGraphData);
            scenarioData.put("scenarioData", (Object)scenarioGraphData);
            String scenarioName = scenarioResults.getKey();
            projectDataSet.put(scenarioName, (Object)scenarioData);
        }
        return projectDataSet;
    }

    public List<String> getBuildPerformanceReportList() {
        return new ArrayList<String>(0);
    }

    public String getIconFileName() {
        return "/plugin/hp-application-automation-tools-plugin/PerformanceReport/LoadRunner.png";
    }

    public String getDisplayName() {
        return "Project Performance report";
    }

    public String getUrlName() {
        return "PerformanceProjectReport";
    }

    boolean isVisible() {
        RunList builds = this.currentProject.getBuilds();
        for (Run run : builds) {
            if (run.getAction(PerformanceJobReportAction.class) == null) continue;
            return true;
        }
        return false;
    }

    public synchronized void getUpdatedData() {
        if (!this.isUpdateDataNeeded()) {
            return;
        }
        this._projectResult = new ProjectLrResults();
        this._workedBuilds = new ArrayList();
        RunList projectBuilds = this.currentProject.getBuilds();
        for (Run run : projectBuilds) {
            int runNumber;
            PerformanceJobReportAction performanceJobReportAction = (PerformanceJobReportAction)run.getAction(PerformanceJobReportAction.class);
            if (performanceJobReportAction == null || run.isBuilding() || this._workedBuilds.contains(runNumber = run.getNumber())) continue;
            this._workedBuilds.add(runNumber);
            LrJobResults jobLrResult = performanceJobReportAction.getLrResultBuildDataset();
            for (Map.Entry<String, JobLrScenarioResult> runResult : jobLrResult.getLrScenarioResults().entrySet()) {
                LrProjectScenarioResults lrProjectScenarioResults;
                if (!this._projectResult.getScenarioResults().containsKey(runResult.getKey())) {
                    this._projectResult.addScenario(new LrProjectScenarioResults(runResult.getKey()));
                }
                if ((lrProjectScenarioResults = (LrProjectScenarioResults)this._projectResult.getScenarioResults().get(runResult.getKey())).getBuildCount() > 20) continue;
                lrProjectScenarioResults.incBuildCount();
                JobLrScenarioResult scenarioRunResult = runResult.getValue();
                for (GoalResult goalResult : scenarioRunResult.scenarioSlaResults) {
                    PerformanceProjectAction.scenarioGoalResult(runNumber, lrProjectScenarioResults, goalResult);
                }
                this.joinSceanrioConnectionsStats(runNumber, lrProjectScenarioResults, scenarioRunResult);
                this.joinVUserScenarioStats(runNumber, lrProjectScenarioResults, scenarioRunResult);
                this.joinTransactionScenarioStats(runNumber, lrProjectScenarioResults, scenarioRunResult);
                this.joinDurationStats(runNumber, lrProjectScenarioResults, scenarioRunResult);
            }
        }
    }

    private void joinDurationStats(int runNumber, LrProjectScenarioResults lrProjectScenarioResults, JobLrScenarioResult scenarioRunResult) {
        long scenarioConnectionMax = scenarioRunResult.getScenarioDuration();
        if (scenarioConnectionMax != -1L) {
            lrProjectScenarioResults.getDurationData().put(runNumber, scenarioConnectionMax);
        }
    }

    private void joinTransactionScenarioStats(int runNumber, LrProjectScenarioResults lrProjectScenarioResults, JobLrScenarioResult scenarioRunResult) {
        SortedMap<Integer, TreeMap<String, TreeMap<String, Integer>>> projectTransactionPerRun = lrProjectScenarioResults.getTransactionPerRun();
        SortedMap<String, Integer> projectTransactionSum = lrProjectScenarioResults.getTransactionSum();
        TreeMap<String, TreeMap<String, Integer>> scenarioTransactionData = scenarioRunResult.transactionData;
        TreeMap<String, Integer> scenarioTransactionSum = scenarioRunResult.transactionSum;
        if (scenarioTransactionData == null || scenarioTransactionSum == null) {
            return;
        }
        if (!scenarioTransactionData.isEmpty()) {
            projectTransactionPerRun.put(runNumber, scenarioTransactionData);
            for (Map.Entry<String, Integer> transactionState : scenarioTransactionSum.entrySet()) {
                int previousCount = 0;
                if (projectTransactionSum.containsKey(transactionState.getKey())) {
                    previousCount = (Integer)projectTransactionSum.get(transactionState.getKey());
                }
                projectTransactionSum.put(transactionState.getKey(), previousCount + transactionState.getValue());
            }
            SortedMap<String, TreeMap<String, Integer>> projectTransactionsData = lrProjectScenarioResults.getTransactionData();
            for (Map.Entry<String, TreeMap<String, Integer>> scenarioTransactionDataSet : scenarioTransactionData.entrySet()) {
                String transactionName = scenarioTransactionDataSet.getKey();
                TreeMap<String, Integer> TransactionStateData = scenarioTransactionDataSet.getValue();
                if (!projectTransactionsData.containsKey(transactionName)) {
                    projectTransactionsData.put(transactionName, new TreeMap<String, Integer>((SortedMap<String, Integer>)TransactionStateData));
                    continue;
                }
                TreeMap projectTransactionState = (TreeMap)projectTransactionsData.get(transactionName);
                for (Map.Entry<String, Integer> scenarioTransactionState : TransactionStateData.entrySet()) {
                    Integer currentValue = scenarioTransactionState.getValue();
                    projectTransactionState.put(scenarioTransactionState.getKey(), currentValue + scenarioTransactionState.getValue());
                }
            }
        }
    }

    private void joinVUserScenarioStats(int runNumber, LrProjectScenarioResults lrProjectScenarioResults, JobLrScenarioResult scenarioRunResult) {
        SortedMap<Integer, TreeMap<String, Integer>> vUserPerRun = lrProjectScenarioResults.getvUserPerRun();
        if (scenarioRunResult.vUserSum != null && !scenarioRunResult.vUserSum.isEmpty()) {
            for (Map.Entry<String, Integer> vUserStat : scenarioRunResult.vUserSum.entrySet()) {
                if (!vUserPerRun.containsKey(runNumber)) {
                    vUserPerRun.put(runNumber, new TreeMap());
                    LrProjectScenarioResults.vUserMapInit((SortedMap)vUserPerRun.get(runNumber));
                }
                ((TreeMap)vUserPerRun.get(runNumber)).put(vUserStat.getKey(), vUserStat.getValue());
                int previousCount = 0;
                if (lrProjectScenarioResults.getvUserSummary().containsKey(vUserStat.getKey())) {
                    previousCount = (Integer)lrProjectScenarioResults.getvUserSummary().get(vUserStat.getKey());
                }
                lrProjectScenarioResults.getvUserSummary().put(vUserStat.getKey(), previousCount + vUserStat.getValue());
            }
        }
    }

    private void joinSceanrioConnectionsStats(int runNumber, LrProjectScenarioResults lrProjectScenarioResults, JobLrScenarioResult scenarioRunResult) {
        int scenarioConnectionMax = scenarioRunResult.getConnectionMax();
        if (scenarioConnectionMax != -1) {
            lrProjectScenarioResults.getMaxConnectionsCount().put(runNumber, scenarioConnectionMax);
        }
    }

    private static void scenarioGoalResult(int runNumber, LrProjectScenarioResults lrProjectScenarioResults, GoalResult goalResult) {
        if (goalResult.getStatus().equals((Object)LrTest.SLA_STATUS.NoData)) {
            return;
        }
        switch (goalResult.getSlaGoal()) {
            case AverageThroughput: {
                lrProjectScenarioResults.getAverageThroughputResults().put(runNumber, (WholeRunResult)goalResult);
                break;
            }
            case TotalThroughput: {
                lrProjectScenarioResults.getTotalThroughtputResults().put(runNumber, (WholeRunResult)goalResult);
                break;
            }
            case AverageHitsPerSecond: {
                lrProjectScenarioResults.getAverageHitsPerSecondResults().put(runNumber, (WholeRunResult)goalResult);
                break;
            }
            case TotalHits: {
                lrProjectScenarioResults.getTotalHitsResults().put(runNumber, (WholeRunResult)goalResult);
                break;
            }
            case ErrorsPerSecond: {
                lrProjectScenarioResults.getErrPerSecResults().put(runNumber, (TimeRangeResult)goalResult);
                break;
            }
            case PercentileTRT: {
                if (!lrProjectScenarioResults.getPercentileTransactionResults().containsKey(runNumber)) {
                    lrProjectScenarioResults.getPercentileTransactionResults().put(runNumber, new TreeMap());
                }
                lrProjectScenarioResults.getTransactions().add(((PercentileTransactionWholeRun)goalResult).getName());
                ((TreeMap)lrProjectScenarioResults.getPercentileTransactionResults().get(runNumber)).put(((PercentileTransactionWholeRun)goalResult).getName(), (PercentileTransactionWholeRun)goalResult);
                break;
            }
            case AverageTRT: {
                if (!lrProjectScenarioResults.getAvgTransactionResponseTimeResults().containsKey(runNumber)) {
                    lrProjectScenarioResults.getAvgTransactionResponseTimeResults().put(runNumber, new TreeMap());
                }
                lrProjectScenarioResults.getTransactions().add(((AvgTransactionResponseTime)goalResult).getName());
                ((TreeMap)lrProjectScenarioResults.getAvgTransactionResponseTimeResults().get(runNumber)).put(((AvgTransactionResponseTime)goalResult).getName(), (AvgTransactionResponseTime)goalResult);
                break;
            }
        }
    }

    private boolean isUpdateDataNeeded() {
        return true;
    }
}

