/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results;

import com.microfocus.application.automation.tools.results.projectparser.performance.AvgTransactionResponseTime;
import com.microfocus.application.automation.tools.results.projectparser.performance.LrProjectScenarioResults;
import com.microfocus.application.automation.tools.results.projectparser.performance.PercentileTransactionWholeRun;
import com.microfocus.application.automation.tools.results.projectparser.performance.TimeRangeResult;
import com.microfocus.application.automation.tools.results.projectparser.performance.WholeRunResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public final class LrGraphUtils {
    private static final String X_AXIS_TITLE = "x_axis_title";
    private static final String Y_AXIS_TITLE = "y_axis_title";
    private static final String DESCRIPTION = "description";
    private static final String TITLE = "title";
    private static final String LABELS = "labels";
    private static final String BUILD_NUMBER = "Build number";
    private static final String PERCENTILE_TRANSACTION_RESPONSE_TIME = "Percentile Transaction Response Time";
    private static final String TRANSACTIONS_RESPONSE_TIME_SECONDS = "Time (Sec)";
    private static final String PRECENTILE_GRAPH_DESCRIPTION = "Displays the average time taken to perform transactions during each second of the load test. This graph helps you determine whether the performance of the server is within acceptable minimum and maximum transaction performance time ranges defined for your system.";
    public static final String SERIES = "series";

    private LrGraphUtils() {
    }

    static void constructPercentileTransactionGraph(Map.Entry<String, LrProjectScenarioResults> scenarioResults, JSONObject scenarioGraphData) {
        SortedMap<Integer, TreeMap<String, PercentileTransactionWholeRun>> percentileTransactionResults = scenarioResults.getValue().getPercentileTransactionResults();
        JSONObject percentileTransactionResultsGraphSet = LrGraphUtils.extractPercentileTransactionSet(percentileTransactionResults, scenarioResults.getValue().getTransactions());
        if (!percentileTransactionResultsGraphSet.getJSONArray(LABELS).isEmpty()) {
            percentileTransactionResultsGraphSet.put(TITLE, (Object)PERCENTILE_TRANSACTION_RESPONSE_TIME);
            percentileTransactionResultsGraphSet.put(X_AXIS_TITLE, (Object)BUILD_NUMBER);
            percentileTransactionResultsGraphSet.put(Y_AXIS_TITLE, (Object)TRANSACTIONS_RESPONSE_TIME_SECONDS);
            percentileTransactionResultsGraphSet.put(DESCRIPTION, (Object)PRECENTILE_GRAPH_DESCRIPTION);
            scenarioGraphData.put("percentileTransaction", (Object)percentileTransactionResultsGraphSet);
        }
    }

    private static JSONObject extractPercentileTransactionSet(Map<Integer, TreeMap<String, PercentileTransactionWholeRun>> graphData, HashSet<String> transactions) {
        JSONObject graphDataSet = new JSONObject();
        JSONArray labels = new JSONArray();
        HashMap<String, ArrayList<Number>> percentileTrtData = new HashMap<String, ArrayList<Number>>(0);
        for (String string : transactions) {
            percentileTrtData.put(string, new ArrayList(0));
        }
        for (Map.Entry entry : graphData.entrySet()) {
            labels.add(entry.getKey());
            for (String transaction : transactions) {
                if (!((TreeMap)entry.getValue()).containsKey(transaction)) {
                    percentileTrtData.get(transaction).add(null);
                    continue;
                }
                percentileTrtData.get(transaction).add(((PercentileTransactionWholeRun)((TreeMap)entry.getValue()).get(transaction)).getActualValue());
            }
        }
        graphDataSet.put(LABELS, (Object)labels);
        graphDataSet.put(SERIES, (Object)LrGraphUtils.createGraphDatasets(percentileTrtData));
        return graphDataSet;
    }

    private static JSONArray createGraphDatasets(Map<String, ArrayList<Number>> datasets) {
        JSONArray graphSeries = new JSONArray();
        for (Map.Entry<String, ArrayList<Number>> transactionData : datasets.entrySet()) {
            JSONObject dataset = new JSONObject();
            dataset.put("name", (Object)transactionData.getKey());
            JSONArray data = new JSONArray();
            data.addAll((Collection)transactionData.getValue());
            dataset.put("data", (Object)data);
            graphSeries.add((Object)dataset);
        }
        return graphSeries;
    }

    static void constructAvgTransactionGraph(Map.Entry<String, LrProjectScenarioResults> scenarioResults, JSONObject scenarioGraphData) {
        SortedMap<Integer, TreeMap<String, AvgTransactionResponseTime>> avgTransactionResponseTimeResults = scenarioResults.getValue().getAvgTransactionResponseTimeResults();
        JSONObject avgTransactionResponseTimeGraphSet = LrGraphUtils.extractAvgTrtData(avgTransactionResponseTimeResults, scenarioResults.getValue().getTransactions());
        if (!avgTransactionResponseTimeGraphSet.getJSONArray(LABELS).isEmpty()) {
            avgTransactionResponseTimeGraphSet.put(TITLE, (Object)"Average Transaction Response Time");
            avgTransactionResponseTimeGraphSet.put(X_AXIS_TITLE, (Object)BUILD_NUMBER);
            avgTransactionResponseTimeGraphSet.put(Y_AXIS_TITLE, (Object)"Time (Sec.)");
            avgTransactionResponseTimeGraphSet.put(DESCRIPTION, (Object)PRECENTILE_GRAPH_DESCRIPTION);
            scenarioGraphData.put("averageTransactionResponseTime", (Object)avgTransactionResponseTimeGraphSet);
        }
    }

    private static JSONObject extractAvgTrtData(Map<Integer, TreeMap<String, AvgTransactionResponseTime>> graphData, HashSet<String> transactions) {
        HashMap<String, ArrayList<Number>> averageTRTData = new HashMap<String, ArrayList<Number>>(0);
        JSONObject graphDataSet = new JSONObject();
        JSONArray labels = new JSONArray();
        for (String string : transactions) {
            averageTRTData.put(string, new ArrayList(0));
        }
        for (Map.Entry entry : graphData.entrySet()) {
            labels.add(entry.getKey());
            for (String transaction : transactions) {
                if (!((TreeMap)entry.getValue()).containsKey(transaction)) {
                    averageTRTData.get(transaction).add(null);
                    continue;
                }
                averageTRTData.get(transaction).add(((AvgTransactionResponseTime)((TreeMap)entry.getValue()).get(transaction)).getActualValueAvg());
            }
        }
        graphDataSet.put(LABELS, (Object)labels);
        JSONArray datasets = LrGraphUtils.createGraphDatasets(averageTRTData);
        graphDataSet.put(SERIES, (Object)datasets);
        return graphDataSet;
    }

    static void constructErrorGraph(Map.Entry<String, LrProjectScenarioResults> scenarioResults, JSONObject scenarioGraphData) {
        SortedMap<Integer, TimeRangeResult> errPerSecResults = scenarioResults.getValue().getErrPerSecResults();
        JSONObject errPerSecResultsResultsGraphSet = LrGraphUtils.extractTimeRangeResult(errPerSecResults);
        if (!errPerSecResultsResultsGraphSet.getJSONArray(LABELS).isEmpty()) {
            errPerSecResultsResultsGraphSet.put(TITLE, (Object)"Total errors per second");
            errPerSecResultsResultsGraphSet.put(X_AXIS_TITLE, (Object)BUILD_NUMBER);
            errPerSecResultsResultsGraphSet.put(Y_AXIS_TITLE, (Object)"Errors");
            errPerSecResultsResultsGraphSet.put(DESCRIPTION, (Object)"");
            scenarioGraphData.put("errorPerSecResults", (Object)errPerSecResultsResultsGraphSet);
        }
    }

    private static JSONObject extractTimeRangeResult(Map<Integer, TimeRangeResult> graphData) {
        JSONObject graphDataSet = new JSONObject();
        JSONArray labels = new JSONArray();
        JSONArray datasets = new JSONArray();
        JSONArray data = new JSONArray();
        for (Map.Entry<Integer, TimeRangeResult> result : graphData.entrySet()) {
            if (!result.getValue().getTimeRanges().isEmpty()) continue;
            labels.add((Object)result.getKey());
            data.add((Object)result.getValue().getActualValueAvg());
        }
        graphDataSet.put(LABELS, (Object)labels);
        datasets.add((Object)data);
        graphDataSet.put(SERIES, (Object)datasets);
        return graphDataSet;
    }

    static void constructAverageThroughput(Map.Entry<String, LrProjectScenarioResults> scenarioResults, JSONObject scenarioGraphData) {
        SortedMap<Integer, WholeRunResult> averageThroughputResults = scenarioResults.getValue().getAverageThroughputResults();
        JSONObject averageThroughputResultsGraphSet = LrGraphUtils.extractWholeRunSlaResult(averageThroughputResults, "Bytes/Sec");
        if (!averageThroughputResultsGraphSet.getJSONArray(LABELS).isEmpty()) {
            averageThroughputResultsGraphSet.put(TITLE, (Object)"Average Throughput per second");
            averageThroughputResultsGraphSet.put(X_AXIS_TITLE, (Object)BUILD_NUMBER);
            averageThroughputResultsGraphSet.put(Y_AXIS_TITLE, (Object)"Bytes");
            averageThroughputResultsGraphSet.put(DESCRIPTION, (Object)" Displays the amount of throughput (in bytes) on the Web server during the load test. Throughput represents the amount of data that the Vusers received from the server at any given second. This graph helps you to evaluate the amount of load Vusers generate, in terms of server throughput.\n");
            scenarioGraphData.put("averageThroughput", (Object)averageThroughputResultsGraphSet);
        }
    }

    private static JSONObject extractWholeRunSlaResult(Map<Integer, WholeRunResult> graphData, String seriesName) {
        JSONObject graphDataSet = new JSONObject();
        JSONObject wholeRunSlaResults = new JSONObject();
        JSONArray labels = new JSONArray();
        JSONArray datasets = new JSONArray();
        JSONArray data = new JSONArray();
        for (Map.Entry<Integer, WholeRunResult> result : graphData.entrySet()) {
            labels.add((Object)result.getKey());
            data.add((Object)result.getValue().getActualValue());
        }
        graphDataSet.put(LABELS, (Object)labels);
        wholeRunSlaResults.put("name", (Object)seriesName);
        wholeRunSlaResults.put("data", (Object)data);
        datasets.add((Object)wholeRunSlaResults);
        graphDataSet.put(SERIES, (Object)datasets);
        return graphDataSet;
    }

    static void constructTotalThroughputGraph(Map.Entry<String, LrProjectScenarioResults> scenarioResults, JSONObject scenarioGraphData) {
        SortedMap<Integer, WholeRunResult> totalThroughputResults = scenarioResults.getValue().getTotalThroughtputResults();
        JSONObject totalThroughputResultsGraphSet = LrGraphUtils.extractWholeRunSlaResult(totalThroughputResults, "Bytes");
        if (!totalThroughputResultsGraphSet.getJSONArray(LABELS).isEmpty()) {
            totalThroughputResultsGraphSet.put(TITLE, (Object)"Total Throughput");
            totalThroughputResultsGraphSet.put(X_AXIS_TITLE, (Object)BUILD_NUMBER);
            totalThroughputResultsGraphSet.put(Y_AXIS_TITLE, (Object)"Bytes");
            totalThroughputResultsGraphSet.put(DESCRIPTION, (Object)" Displays the amount of throughput (in bytes) on the Web server during the load test. Throughput represents the amount of data that the Vusers received from the server at any given second. This graph helps you to evaluate the amount of load Vusers generate, in terms of server throughput.\n");
            scenarioGraphData.put("totalThroughput", (Object)totalThroughputResultsGraphSet);
        }
    }

    static void constructAvgHitsGraph(Map.Entry<String, LrProjectScenarioResults> scenarioResults, JSONObject scenarioGraphData) {
        SortedMap<Integer, WholeRunResult> avgHitsPerSec = scenarioResults.getValue().getAverageHitsPerSecondResults();
        JSONObject avgHitsPerSecGraphSet = LrGraphUtils.extractWholeRunSlaResult(avgHitsPerSec, "Hits/Sec");
        if (!avgHitsPerSecGraphSet.getJSONArray(LABELS).isEmpty()) {
            avgHitsPerSecGraphSet.put(TITLE, (Object)"Average Hits per Second");
            avgHitsPerSecGraphSet.put(X_AXIS_TITLE, (Object)BUILD_NUMBER);
            avgHitsPerSecGraphSet.put(Y_AXIS_TITLE, (Object)"Hits");
            avgHitsPerSecGraphSet.put(DESCRIPTION, (Object)"Displays the number of hits made on the Web server by Vusers during each second of the load test. This graph helps you evaluate the amount of load Vusers generate, in terms of the number of hits.");
            scenarioGraphData.put("avgHitsPerSec", (Object)avgHitsPerSecGraphSet);
        }
    }

    static void constructTotalHitsGraph(Map.Entry<String, LrProjectScenarioResults> scenarioResults, JSONObject scenarioGraphData) {
        SortedMap<Integer, WholeRunResult> totalHitsResults = scenarioResults.getValue().getTotalHitsResults();
        JSONObject totalHitsGraphSet = LrGraphUtils.extractWholeRunSlaResult(totalHitsResults, "Hits");
        if (!totalHitsGraphSet.getJSONArray(LABELS).isEmpty()) {
            totalHitsGraphSet.put(TITLE, (Object)"Total Hits");
            totalHitsGraphSet.put(X_AXIS_TITLE, (Object)BUILD_NUMBER);
            totalHitsGraphSet.put(Y_AXIS_TITLE, (Object)"Hits");
            totalHitsGraphSet.put(DESCRIPTION, (Object)"Displays the number of hits made on the Web server by Vusers during each second of the load test. This graph helps you evaluate the amount of load Vusers generate, in terms of the number of hits.");
            scenarioGraphData.put("totalHits", (Object)totalHitsGraphSet);
        }
    }

    private static JSONObject extractVuserResult(Map<Integer, TreeMap<String, Integer>> graphData) {
        JSONObject graphDataSet = new JSONObject();
        JSONArray labels = new JSONArray();
        HashMap<String, ArrayList<Number>> vUserState = new HashMap<String, ArrayList<Number>>(0);
        vUserState.put("Passed", new ArrayList(0));
        vUserState.put("Failed", new ArrayList(0));
        vUserState.put("Stopped", new ArrayList(0));
        vUserState.put("Error", new ArrayList(0));
        for (Map.Entry<Integer, TreeMap<String, Integer>> run : graphData.entrySet()) {
            Number tempVUserCount = run.getValue().get("Count");
            if (tempVUserCount == null || tempVUserCount.intValue() <= 0) continue;
            labels.add((Object)run.getKey());
            vUserState.get("Passed").add(run.getValue().get("Passed"));
            vUserState.get("Failed").add(run.getValue().get("Failed"));
            vUserState.get("Stopped").add(run.getValue().get("Stopped"));
            vUserState.get("Error").add(run.getValue().get("Error"));
        }
        graphDataSet.put(LABELS, (Object)labels);
        graphDataSet.put(SERIES, (Object)LrGraphUtils.createGraphDatasets(vUserState));
        return graphDataSet;
    }

    static void constructVuserGraph(Map.Entry<String, LrProjectScenarioResults> scenarioResults, JSONObject scenarioGraphData) {
        SortedMap<Integer, TreeMap<String, Integer>> vUserResults = scenarioResults.getValue().getvUserPerRun();
        JSONObject vUserGraphSet = LrGraphUtils.extractVuserResult(vUserResults);
        if (!vUserGraphSet.getJSONArray(LABELS).isEmpty()) {
            vUserGraphSet.put(TITLE, (Object)"VUser");
            vUserGraphSet.put(X_AXIS_TITLE, (Object)BUILD_NUMBER);
            vUserGraphSet.put(Y_AXIS_TITLE, (Object)"Vuser count");
            vUserGraphSet.put(DESCRIPTION, (Object)"");
            scenarioGraphData.put("VUser", (Object)vUserGraphSet);
        }
    }

    static void constructConnectionsGraph(Map.Entry<String, LrProjectScenarioResults> scenarioResults, JSONObject scenarioGraphData) {
        SortedMap<Integer, Integer> connectionsResults = scenarioResults.getValue().getMaxConnectionsCount();
        JSONObject maxConnectionsGraphSet = LrGraphUtils.extractConnectionResults(connectionsResults);
        if (!maxConnectionsGraphSet.getJSONArray(LABELS).isEmpty()) {
            maxConnectionsGraphSet.put(TITLE, (Object)"Connections");
            maxConnectionsGraphSet.put(X_AXIS_TITLE, (Object)BUILD_NUMBER);
            maxConnectionsGraphSet.put(Y_AXIS_TITLE, (Object)"Connection count");
            maxConnectionsGraphSet.put(DESCRIPTION, (Object)"");
            scenarioGraphData.put("Connections", (Object)maxConnectionsGraphSet);
        }
    }

    private static JSONObject extractConnectionResults(SortedMap<Integer, Integer> connectionsResults) {
        JSONObject graphDataSet = new JSONObject();
        JSONArray labels = new JSONArray();
        JSONArray data = new JSONArray();
        JSONArray dataSets = new JSONArray();
        JSONObject maxConnections = new JSONObject();
        for (Map.Entry<Integer, Integer> runConnectionMax : connectionsResults.entrySet()) {
            if (runConnectionMax.getValue() == null || runConnectionMax.getValue() <= 0) continue;
            labels.add((Object)runConnectionMax.getKey());
            data.add((Object)runConnectionMax.getValue().toString());
        }
        maxConnections.put("name", (Object)"Max connections");
        maxConnections.put("data", (Object)data);
        dataSets.add((Object)maxConnections);
        graphDataSet.put(LABELS, (Object)labels);
        graphDataSet.put(SERIES, (Object)dataSets);
        return graphDataSet;
    }

    static void constructVuserSummary(SortedMap<String, Integer> vUserResults, JSONObject scenarioStats, int size) {
        JSONObject vUserSummary = new JSONObject();
        int vUserCount = (Integer)vUserResults.get("Count");
        if (vUserCount != 0) {
            double passedVuserPercentile = (double)((Integer)vUserResults.get("Passed")).intValue() / (double)vUserCount * 100.0;
            vUserSummary.put("PassedVuserPercentile", (Object)passedVuserPercentile);
            double failedVuserPercentile = (double)((Integer)vUserResults.get("Failed")).intValue() / (double)vUserCount * 100.0;
            vUserSummary.put("FailedVuserPercentile", (Object)failedVuserPercentile);
            double errorVuserPercentile = (double)((Integer)vUserResults.get("Error")).intValue() / (double)vUserCount * 100.0;
            vUserSummary.put("ErroredVuserPercentile", (Object)errorVuserPercentile);
            int avgMaxVuser = (Integer)vUserResults.get("MaxVuserRun") / size;
            vUserSummary.put("AvgMaxVuser", (Object)avgMaxVuser);
            scenarioStats.put("VUserSummary", (Object)vUserSummary);
        }
    }

    static void constructConnectionSummary(SortedMap<Integer, Integer> maxConnectionPerRun, JSONObject scenarioStats) {
        JSONObject maxConnectionsSummary = new JSONObject();
        int connectionSum = 0;
        for (Integer runConnectionMax : maxConnectionPerRun.values()) {
            if (runConnectionMax <= 0) continue;
            connectionSum += runConnectionMax.intValue();
        }
        int connectionMaxAverage = connectionSum / maxConnectionPerRun.size();
        maxConnectionsSummary.put("AvgMaxConnection", (Object)connectionMaxAverage);
        scenarioStats.put("AvgMaxConnections", (Object)maxConnectionsSummary);
    }

    static void constructTransactionSummary(SortedMap<String, Integer> transactionSummary, JSONObject scenarioStats, int size) {
        JSONObject transactionSum = new JSONObject();
        for (Map.Entry<String, Integer> transaction : transactionSummary.entrySet()) {
            transactionSum.put(transaction.getKey(), (Object)(transaction.getValue() / size));
        }
        scenarioStats.put("TransactionSummary", (Object)transactionSum);
    }

    static void constructDurationSummary(SortedMap<Integer, Long> durationData, JSONObject scenarioStats) {
        JSONObject durationSummary = new JSONObject();
        long runDurationSum = 0L;
        for (Long runDuration : durationData.values()) {
            if (runDuration <= 0L) continue;
            runDurationSum += runDuration.longValue();
        }
        double scenarioDurationAverage = -1.0;
        if (!durationData.isEmpty()) {
            scenarioDurationAverage = (double)runDurationSum / (double)durationData.size();
        }
        durationSummary.put("AvgDuration", (Object)scenarioDurationAverage);
        scenarioStats.put("AvgScenarioDuration", (Object)durationSummary);
    }
}

