/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.rest;

import com.microfocus.application.automation.tools.common.SSEException;
import com.microfocus.application.automation.tools.sse.sdk.Client;
import com.microfocus.application.automation.tools.sse.sdk.HttpRequestDecorator;
import com.microfocus.application.automation.tools.sse.sdk.ResourceAccessLevel;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import hudson.ProxyConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class RestClient
implements Client {
    private final String _serverUrl;
    protected Map<String, String> _cookies = new HashMap<String, String>();
    private final String _restPrefix;
    private final String _webuiPrefix;
    private final String _username;
    private final String XSRF_TOKEN_VALUE;
    private CookieManager cookieManager;

    public RestClient(String url, String domain, String project, String username) {
        if (!url.endsWith("/")) {
            url = String.format("%s/", url);
        }
        this._serverUrl = url;
        this._username = username;
        this._restPrefix = this.getPrefixUrl("rest", String.format("domains/%s", domain), String.format("projects/%s", project));
        this._webuiPrefix = this.getPrefixUrl("webui/alm", domain, project);
        this.XSRF_TOKEN_VALUE = UUID.randomUUID().toString();
        this.cookieManager = new CookieManager();
        CookieHandler.setDefault(this.cookieManager);
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        HttpCookie cookie = new HttpCookie("XSRF-TOKEN", this.XSRF_TOKEN_VALUE);
        cookie.setPath("/qcbin");
        this.cookieManager.getCookieStore().add(uri, cookie);
    }

    @Override
    public String getXsrfTokenValue() {
        return this.XSRF_TOKEN_VALUE;
    }

    @Override
    public String build(String suffix) {
        return String.format("%1$s%2$s", this._serverUrl, suffix);
    }

    @Override
    public String buildRestRequest(String suffix) {
        return String.format("%1$s/%2$s", this._restPrefix, suffix);
    }

    @Override
    public String buildWebUIRequest(String suffix) {
        return String.format("%1$s/%2$s", this._webuiPrefix, suffix);
    }

    @Override
    public Response httpGet(String url, String queryString, Map<String, String> headers, ResourceAccessLevel resourceAccessLevel) {
        Response ret = null;
        try {
            ret = this.doHttp("GET", url, queryString, null, headers, resourceAccessLevel);
        }
        catch (Exception cause) {
            throw new SSEException(cause);
        }
        return ret;
    }

    @Override
    public Response httpPost(String url, byte[] data, Map<String, String> headers, ResourceAccessLevel resourceAccessLevel) {
        Response ret = null;
        try {
            ret = this.doHttp("POST", url, null, data, headers, resourceAccessLevel);
        }
        catch (Exception cause) {
            throw new SSEException(cause);
        }
        return ret;
    }

    @Override
    public Response httpPut(String url, byte[] data, Map<String, String> headers, ResourceAccessLevel resourceAccessLevel) {
        Response ret = null;
        try {
            ret = this.doHttp("PUT", url, null, data, headers, resourceAccessLevel);
        }
        catch (Exception cause) {
            throw new SSEException(cause);
        }
        return ret;
    }

    @Override
    public Response httpDelete(String url, String queryString, Map<String, String> headers, ResourceAccessLevel resourceAccessLevel) {
        Response ret = null;
        try {
            ret = this.doHttp("DELETE", url, queryString, null, headers, resourceAccessLevel);
        }
        catch (Exception cause) {
            throw new SSEException(cause);
        }
        return ret;
    }

    @Override
    public String getServerUrl() {
        return this._serverUrl;
    }

    private String getPrefixUrl(String protocol, String domain, String project) {
        return String.format("%s%s/%s/%s", this._serverUrl, protocol, domain, project);
    }

    private Response doHttp(String type, String url, String queryString, byte[] data, Map<String, String> headers, ResourceAccessLevel resourceAccessLevel) {
        Response ret;
        if (queryString != null && !queryString.isEmpty()) {
            url = (String)url + "?" + queryString;
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)ProxyConfiguration.open((URL)new URL((String)url));
            connection.setRequestMethod(type);
            HashMap<String, String> decoratedHeaders = new HashMap<String, String>();
            if (headers != null) {
                decoratedHeaders.putAll(headers);
            }
            HttpRequestDecorator.decorateHeaderWithUserInfo(decoratedHeaders, this.getUsername(), resourceAccessLevel);
            this.prepareHttpRequest(connection, decoratedHeaders, data);
            connection.connect();
            ret = this.retrieveHtmlResponse(connection);
        }
        catch (Exception cause) {
            throw new SSEException(cause);
        }
        return ret;
    }

    private void prepareHttpRequest(HttpURLConnection connnection, Map<String, String> headers, byte[] bytes) {
        this.setConnectionHeaders(connnection, headers);
        this.setConnectionData(connnection, bytes);
    }

    private void setConnectionData(HttpURLConnection connnection, byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            connnection.setDoOutput(true);
            try {
                OutputStream out = connnection.getOutputStream();
                out.write(bytes);
                out.flush();
                out.close();
            }
            catch (Exception cause) {
                throw new SSEException(cause);
            }
        }
    }

    private void setConnectionHeaders(HttpURLConnection connnection, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                connnection.setRequestProperty(header.getKey(), header.getValue());
            }
        }
    }

    private Response retrieveHtmlResponse(HttpURLConnection connection) {
        InputStream inputStream;
        Response ret = new Response();
        try {
            ret.setStatusCode(connection.getResponseCode());
            ret.setHeaders(connection.getHeaderFields());
        }
        catch (Exception cause) {
            throw new SSEException(cause);
        }
        try {
            inputStream = connection.getInputStream();
        }
        catch (Exception e) {
            inputStream = connection.getErrorStream();
            ret.setFailure(e);
        }
        ByteArrayOutputStream container = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int read;
            while ((read = inputStream.read(buf, 0, 1024)) > 0) {
                container.write(buf, 0, read);
            }
            ret.setData(container.toByteArray());
        }
        catch (Exception ex) {
            throw new SSEException(ex);
        }
        return ret;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    static {
        SSLContext sslcontext;
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new SSEException(e);
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return true;
            }
        });
    }
}

