/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.pipelineSteps;

import com.google.common.collect.ImmutableSet;
import com.microfocus.application.automation.tools.model.EnumDescription;
import com.microfocus.application.automation.tools.model.ResultsPublisherModel;
import com.microfocus.application.automation.tools.model.RunFromFileSystemModel;
import com.microfocus.application.automation.tools.pipelineSteps.UftScenarioLoadStepExecution;
import com.microfocus.application.automation.tools.results.RunResultRecorder;
import com.microfocus.application.automation.tools.run.RunFromFileBuilder;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class UftScenarioLoadStep
extends Step {
    private RunFromFileBuilder runFromFileBuilder;
    private RunResultRecorder runResultRecorder;

    @DataBoundConstructor
    public UftScenarioLoadStep(String testPaths, String archiveTestResultsMode) {
        this.runFromFileBuilder = new RunFromFileBuilder(testPaths);
        this.runResultRecorder = new RunResultRecorder(archiveTestResultsMode);
    }

    public StepExecution start(StepContext stepContext) throws Exception {
        return new UftScenarioLoadStepExecution(stepContext, this);
    }

    @DataBoundSetter
    private void setRunFromFileBuilder(RunFromFileBuilder runFromFileBuilder) {
        this.runFromFileBuilder = runFromFileBuilder;
    }

    @DataBoundSetter
    public void setRunResultRecorder(RunResultRecorder runResultRecorder) {
        this.runResultRecorder = runResultRecorder;
    }

    public String getArchiveTestResultsMode() {
        return this.runResultRecorder.getResultsPublisherModel().getArchiveTestResultsMode();
    }

    public String getFsTimeout() {
        return this.runFromFileBuilder.getRunFromFileModel().getFsTimeout();
    }

    @DataBoundSetter
    public void setFsTimeout(String fsTimeout) {
        this.runFromFileBuilder.setFsTimeout(fsTimeout);
    }

    @DataBoundSetter
    public void setFsReportPath(String fsReportPath) {
        this.runFromFileBuilder.setFsReportPath(fsReportPath);
    }

    public String getFsUftRunMode() {
        return this.runFromFileBuilder.getRunFromFileModel().getFsUftRunMode();
    }

    @DataBoundSetter
    public void setFsUftRunMode(String fsUftRunMode) {
        this.runFromFileBuilder.setFsUftRunMode(fsUftRunMode);
    }

    public List<EnumDescription> getFsUftRunModes() {
        return RunFromFileSystemModel.fsUftRunModes;
    }

    public String getTestPaths() {
        return this.runFromFileBuilder.getRunFromFileModel().getFsTests();
    }

    public String getFsReportPath() {
        return this.runFromFileBuilder.getRunFromFileModel().getFsReportPath();
    }

    public RunFromFileBuilder getRunFromFileBuilder() {
        return this.runFromFileBuilder;
    }

    public RunResultRecorder getRunResultRecorder() {
        return this.runResultRecorder;
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class, FilePath.class);
        }

        public String getFunctionName() {
            return "uftScenarioLoad";
        }

        @Nonnull
        public String getDisplayName() {
            return "Run UFT scenario";
        }

        public List<EnumDescription> getFsUftRunModes() {
            return RunFromFileSystemModel.fsUftRunModes;
        }

        public List<EnumDescription> getReportArchiveModes() {
            return ResultsPublisherModel.archiveModes;
        }

        public FormValidation doCheckTestPaths(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Test path must be set");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFsTests(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Test path must be set");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFsTimeout(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            String val1 = value.trim();
            if (val1.length() > 0 && val1.charAt(0) == '-') {
                val1 = val1.substring(1);
            }
            if (!StringUtils.isNumeric((String)val1) && !Objects.equals(val1, "")) {
                return FormValidation.error((String)"Timeout name must be a number");
            }
            return FormValidation.ok();
        }
    }
}

