/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.pipelineSteps;

import com.microfocus.application.automation.tools.pipelineSteps.SseBuildAndPublishStep;
import com.microfocus.application.automation.tools.results.RunResultRecorder;
import com.microfocus.application.automation.tools.run.RunFromFileBuilder;
import com.microfocus.application.automation.tools.run.SseBuilder;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class SseBuilderPublishResultStepExecution
extends AbstractSynchronousNonBlockingStepExecution<Void> {
    private static final long serialVersionUID = 1L;
    @Inject
    private transient SseBuildAndPublishStep step;
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient FilePath ws;
    @StepContextParameter
    private transient Run build;
    @StepContextParameter
    private transient Launcher launcher;

    protected Void run() throws Exception {
        this.listener.getLogger().println("Execute OpenText functional tests using ALM Lab Management");
        SseBuilder sseBuilder = this.step.getSseBuilder();
        RunResultRecorder runResultRecorder = this.step.getRunResultRecorder();
        String archiveTestResultsMode = runResultRecorder.getResultsPublisherModel().getArchiveTestResultsMode();
        sseBuilder.perform(this.build, this.ws, this.launcher, this.listener);
        if (StringUtils.isNotBlank((String)archiveTestResultsMode)) {
            this.listener.getLogger().println("Publish test results");
            HashMap<String, String> resultFilename = new HashMap<String, String>(0);
            resultFilename.put(RunFromFileBuilder.class.getName(), sseBuilder.getRunResultsFileName());
            runResultRecorder.pipelinePerform(this.build, this.ws, this.launcher, this.listener, resultFilename);
        }
        return null;
    }
}

