/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.pipelineSteps;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.cloudbees.plugins.credentials.matchers.IdMatcher;
import com.microfocus.application.automation.tools.JenkinsUtils;
import com.microfocus.application.automation.tools.model.AlmServerSettingsModel;
import com.microfocus.application.automation.tools.model.CdaDetails;
import com.microfocus.application.automation.tools.model.EnumDescription;
import com.microfocus.application.automation.tools.model.ResultsPublisherModel;
import com.microfocus.application.automation.tools.model.SseModel;
import com.microfocus.application.automation.tools.pipelineSteps.SseBuilderPublishResultStepExecution;
import com.microfocus.application.automation.tools.results.RunResultRecorder;
import com.microfocus.application.automation.tools.run.SseBuilder;
import com.microfocus.application.automation.tools.settings.AlmServerSettingsGlobalConfiguration;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SseBuildAndPublishStep
extends AbstractStepImpl {
    private SseBuilder sseBuilder;
    private RunResultRecorder runResultRecorder;

    public SseBuilder getSseBuilder() {
        return this.sseBuilder;
    }

    public RunResultRecorder getRunResultRecorder() {
        return this.runResultRecorder;
    }

    @DataBoundConstructor
    public SseBuildAndPublishStep(String almServerName, String almProject, String credentialsId, String clientType, String almDomain, String runType, String almEntityId, String timeslotDuration, String archiveTestResultsMode) {
        this.sseBuilder = new SseBuilder(almServerName, almProject, credentialsId, clientType, almDomain, runType, almEntityId, timeslotDuration);
        this.runResultRecorder = new RunResultRecorder(archiveTestResultsMode);
    }

    public String getAlmServerName() {
        return this.sseBuilder.getAlmServerName();
    }

    public String getAlmProject() {
        return this.sseBuilder.getAlmProject();
    }

    public String getCredentialsId() {
        return this.sseBuilder.getCredentialsId();
    }

    public String getAlmDomain() {
        return this.sseBuilder.getAlmDomain();
    }

    public String getClientType() {
        return this.sseBuilder.getClientType();
    }

    public String getRunType() {
        return this.sseBuilder.getRunType();
    }

    public String getAlmEntityId() {
        return this.sseBuilder.getAlmEntityId();
    }

    public String getTimeslotDuration() {
        return this.sseBuilder.getTimeslotDuration();
    }

    public String getArchiveTestResultsMode() {
        return this.runResultRecorder.getResultsPublisherModel().getArchiveTestResultsMode();
    }

    @DataBoundSetter
    public void setDescription(String description) {
        this.sseBuilder.setDescription(description);
    }

    public String getDescription() {
        return this.sseBuilder.getDescription();
    }

    @DataBoundSetter
    public void setPostRunAction(String postRunAction) {
        this.sseBuilder.setPostRunAction(postRunAction);
    }

    public String getPostRunAction() {
        return this.sseBuilder.getPostRunAction();
    }

    @DataBoundSetter
    public void setEnvironmentConfigurationId(String environmentConfigurationId) {
        this.sseBuilder.setEnvironmentConfigurationId(environmentConfigurationId);
    }

    public String getEnvironmentConfigurationId() {
        return this.sseBuilder.getEnvironmentConfigurationId();
    }

    @DataBoundSetter
    public void setCdaDetails(CdaDetails cdaDetails) {
        this.sseBuilder.setCdaDetails(cdaDetails);
    }

    public CdaDetails getCdaDetails() {
        return this.sseBuilder.getCdaDetails();
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        private final int minimumDurationTime = 30;

        public DescriptorImpl() {
            super(SseBuilderPublishResultStepExecution.class);
        }

        public String getFunctionName() {
            return "sseBuildAndPublish";
        }

        public String getDisplayName() {
            return "Execute OpenText functional tests using ALM Lab Management and Publish test results";
        }

        public boolean hasAlmServers() {
            return AlmServerSettingsGlobalConfiguration.getInstance().hasAlmServers();
        }

        public AlmServerSettingsModel[] getAlmServers() {
            return AlmServerSettingsGlobalConfiguration.getInstance().getInstallations();
        }

        public FormValidation doCheckTimeslotDuration(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Timeslot duration must be set");
            }
            String val1 = value.trim();
            if (!StringUtils.isNumeric((String)val1)) {
                return FormValidation.error((String)"Timeslot duration must be a number");
            }
            if (Integer.valueOf(val1) < 30) {
                return FormValidation.error((String)"Timeslot duration must be higher than 30");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAlmDomain(@QueryParameter String value) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((String)value)) {
                ret = FormValidation.error((String)"Domain must be set");
            }
            return ret;
        }

        public FormValidation doCheckAlmProject(@QueryParameter String value) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((String)value)) {
                ret = FormValidation.error((String)"Project must be set");
            }
            return ret;
        }

        public FormValidation doCheckAlmEntityId(@QueryParameter String value) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((String)value)) {
                ret = FormValidation.error((String)"Entity ID must be set.");
            }
            return ret;
        }

        public List<EnumDescription> getRunTypes() {
            return SseModel.getRunTypes();
        }

        public List<EnumDescription> getPostRunActions() {
            return SseModel.getPostRunActions();
        }

        public List<EnumDescription> getDeploymentActions() {
            return CdaDetails.getDeploymentActions();
        }

        public static List<EnumDescription> getDeprovisioningActions() {
            return CdaDetails.getDeprovisioningActions();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String credentialsId) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardUsernameListBoxModel().includeEmptyValue().includeAs(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM, project, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.create().build()).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String url, @QueryParameter String value) {
            if (project == null || !project.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.ok();
            }
            if ((url = Util.fixEmptyAndTrim((String)url)) == null) {
                return FormValidation.ok();
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM), (List)URIRequirementBuilder.create().build(), (CredentialsMatcher)new IdMatcher(value))) {
                if (!StringUtils.equals((String)value, (String)o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Cannot find any credentials with id " + value));
        }

        public List<EnumDescription> getReportArchiveModes() {
            return ResultsPublisherModel.archiveModes;
        }

        public boolean getHasConfigurePermission() {
            return JenkinsUtils.hasItemConfigurePermission();
        }
    }
}

