/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.pipelineSteps;

import com.microfocus.application.automation.tools.pipelineSteps.LoadRunnerTestStep;
import com.microfocus.application.automation.tools.run.RunFromFileBuilder;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class LrScenarioLoadStepExecution
extends AbstractSynchronousNonBlockingStepExecution<Void> {
    private static final Logger logger = Logger.getLogger(LrScenarioLoadStepExecution.class.getName());
    private static final long serialVersionUID = 1L;
    @Inject
    private transient LoadRunnerTestStep step;
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient FilePath ws;
    @StepContextParameter
    private transient Run build;
    @StepContextParameter
    private transient Launcher launcher;

    protected Void run() throws InterruptedException {
        this.listener.getLogger().println("Running LoadRunner Scenario step");
        try {
            this.step.getRunFromFileBuilder().perform(this.build, this.ws, this.launcher, this.listener);
        }
        catch (IOException e) {
            this.listener.fatalError("LoadRunnner scenario run stage encountered an IOException " + String.valueOf(e));
            this.build.setResult(Result.FAILURE);
            return null;
        }
        HashMap<String, String> resultFilename = new HashMap<String, String>(0);
        resultFilename.put(RunFromFileBuilder.class.getName(), this.step.getRunFromFileBuilder().getRunResultsFileName());
        try {
            this.step.getRunResultRecorder().pipelinePerform(this.build, this.ws, this.launcher, this.listener, resultFilename);
        }
        catch (IOException e) {
            this.listener.fatalError("LoadRunnner scenario run result recorder stage encountered an IOException " + String.valueOf(e));
            this.build.setResult(Result.FAILURE);
            return null;
        }
        return null;
    }
}

