/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.pipelineSteps;

import com.microfocus.application.automation.tools.run.RunLoadRunnerScript;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class LoadRunnerScriptStep
extends AbstractStepImpl {
    private final RunLoadRunnerScript runLoadRunnerScript;

    @DataBoundConstructor
    public LoadRunnerScriptStep(String scriptPath) {
        this.runLoadRunnerScript = new RunLoadRunnerScript(scriptPath);
    }

    public String getScriptPath() {
        return this.runLoadRunnerScript.getScriptsPath();
    }

    public RunLoadRunnerScript getRunLoadRunnerScript() {
        return this.runLoadRunnerScript;
    }

    private static class LoadRunnerScriptStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final Logger logger = Logger.getLogger(LoadRunnerScriptStepExecution.class.getName());
        private static final long serialVersionUID = 1L;
        @Inject
        private transient LoadRunnerScriptStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient EnvVars env;
        @StepContextParameter
        private transient Computer computer;
        @StepContextParameter
        private transient Node node;

        protected Void run() throws Exception {
            this.listener.getLogger().println("Running LoadRunner Script Runner step");
            try {
                this.step.getRunLoadRunnerScript().perform(this.build, this.ws, this.launcher, this.listener, this.env);
            }
            catch (IOException e) {
                this.listener.fatalError("LoadRunner script runner stage encountered an IOException " + String.valueOf(e));
                this.build.setResult(Result.FAILURE);
                return null;
            }
            return null;
        }
    }

    @Extension
    @Symbol(value={"runLoadRunnerScript"})
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(LoadRunnerScriptStepExecution.class);
        }

        public String getFunctionName() {
            return "runLoadRunnerScript";
        }

        @Nonnull
        public String getDisplayName() {
            return "Run LoadRunner script";
        }
    }
}

