/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.pc;

import com.microfocus.adm.performancecenter.plugins.common.pcentities.PostRunAction;
import com.microfocus.application.automation.tools.model.SecretContainer;
import com.microfocus.application.automation.tools.model.SecretContainerImpl;
import java.util.Arrays;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class PcModel {
    public static final String COLLATE = "Collate Results";
    public static final String COLLATE_ANALYZE = "Collate and Analyze";
    public static final String DO_NOTHING = "Do Not Collate";
    private final String serverAndPort;
    private final String pcServerName;
    private final String credentialsId;
    private final String almDomain;
    private final String almProject;
    private final String testId;
    private final String autoTestInstanceID;
    private final PostRunAction postRunAction;
    private final boolean vudsMode;
    private final String description;
    private final String addRunToTrendReport;
    private final boolean HTTPSProtocol;
    private final String proxyOutURL;
    private final String credentialsProxyId;
    private final boolean authenticateWithToken;
    private String testInstanceId;
    private String trendReportId;
    private String buildParameters;
    private String retry;
    private String retryDelay;
    private String retryOccurrences;
    private String timeslotDurationHours;
    private String timeslotDurationMinutes;

    @DataBoundConstructor
    public PcModel(String serverAndPort, String pcServerName, String credentialsId, String almDomain, String almProject, String testId, String autoTestInstanceID, String testInstanceId, String timeslotDurationHours, String timeslotDurationMinutes, PostRunAction postRunAction, boolean vudsMode, String description, String addRunToTrendReport, String trendReportId, boolean HTTPSProtocol, String proxyOutURL, String credentialsProxyId, String retry, String retryDelay, String retryOccurrences, boolean authenticateWithToken) {
        this.serverAndPort = serverAndPort;
        this.pcServerName = pcServerName;
        this.credentialsId = credentialsId;
        this.almDomain = almDomain;
        this.almProject = almProject;
        this.testId = testId;
        this.autoTestInstanceID = autoTestInstanceID;
        this.testInstanceId = testInstanceId;
        this.timeslotDurationHours = timeslotDurationHours;
        this.timeslotDurationMinutes = timeslotDurationMinutes;
        this.postRunAction = postRunAction;
        this.vudsMode = vudsMode;
        this.description = description;
        this.addRunToTrendReport = addRunToTrendReport;
        this.HTTPSProtocol = HTTPSProtocol;
        this.trendReportId = trendReportId;
        this.proxyOutURL = proxyOutURL;
        this.credentialsProxyId = credentialsProxyId;
        this.buildParameters = "";
        this.retry = retry;
        this.retryDelay = this.verifyStringValueIsIntAndPositive(retryDelay, 5);
        this.retryOccurrences = this.verifyStringValueIsIntAndPositive(retryOccurrences, 3);
        this.authenticateWithToken = authenticateWithToken;
    }

    private static boolean isInteger(String s, int radix) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), radix) < 0)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInteger(String s) {
        return PcModel.isInteger(s, 10);
    }

    public static List<PostRunAction> getPostRunActions() {
        return Arrays.asList(PostRunAction.values());
    }

    private static String useParameterIfNeeded(String buildParameters, String attribute) {
        if (buildParameters != null && attribute != null && attribute.startsWith("$")) {
            String[] buildParametersArray;
            String attributeParameter = attribute.replace("$", "").replace("{", "").replace("}", "");
            for (String buildParameter : buildParametersArray = buildParameters.replace("{", "").replace("}", "").split(",")) {
                if (!buildParameter.trim().startsWith(attributeParameter + "=")) continue;
                return buildParameter.trim().replace(attributeParameter + "=", "");
            }
        }
        return attribute;
    }

    private String verifyStringValueIsIntAndPositive(String supplied, int defaultValue) {
        int suppliedInt;
        if (supplied != null && PcModel.isInteger(supplied) && (suppliedInt = Integer.parseInt(supplied)) > 0) {
            return Integer.toString(suppliedInt);
        }
        return Integer.toString(defaultValue);
    }

    public String getRetry() {
        return this.retry;
    }

    public String getRetryDelay() {
        return this.retryDelay;
    }

    public String getRetryOccurrences() {
        return this.retryOccurrences;
    }

    protected SecretContainer setPassword(String almPassword) {
        SecretContainerImpl secretContainer = new SecretContainerImpl();
        secretContainer.initialize(almPassword);
        return secretContainer;
    }

    public String getserverAndPort() {
        return this.serverAndPort;
    }

    public String getPcServerName() {
        return this.pcServerName;
    }

    public String getPcServerName(boolean fromPcClient) {
        return fromPcClient ? PcModel.useParameterIfNeeded(this.buildParameters, this.pcServerName) : this.getPcServerName();
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getCredentialsId(boolean fromPcClient) {
        return fromPcClient ? PcModel.useParameterIfNeeded(this.buildParameters, this.credentialsId) : this.getCredentialsId();
    }

    public String getCredentialsProxyId() {
        return this.credentialsProxyId;
    }

    public String getCredentialsProxyId(boolean fromPcClient) {
        return fromPcClient ? PcModel.useParameterIfNeeded(this.buildParameters, this.credentialsProxyId) : this.getCredentialsProxyId();
    }

    public String getAlmDomain() {
        return this.almDomain;
    }

    public String getAlmDomain(boolean fromPcClient) {
        return fromPcClient ? PcModel.useParameterIfNeeded(this.buildParameters, this.almDomain) : this.getAlmDomain();
    }

    public String getAlmProject() {
        return this.almProject;
    }

    public String getAlmProject(boolean fromPcClient) {
        return fromPcClient ? PcModel.useParameterIfNeeded(this.buildParameters, this.almProject) : this.getAlmProject();
    }

    public String getTestId() {
        return this.testId;
    }

    public String getTestId(boolean fromPcClient) {
        return fromPcClient ? PcModel.useParameterIfNeeded(this.buildParameters, this.testId) : this.getTestId();
    }

    public String getTestInstanceId() {
        return this.testInstanceId;
    }

    public String getTestInstanceId(boolean fromPcClient) {
        return fromPcClient ? PcModel.useParameterIfNeeded(this.buildParameters, this.testInstanceId) : this.getTestInstanceId();
    }

    public String getAutoTestInstanceID() {
        return this.autoTestInstanceID;
    }

    public String getTimeslotDurationHours() {
        return this.timeslotDurationHours;
    }

    public String getTimeslotDurationHours(boolean fromPcClient) {
        return fromPcClient ? PcModel.useParameterIfNeeded(this.buildParameters, this.timeslotDurationHours) : this.getTimeslotDurationHours();
    }

    public String getTimeslotDurationMinutes() {
        return this.timeslotDurationMinutes;
    }

    public String getTimeslotDurationMinutes(boolean fromPcClient) {
        return fromPcClient ? PcModel.useParameterIfNeeded(this.buildParameters, this.timeslotDurationMinutes) : this.getTimeslotDurationMinutes();
    }

    public boolean isVudsMode() {
        return this.vudsMode;
    }

    public PostRunAction getPostRunAction() {
        return this.postRunAction;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean httpsProtocol() {
        return this.HTTPSProtocol;
    }

    public String getProxyOutURL() {
        return this.proxyOutURL;
    }

    public String getProxyOutURL(boolean fromPcClient) {
        return fromPcClient ? PcModel.useParameterIfNeeded(this.buildParameters, this.proxyOutURL) : this.getProxyOutURL();
    }

    public String getBuildParameters() {
        return this.buildParameters;
    }

    public void setBuildParameters(String buildParameters) {
        this.buildParameters = buildParameters;
    }

    public String toString() {
        return String.format("%s", this.runParamsToString().substring(1));
    }

    public String runParamsToString() {
        String vudsModeString = this.vudsMode ? "true" : "false";
        String trendString = "USE_ID".equals(this.addRunToTrendReport) ? String.format(", TrendReportID = '%s'", this.trendReportId) : "";
        return String.format("[PCServer='%s', CredentialsId='%s', Domain='%s', Project='%s', TestID='%s', TestInstanceID='%s', TimeslotDurationHours='%s', TimeslotDurationMinutes='%s', PostRunAction='%s', VUDsMode='%s, trending='%s', HTTPSProtocol='%s', authenticateWithToken='%s']", this.pcServerName, this.credentialsId, this.almDomain, this.almProject, this.testId, this.testInstanceId, this.timeslotDurationHours, this.timeslotDurationMinutes, this.postRunAction.getValue(), vudsModeString, trendString, this.HTTPSProtocol, this.authenticateWithToken);
    }

    public String getTrendReportId() {
        return this.trendReportId;
    }

    public void setTrendReportId(String trendReportId) {
        this.trendReportId = trendReportId;
    }

    public String getTrendReportId(boolean fromPcClient) {
        return fromPcClient ? PcModel.useParameterIfNeeded(this.buildParameters, this.trendReportId) : this.getTrendReportId();
    }

    public String getAddRunToTrendReport() {
        return this.addRunToTrendReport;
    }

    public String isHTTPSProtocol() {
        if (!this.HTTPSProtocol) {
            return "http";
        }
        return "https";
    }

    public boolean isAuthenticateWithToken() {
        return this.authenticateWithToken;
    }
}

