/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.tests.xml;

import com.hp.octane.integrations.testresults.XmlWritableTestResult;
import com.microfocus.application.automation.tools.octane.tests.TestResultContainer;
import com.microfocus.application.automation.tools.octane.tests.build.BuildDescriptor;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import com.microfocus.application.automation.tools.octane.tests.detection.ResultFields;
import hudson.FilePath;
import hudson.model.Run;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class TestResultXmlWriter {
    private FilePath targetPath;
    private BuildDescriptor buildDescriptor;
    private XMLStreamWriter writer;
    private OutputStream outputStream;

    public TestResultXmlWriter(FilePath targetPath, BuildDescriptor buildDescriptor) {
        this.targetPath = targetPath;
        this.buildDescriptor = buildDescriptor;
    }

    public TestResultXmlWriter(FilePath targetPath, Run build) {
        this.targetPath = targetPath;
        this.buildDescriptor = BuildHandlerUtils.getBuildType(build);
    }

    public void writeResults(TestResultContainer testResultContainer) throws InterruptedException, XMLStreamException, IOException {
        if (testResultContainer != null) {
            ResultFields resultFields = testResultContainer.getResultFields();
            this.initialize(resultFields);
            Iterator<XmlWritableTestResult> testResults = testResultContainer.getIterator();
            while (testResults.hasNext()) {
                XmlWritableTestResult testResult = testResults.next();
                testResult.writeXmlElement(this.writer);
            }
        }
    }

    public void close() throws XMLStreamException {
        if (this.outputStream != null) {
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
            this.writer.close();
            IOUtils.closeQuietly((OutputStream)this.outputStream);
        }
    }

    private void initialize(ResultFields resultFields) throws IOException, InterruptedException, XMLStreamException {
        if (this.outputStream == null) {
            this.outputStream = this.targetPath.write();
            this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(this.outputStream, StandardCharsets.UTF_8.name());
            this.writer.writeStartDocument();
            this.writer.writeStartElement("test_result");
            this.writer.writeStartElement("build");
            this.writer.writeAttribute("server_id", "to-be-filled-in-SDK");
            this.writer.writeAttribute("job_id", this.buildDescriptor.getJobId());
            this.writer.writeAttribute("build_id", this.buildDescriptor.getBuildId());
            if (!StringUtils.isEmpty((String)this.buildDescriptor.getSubType())) {
                this.writer.writeAttribute("sub_type", this.buildDescriptor.getSubType());
            }
            this.writer.writeEndElement();
            this.writeFields(resultFields);
            this.writer.writeStartElement("test_runs");
        }
    }

    private void writeFields(ResultFields resultFields) throws XMLStreamException {
        if (resultFields != null) {
            this.writer.writeStartElement("test_fields");
            this.writeField("Framework", resultFields.getFramework());
            this.writeField("Test_Level", resultFields.getTestLevel());
            this.writeField("Testing_Tool_Type", resultFields.getTestingTool());
            this.writeField("Test_Type", resultFields.getTestType());
            this.writer.writeEndElement();
        }
    }

    private void writeField(String type, String value) throws XMLStreamException {
        if (StringUtils.isNotEmpty((String)value)) {
            this.writer.writeStartElement("test_field");
            this.writer.writeAttribute("type", type);
            this.writer.writeAttribute("value", value);
            this.writer.writeEndElement();
        }
    }
}

