/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.tests.junit;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.executor.impl.TestingToolType;
import com.hp.octane.integrations.dto.tests.Property;
import com.hp.octane.integrations.dto.tests.TestSuite;
import com.hp.octane.integrations.executor.converters.MfMBTConverter;
import com.hp.octane.integrations.uft.ufttestresults.UftTestResultsUtils;
import com.hp.octane.integrations.uft.ufttestresults.schema.UftResultIterationData;
import com.hp.octane.integrations.uft.ufttestresults.schema.UftResultStepData;
import com.hp.octane.integrations.uft.ufttestresults.schema.UftResultStepParameter;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.tests.HPRunnerType;
import com.microfocus.application.automation.tools.octane.tests.junit.JUnitTestResult;
import com.microfocus.application.automation.tools.octane.tests.junit.ModuleDetection;
import com.microfocus.application.automation.tools.octane.tests.junit.TestError;
import com.microfocus.application.automation.tools.octane.tests.junit.TestResultStatus;
import com.microfocus.application.automation.tools.octane.tests.junit.codeless.CodelessResult;
import com.microfocus.application.automation.tools.octane.tests.junit.codeless.CodelessResultParameter;
import com.microfocus.application.automation.tools.octane.tests.junit.codeless.CodelessResultUnit;
import com.microfocus.application.automation.tools.octane.tests.xml.AbstractXmlIterator;
import hudson.FilePath;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileSystem;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class JUnitXmlIterator
extends AbstractXmlIterator<JUnitTestResult> {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(JUnitXmlIterator.class);
    private final FilePath workspace;
    private final long buildStarted;
    private final String buildId;
    private final String jobName;
    private final HPRunnerType hpRunnerType;
    private boolean stripPackageAndClass;
    private String moduleName;
    private String moduleNameFromFile;
    private String packageName;
    private String id;
    private String className;
    private String testName;
    private long testDuration;
    private TestResultStatus status;
    private String stackTraceStr;
    private String errorType;
    private String errorMsg;
    private String externalURL;
    private String uftResultFilePath;
    private String description;
    private List<ModuleDetection> moduleDetection;
    private String jenkinsRootUrl;
    private String sharedCheckOutDirectory;
    private Object additionalContext;
    private String filePath;
    public static final String SRL_REPORT_URL = "reportUrl";
    private Pattern testParserRegEx;
    private String externalRunId;
    private List<UftResultIterationData> uftResultData;
    private boolean octaneSupportsSteps;
    private TestingToolType testingToolType = TestingToolType.UFT;
    private long stepDuration;
    private boolean insideCaseElement = false;
    private JUnitTestResult currentJUnitTestResult;
    private List<UftResultStepData> currentIterationSteps;
    private Map<String, JUnitTestResult> testNameToJunitResultMap = new HashMap<String, JUnitTestResult>();
    private String stepName;
    private ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private Map<String, CodelessResult> testNameToCodelessResultMap = new HashMap<String, CodelessResult>();
    private Set<String> nodeNames;
    private List<Builder> builders;
    private final int ERROR_MESSAGE_MAX_SIZE = System.getProperty("octane.sdk.tests.error_message_max_size") != null ? Integer.parseInt(System.getProperty("octane.sdk.tests.error_message_max_size")) : 262144;
    private final int ERROR_DETAILS_MAX_SIZE = System.getProperty("octane.sdk.tests.error_details_max_size") != null ? Integer.parseInt(System.getProperty("octane.sdk.tests.error_details_max_size")) : 262144;

    public JUnitXmlIterator(InputStream read, List<ModuleDetection> moduleDetection, FilePath workspace, String sharedCheckOutDirectory, String jobName, String buildId, long buildStarted, boolean stripPackageAndClass, HPRunnerType hpRunnerType, String jenkinsRootUrl, Object additionalContext, Pattern testParserRegEx, boolean octaneSupportsSteps, Set<String> nodeNames, List<Builder> builders) throws XMLStreamException {
        super(read);
        this.stripPackageAndClass = stripPackageAndClass;
        this.moduleDetection = moduleDetection;
        this.workspace = workspace;
        this.sharedCheckOutDirectory = sharedCheckOutDirectory;
        this.buildId = buildId;
        this.jobName = jobName;
        this.buildStarted = buildStarted;
        this.hpRunnerType = hpRunnerType;
        this.jenkinsRootUrl = jenkinsRootUrl;
        this.additionalContext = additionalContext;
        this.testParserRegEx = testParserRegEx;
        this.octaneSupportsSteps = octaneSupportsSteps;
        this.nodeNames = nodeNames;
        this.builders = builders;
    }

    private static long parseTime(String timeString) {
        String time = timeString.replace(",", "");
        try {
            float seconds = Float.parseFloat(time);
            return (long)(seconds * 1000.0f);
        }
        catch (NumberFormatException e) {
            try {
                return new DecimalFormat().parse(time).longValue();
            }
            catch (ParseException ex) {
                logger.debug("Unable to parse test duration: " + timeString);
                return 0L;
            }
        }
    }

    @Override
    protected void onEvent(XMLEvent event) throws XMLStreamException, IOException, InterruptedException {
        if (this.testingToolType.equals((Object)TestingToolType.CODELESS)) {
            this.handleCodelessTest(event);
        } else {
            this.handleJUnitTest(event);
        }
    }

    private void handleJUnitTest(XMLEvent event) throws XMLStreamException, IOException, InterruptedException {
        if (event instanceof StartElement) {
            StartElement element = (StartElement)event;
            String localName = element.getName().getLocalPart();
            if ("file".equals(localName)) {
                this.filePath = this.peekNextValue();
                if (this.checkIsCodelessTestResult(this.filePath)) {
                    this.testingToolType = TestingToolType.CODELESS;
                    this.handleCodelessTest(event);
                } else {
                    this.filePath = this.readNextValue();
                    this.testingToolType = TestingToolType.UFT;
                    for (ModuleDetection detection : this.moduleDetection) {
                        this.moduleNameFromFile = this.moduleName = detection.getModule(new FilePath(new File(this.filePath)));
                        if (this.moduleName == null) continue;
                        break;
                    }
                }
            } else if ("id".equals(localName)) {
                this.id = this.readNextValue();
            } else if ("case".equals(localName)) {
                this.resetTestData();
            } else if ("className".equals(localName)) {
                String fqn = this.readNextValue();
                int moduleIndex = fqn.indexOf("::");
                if (moduleIndex > 0) {
                    this.moduleName = fqn.substring(0, moduleIndex);
                    fqn = fqn.substring(moduleIndex + 2);
                }
                int p = fqn.lastIndexOf(46);
                this.className = fqn.substring(p + 1);
                this.packageName = p > 0 ? fqn.substring(0, p) : "";
            } else if ("stdout".equals(localName)) {
                String stdoutValue = this.readNextValue();
                if (stdoutValue != null) {
                    if ((this.hpRunnerType.equals((Object)HPRunnerType.UFT) || this.hpRunnerType.equals((Object)HPRunnerType.UFT_MBT)) && stdoutValue.contains("Test result: Warning")) {
                        this.errorMsg = "Test ended with 'Warning' status.";
                        this.parseUftErrorMessages();
                    }
                    this.externalURL = this.extractValueFromStdout(stdoutValue, "__octane_external_url_start__", "__octane_external_url_end__", this.externalURL);
                    this.description = this.extractValueFromStdout(stdoutValue, "__octane_description_start__", "__octane_description_end__", this.description);
                }
            } else if ("testName".equals(localName)) {
                this.testName = this.readNextValue();
                if (this.testName != null && this.testName.endsWith("()")) {
                    this.testName = this.testName.substring(0, this.testName.length() - 2);
                }
                if (this.hpRunnerType.equals((Object)HPRunnerType.UFT) || this.hpRunnerType.equals((Object)HPRunnerType.UFT_MBT)) {
                    if (this.testName != null && this.testName.contains("..")) {
                        this.testName = new File(FilenameUtils.separatorsToSystem((String)this.testName)).getCanonicalPath();
                    }
                    String myPackageName = this.packageName;
                    String myClassName = this.className;
                    String myTestName = this.testName;
                    this.packageName = "";
                    this.className = "";
                    logger.log(Level.DEBUG, "testName: " + this.testName);
                    logger.log(Level.DEBUG, "hpRunnerType: " + String.valueOf((Object)this.hpRunnerType));
                    int uftTextIndexStart = this.getUftTestIndexStart(this.workspace, this.sharedCheckOutDirectory, this.testName, this.builders);
                    logger.log(Level.DEBUG, "uftTextIndexStart: " + uftTextIndexStart);
                    if (uftTextIndexStart != -1) {
                        String path = this.testName.substring(uftTextIndexStart).replace("/", "\\");
                        boolean isMBT = path.startsWith("___mbt");
                        if (isMBT) {
                            path = path.substring("___mbt".length() + 1);
                            path = path.substring(path.indexOf("\\"));
                        }
                        if ((path = StringUtils.strip((String)path, (String)"\\")).contains("\\")) {
                            int testNameStartIndex = path.lastIndexOf("\\");
                            this.testName = path.substring(testNameStartIndex + 1);
                            this.packageName = path.substring(0, testNameStartIndex);
                        } else {
                            this.testName = path;
                            if (isMBT) {
                                this.testName = MfMBTConverter.decodeTestNameIfRequired((String)this.testName);
                            }
                        }
                    }
                    String cleanedTestName = this.cleanTestName(this.testName);
                    String nodeName = "";
                    if (!this.nodeNames.isEmpty()) {
                        nodeName = (String)this.nodeNames.stream().findFirst().get();
                    }
                    boolean testReportCreated = true;
                    if (this.additionalContext != null && this.additionalContext instanceof List) {
                        String nodeTestString;
                        List createdTests = (List)this.additionalContext;
                        String searchFor = cleanedTestName + "[";
                        Optional<String> optional = createdTests.stream().filter(str -> str.contains(searchFor)).findFirst();
                        if (optional.isPresent() && (nodeTestString = optional.get()).contains("/")) {
                            String node = nodeTestString.split("/")[0];
                            if (this.nodeNames.contains(node)) {
                                nodeName = node;
                            }
                            cleanedTestName = nodeTestString.split("/")[1];
                            createdTests.remove(nodeTestString);
                        }
                        testReportCreated = optional.isPresent();
                    }
                    if (testReportCreated) {
                        String basePath = (String)((List)this.additionalContext).get(0);
                        Object nodeNameSubFolder = StringUtils.isNotEmpty((String)nodeName) ? nodeName + "/" : "";
                        this.uftResultFilePath = Paths.get(basePath, new String[]{"archive", "UFTReport", nodeNameSubFolder, cleanedTestName, "/Result/run_results.xml"}).toFile().getCanonicalPath();
                        String urlEncodedTestName = URLEncoder.encode(cleanedTestName, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
                        this.externalURL = this.jenkinsRootUrl + "job/" + this.jobName + "/" + this.buildId + "/artifact/UFTReport/" + (String)nodeNameSubFolder + urlEncodedTestName + "/Result/run_results.html";
                    } else {
                        this.externalURL = this.jenkinsRootUrl + "job/" + this.jobName + "/" + this.buildId + "/testReport/" + myPackageName + "/" + this.jenkinsTestClassFormat(myClassName) + "/" + this.jenkinsTestNameFormat(myTestName) + "/";
                    }
                } else if (this.hpRunnerType.equals((Object)HPRunnerType.PerformanceCenter)) {
                    this.externalURL = this.jenkinsRootUrl + "job/" + this.jobName + "/" + this.buildId + "/artifact/performanceTestsReports/pcRun/Report.html";
                } else if (this.hpRunnerType.equals((Object)HPRunnerType.StormRunnerLoad)) {
                    this.externalURL = JUnitXmlIterator.tryGetStormRunnerReportURLFromJunitFile(this.filePath);
                    if (StringUtils.isEmpty((String)this.externalURL) && this.additionalContext != null && this.additionalContext instanceof Collection) {
                        this.externalURL = JUnitXmlIterator.tryGetStormRunnerReportURLFromLog((Collection)this.additionalContext);
                    }
                }
            } else if ("duration".equals(localName)) {
                this.testDuration = JUnitXmlIterator.parseTime(this.readNextValue());
            } else if ("skipped".equals(localName)) {
                if ("true".equals(this.readNextValue())) {
                    this.status = TestResultStatus.SKIPPED;
                }
            } else if ("failedSince".equals(localName)) {
                if (!"0".equals(this.readNextValue()) && !TestResultStatus.SKIPPED.equals((Object)this.status)) {
                    this.status = TestResultStatus.FAILED;
                }
            } else if ("errorStackTrace".equals(localName)) {
                this.status = TestResultStatus.FAILED;
                this.stackTraceStr = "";
                if (this.peek() instanceof Characters) {
                    this.stackTraceStr = this.readNextValue();
                    int index = this.stackTraceStr.indexOf("at ");
                    if (index >= 0) {
                        this.errorType = this.stackTraceStr.substring(0, index);
                    }
                }
            } else if ("errorDetails".equals(localName)) {
                this.status = TestResultStatus.FAILED;
                this.errorMsg = this.readNextValue();
                int index = this.stackTraceStr.indexOf(58);
                if (index >= 0) {
                    this.errorType = this.stackTraceStr.substring(0, index);
                }
                if ((this.hpRunnerType.equals((Object)HPRunnerType.UFT) || this.hpRunnerType.equals((Object)HPRunnerType.UFT_MBT)) && StringUtils.isNotEmpty((String)this.errorMsg)) {
                    this.parseUftErrorMessages();
                }
            }
        } else if (event instanceof EndElement) {
            EndElement element = (EndElement)event;
            String localName = element.getName().getLocalPart();
            if ("case".equals(localName)) {
                this.errorMsg = StringUtils.length((String)this.errorMsg) > this.ERROR_MESSAGE_MAX_SIZE ? StringUtils.abbreviate((String)this.errorMsg, (int)this.ERROR_MESSAGE_MAX_SIZE) : this.errorMsg;
                this.stackTraceStr = StringUtils.length((String)this.stackTraceStr) > this.ERROR_DETAILS_MAX_SIZE ? StringUtils.abbreviate((String)this.errorMsg, (int)this.ERROR_DETAILS_MAX_SIZE) : this.stackTraceStr;
                TestError testError = new TestError(this.stackTraceStr, this.errorType, this.errorMsg);
                if (this.testParserRegEx != null) {
                    this.splitTestNameByPattern();
                }
                if (this.hpRunnerType.equals((Object)HPRunnerType.UFT_MBT) && StringUtils.isNotEmpty((String)this.uftResultFilePath)) {
                    try {
                        this.uftResultData = UftTestResultsUtils.getMBTData((File)new File(this.uftResultFilePath));
                    }
                    catch (Exception e) {
                        logger.error("Failed to get MBT Data which includes steps results", (Throwable)e);
                    }
                }
                if (this.stripPackageAndClass) {
                    this.addItem(new JUnitTestResult(this.moduleName, "", "", this.testName, this.status, this.testDuration, this.buildStarted, testError, this.externalURL, this.description, this.hpRunnerType, this.externalRunId, this.uftResultData, this.octaneSupportsSteps));
                } else {
                    this.addItem(new JUnitTestResult(this.moduleName, this.packageName, this.className, this.testName, this.status, this.testDuration, this.buildStarted, testError, this.externalURL, this.description, this.hpRunnerType, this.externalRunId, this.uftResultData, this.octaneSupportsSteps));
                }
            } else if ("suites".equals(localName)) {
                this.finalizeCodelessTests();
            }
        }
    }

    private void handleCodelessTest(XMLEvent event) throws XMLStreamException, IOException, InterruptedException {
        if (event instanceof StartElement) {
            StartElement element = (StartElement)event;
            String localName = element.getName().getLocalPart();
            if ("file".equals(localName)) {
                this.filePath = this.peekNextValue();
                if (!this.checkIsCodelessTestResult(this.filePath)) {
                    this.testingToolType = TestingToolType.UFT;
                    this.handleJUnitTest(event);
                } else {
                    this.filePath = this.readNextValue();
                    this.testingToolType = TestingToolType.CODELESS;
                    String fileName = this.filePath.substring(this.filePath.lastIndexOf("\\") + 1);
                    this.testName = fileName.substring(0, fileName.lastIndexOf("-Report"));
                    this.readCodelessTestJsonResult(this.testName, this.filePath);
                    this.currentIterationSteps = new ArrayList<UftResultStepData>();
                    this.currentJUnitTestResult = this.testNameToJunitResultMap.get(this.testName);
                }
            } else if ("suite".equals(localName)) {
                this.resetTestData();
            } else if ("case".equals(localName)) {
                this.resetCaseData();
                this.insideCaseElement = true;
            } else if ("duration".equals(localName)) {
                if (this.insideCaseElement) {
                    this.stepDuration = JUnitXmlIterator.parseTime(this.readNextValue());
                } else {
                    this.testDuration = JUnitXmlIterator.parseTime(this.readNextValue());
                }
            } else if ("testName".equals(localName)) {
                this.stepName = this.readNextValue();
            } else if ("skipped".equals(localName)) {
                if ("true".equals(this.readNextValue())) {
                    this.status = TestResultStatus.SKIPPED;
                }
            } else if ("failedSince".equals(localName)) {
                if (!"0".equals(this.readNextValue()) && !TestResultStatus.SKIPPED.equals((Object)this.status)) {
                    this.status = TestResultStatus.FAILED;
                }
            } else if ("errorStackTrace".equals(localName)) {
                this.status = TestResultStatus.FAILED;
                this.stackTraceStr = "";
                if (this.peek() instanceof Characters) {
                    this.stackTraceStr = this.readNextValue();
                    int index = this.stackTraceStr.indexOf("at ");
                    if (index >= 0) {
                        this.errorType = this.stackTraceStr.substring(0, index);
                    }
                }
            } else if ("errorDetails".equals(localName)) {
                this.status = TestResultStatus.FAILED;
                this.errorMsg = this.readNextValue();
                int index = this.stackTraceStr.indexOf(58);
                if (index >= 0) {
                    this.errorType = this.stackTraceStr.substring(0, index);
                }
                if ((this.hpRunnerType.equals((Object)HPRunnerType.UFT) || this.hpRunnerType.equals((Object)HPRunnerType.UFT_MBT)) && StringUtils.isNotEmpty((String)this.errorMsg)) {
                    this.parseUftErrorMessages();
                }
            }
        } else if (event instanceof EndElement) {
            EndElement element = (EndElement)event;
            String localName = element.getName().getLocalPart();
            if ("case".equals(localName)) {
                this.errorMsg = StringUtils.length((String)this.errorMsg) > this.ERROR_MESSAGE_MAX_SIZE ? StringUtils.abbreviate((String)this.errorMsg, (int)this.ERROR_MESSAGE_MAX_SIZE) : this.errorMsg;
                UftResultStepData stepData = new UftResultStepData(Collections.singletonList(this.stepName), "", this.status.toPrettyName(), this.errorMsg, this.stepDuration);
                this.currentIterationSteps.add(stepData);
                this.insideCaseElement = false;
            } else if ("suite".equals(localName)) {
                UftResultIterationData iterationData = new UftResultIterationData(this.currentIterationSteps, this.testDuration);
                TestResultStatus iterationStatus = TestResultStatus.fromPrettyName(this.calculateIterationStatus(iterationData));
                if (this.currentJUnitTestResult == null) {
                    ArrayList<UftResultIterationData> iterations = new ArrayList<UftResultIterationData>();
                    iterations.add(iterationData);
                    TestError testError = null;
                    if (iterationStatus.equals((Object)TestResultStatus.FAILED)) {
                        testError = new TestError("", "", this.findFirstError(iterationData));
                    }
                    String actualTestName = this.testName.substring(this.testName.indexOf("_") + 1);
                    this.currentJUnitTestResult = new JUnitTestResult("", "", "", actualTestName, iterationStatus, this.testDuration, this.buildStarted, testError, "", "", this.hpRunnerType, this.externalRunId, iterations, this.octaneSupportsSteps);
                    this.testNameToJunitResultMap.put(this.testName, this.currentJUnitTestResult);
                } else {
                    this.currentJUnitTestResult.setDuration(this.currentJUnitTestResult.getDuration() + this.testDuration);
                    this.currentJUnitTestResult.getUftResultData().add(iterationData);
                    if (iterationStatus.equals((Object)TestResultStatus.FAILED) && !this.currentJUnitTestResult.getResult().equals((Object)TestResultStatus.FAILED)) {
                        this.currentJUnitTestResult.setResult(TestResultStatus.FAILED);
                        TestError testError = new TestError(this.stackTraceStr, this.errorType, this.findFirstError(iterationData));
                        this.currentJUnitTestResult.setTestError(testError);
                    }
                }
                this.testingToolType = TestingToolType.UFT;
            } else if ("suites".equals(localName)) {
                this.finalizeCodelessTests();
            }
        }
    }

    private void finalizeCodelessTests() {
        if (!this.testNameToJunitResultMap.isEmpty()) {
            this.addParametersToUnitsResponse();
            this.testNameToJunitResultMap.values().forEach(x$0 -> this.addItem(x$0));
        }
    }

    private void resetTestData() {
        this.packageName = "";
        this.className = "";
        this.testName = "";
        this.testDuration = 0L;
        this.status = TestResultStatus.PASSED;
        this.stackTraceStr = "";
        this.errorType = "";
        this.errorMsg = "";
        this.externalURL = "";
        this.description = "";
        this.uftResultFilePath = "";
        this.externalRunId = "";
        this.moduleName = this.moduleNameFromFile;
        this.uftResultData = null;
    }

    private void resetCaseData() {
        this.stepDuration = 0L;
        this.status = TestResultStatus.PASSED;
        this.stackTraceStr = "";
        this.errorType = "";
        this.errorMsg = "";
        this.insideCaseElement = false;
        this.stepName = "";
    }

    private String calculateIterationStatus(UftResultIterationData iterationData) {
        Set stepStatuses = iterationData.getSteps().stream().map(UftResultStepData::getResult).collect(Collectors.toSet());
        if (stepStatuses.contains(TestResultStatus.FAILED.toPrettyName())) {
            return TestResultStatus.FAILED.toPrettyName();
        }
        if (stepStatuses.contains(TestResultStatus.PASSED.toPrettyName())) {
            return TestResultStatus.PASSED.toPrettyName();
        }
        return TestResultStatus.SKIPPED.toPrettyName();
    }

    private String findFirstError(UftResultIterationData iterationData) {
        Optional<UftResultStepData> failedStepOptional = iterationData.getSteps().stream().filter(uftResultStepData -> uftResultStepData.getResult().equals(TestResultStatus.FAILED.toPrettyName())).findFirst();
        if (failedStepOptional.isPresent()) {
            return failedStepOptional.get().getMessage();
        }
        return "";
    }

    private boolean checkIsCodelessTestResult(String resultFilePath) {
        String codelessFolderName = String.format("codeless_%s", this.buildId);
        return resultFilePath.contains("\\" + codelessFolderName + "\\");
    }

    private void readCodelessTestJsonResult(String testName, String testFilePath) {
        if (this.testNameToCodelessResultMap.get(testName) != null) {
            return;
        }
        String jsonFileName = testFilePath.replace("xml", "json");
        FilePath jsonFilePath = this.workspace.child(jsonFileName);
        try {
            if (jsonFilePath.exists()) {
                String jsonResult = jsonFilePath.readToString();
                CodelessResult codelessResult = (CodelessResult)this.mapper.readValue(jsonResult, CodelessResult.class);
                this.testNameToCodelessResultMap.put(testName, codelessResult);
            }
        }
        catch (IOException | InterruptedException e) {
            logger.warn("Failed to read codeless json result file {}", (Object)jsonFileName, (Object)e);
        }
    }

    private void addParametersToUnitsResponse() {
        this.testNameToJunitResultMap.entrySet().forEach(entry -> {
            String testName = (String)entry.getKey();
            JUnitTestResult testResult = (JUnitTestResult)entry.getValue();
            CodelessResult codelessResult = this.testNameToCodelessResultMap.get(testName);
            if (codelessResult != null) {
                List<UftResultIterationData> resultIterations = testResult.getUftResultData();
                List<List<CodelessResultUnit>> codelessIterations = codelessResult.getIterations();
                if (resultIterations.size() == codelessIterations.size()) {
                    for (int i = 0; i < resultIterations.size(); ++i) {
                        List steps = resultIterations.get(i).getSteps();
                        List<CodelessResultUnit> currentCodelessUnits = codelessIterations.get(i);
                        if (steps.size() == currentCodelessUnits.size()) {
                            for (int k = 0; k < steps.size(); ++k) {
                                UftResultStepData currentStep = (UftResultStepData)steps.get(k);
                                CodelessResultUnit currentUnit = currentCodelessUnits.get(k);
                                this.mergeParameters(currentStep, currentUnit);
                            }
                            continue;
                        }
                        logger.warn("Codeless response for {} iteration {} is inconsistent- # of units does not match", (Object)testName, (Object)i);
                    }
                } else {
                    logger.warn("Codeless response for {} is inconsistent- # of iterations does not match", (Object)testName);
                }
            }
        });
    }

    private void mergeParameters(UftResultStepData stepData, CodelessResultUnit codelessResultUnit) {
        if (CollectionUtils.isEmpty(codelessResultUnit.getParameters())) {
            return;
        }
        codelessResultUnit.getParameters().forEach(parameter -> {
            UftResultStepParameter uftResultStepParameter = this.convertParameter((CodelessResultParameter)parameter);
            if (parameter.getType().equals("input")) {
                stepData.getInputParameters().add(uftResultStepParameter);
            } else {
                stepData.getOutputParameters().add(uftResultStepParameter);
            }
        });
    }

    private UftResultStepParameter convertParameter(CodelessResultParameter parameter) {
        return new UftResultStepParameter(parameter.getName(), parameter.getValue(), "");
    }

    private void splitTestNameByPattern() {
        Matcher matcher = this.testParserRegEx.matcher(this.testName);
        if (matcher.find()) {
            this.externalRunId = this.testName.substring(matcher.start());
            this.testName = this.testName.substring(0, matcher.start());
        }
    }

    private void parseUftErrorMessages() {
        try {
            if (StringUtils.isNotEmpty((String)this.uftResultFilePath)) {
                Object msg = UftTestResultsUtils.getAggregatedErrorMessage((List)UftTestResultsUtils.getErrorData((File)new File(this.uftResultFilePath)));
                if (((String)msg).length() >= 255) {
                    msg = ((String)msg).substring(0, 250) + " ...";
                }
                if (StringUtils.isNotEmpty((String)msg)) {
                    this.errorMsg = msg;
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to parseUftErrorMessages" + e.getMessage());
        }
    }

    private static String tryGetStormRunnerReportURLFromLog(Collection logLines) {
        String VIEW_REPORT_PREFIX = "view report at:";
        for (Object str : logLines) {
            if (!(str instanceof String) || !((String)str).toLowerCase().startsWith(VIEW_REPORT_PREFIX)) continue;
            return ((String)str).substring(VIEW_REPORT_PREFIX.length()).trim();
        }
        return "";
    }

    private static String tryGetStormRunnerReportURLFromJunitFile(String path) {
        try {
            String srUrl = null;
            File srReport = new File(path);
            if (srReport.exists()) {
                TestSuite testSuite = (TestSuite)DTOFactory.getInstance().dtoFromXmlFile(srReport, TestSuite.class);
                for (Property property : testSuite.getProperties()) {
                    if (!property.getPropertyName().equals(SRL_REPORT_URL)) continue;
                    srUrl = property.getPropertyValue();
                    break;
                }
            }
            return srUrl;
        }
        catch (Exception e) {
            logger.debug("Failed to getStormRunnerURL: " + e.getMessage());
            return "";
        }
    }

    private String extractValueFromStdout(String stdoutValue, String startString, String endString, String defaultValue) {
        int endIndex;
        String result = defaultValue;
        int startIndex = stdoutValue.indexOf(startString);
        if (startIndex > 0 && (endIndex = stdoutValue.indexOf(endString, startIndex)) > 0) {
            result = stdoutValue.substring(startIndex + startString.length(), endIndex).trim();
        }
        return result;
    }

    private int getUftTestIndexStart(FilePath workspace, String sharedCheckOutDirectory, String testName, List<Builder> builders) {
        int returnIndex = -1;
        try {
            List buildersNames;
            String pathToTest;
            if (sharedCheckOutDirectory == null) {
                sharedCheckOutDirectory = "";
            }
            if (StringUtils.isEmpty((String)sharedCheckOutDirectory)) {
                pathToTest = workspace.getRemote();
            } else {
                String string = pathToTest = Paths.get(sharedCheckOutDirectory, new String[0]).isAbsolute() ? sharedCheckOutDirectory : Paths.get(FilenameUtils.separatorsToSystem((String)workspace.getRemote()), new String[0]).resolve(FilenameUtils.separatorsToSystem((String)sharedCheckOutDirectory)).normalize().toString();
            }
            if ((FileSystem.getCurrent().equals((Object)FileSystem.LINUX) || FileSystem.getCurrent().equals((Object)FileSystem.MAC_OSX)) && builders != null && !(buildersNames = builders.stream().map(builder -> builder.getClass().getSimpleName()).collect(Collectors.toList())).isEmpty() && buildersNames.contains("RunFromFileBuilder")) {
                pathToTest = FilenameUtils.separatorsToWindows((String)pathToTest);
            }
            logger.log(Level.DEBUG, "pathToTest " + pathToTest);
            if (testName.toLowerCase().startsWith(pathToTest.toLowerCase())) {
                returnIndex = pathToTest.length() + 1;
            }
        }
        catch (Exception e) {
            logger.error(String.format("Failed to getUftTestIndexStart for testName '%s' and sharedCheckOutDirectory '%s' : %s", testName, sharedCheckOutDirectory, e.getMessage()), (Throwable)e);
        }
        return returnIndex;
    }

    private String cleanTestName(String testName) {
        if (testName.contains("\\")) {
            return testName.substring(testName.lastIndexOf(92) + 1);
        }
        if (testName.contains("/")) {
            return testName.substring(testName.lastIndexOf(47) + 1);
        }
        return testName;
    }

    private String jenkinsTestNameFormat(String testName) {
        if (StringUtils.isEmpty((String)testName)) {
            return testName;
        }
        return testName.trim().replaceAll("[-:\\ ,()/\\[\\]]", "_").replace('#', '_').replace('\\', '_').replace('.', '_');
    }

    private String jenkinsTestClassFormat(String className) {
        if (StringUtils.isEmpty((String)className)) {
            return className;
        }
        return className.trim().replaceAll("[:/<>]", "_").replace("\\", "_").replace(" ", "%20");
    }
}

