/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.tests.junit;

import com.google.inject.Inject;
import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.testresults.XmlWritableTestResult;
import com.microfocus.application.automation.tools.JenkinsUtils;
import com.microfocus.application.automation.tools.octane.actions.cucumber.CucumberTestResultsAction;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.executor.CheckOutSubDirEnvContributor;
import com.microfocus.application.automation.tools.octane.model.processors.projects.JobProcessorFactory;
import com.microfocus.application.automation.tools.octane.tests.HPRunnerType;
import com.microfocus.application.automation.tools.octane.tests.OctaneTestsExtension;
import com.microfocus.application.automation.tools.octane.tests.TestResultContainer;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import com.microfocus.application.automation.tools.octane.tests.detection.MFToolsDetectionExtension;
import com.microfocus.application.automation.tools.octane.tests.detection.ResultFields;
import com.microfocus.application.automation.tools.octane.tests.detection.ResultFieldsDetectionService;
import com.microfocus.application.automation.tools.octane.tests.impl.ObjectStreamIterator;
import com.microfocus.application.automation.tools.octane.tests.junit.JUnitXmlIterator;
import com.microfocus.application.automation.tools.octane.tests.junit.MavenBuilderModuleDetection;
import com.microfocus.application.automation.tools.octane.tests.junit.MavenSetModuleDetection;
import com.microfocus.application.automation.tools.octane.tests.junit.ModuleDetection;
import com.microfocus.application.automation.tools.settings.RunnerMiscSettingsGlobalConfiguration;
import hudson.Extension;
import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Builder;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.remoting.Role;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

@Extension
public class JUnitExtension
extends OctaneTestsExtension {
    private static Logger logger = SDKBasedLoggerProvider.getLogger(JUnitExtension.class);
    private static final String JUNIT_RESULT_XML = "junitResult.xml";
    public static final String TEMP_TEST_RESULTS_FILE_NAME_PREFIX = "GetJUnitTestResults";
    private static final String TEST_RESULT_NAME_REGEX_PATTERN_PARAMETER_NAME = "octane_test_result_name_run_regex_pattern";
    @Inject
    private ResultFieldsDetectionService resultFieldsDetectionService;

    @Override
    public boolean supports(Run<?, ?> build) {
        if (build.getAction(CucumberTestResultsAction.class) != null) {
            logger.debug("CucumberTestResultsAction found. Will not process JUnit results.");
            return false;
        }
        if (build.getAction(AbstractTestResultAction.class) != null) {
            logger.debug("AbstractTestResultAction found, JUnit results expected");
            return true;
        }
        logger.debug("AbstractTestResultAction not found, no JUnit results expected");
        return false;
    }

    @Override
    public TestResultContainer getTestResults(Run<?, ?> run, String jenkinsRootUrl) throws IOException, InterruptedException {
        logger.debug("Collecting JUnit results");
        FilePath resultFile = new FilePath(run.getRootDir()).child(JUNIT_RESULT_XML);
        boolean getResultsOnController = !RunnerMiscSettingsGlobalConfiguration.getInstance().isAgentToControllerEnabled();
        FilePath workspace = BuildHandlerUtils.getWorkspace(run);
        if (resultFile.exists()) {
            logger.debug("JUnit result report found");
            if (workspace == null) {
                logger.error("Received null workspace : " + String.valueOf(run));
                return null;
            }
            HPRunnerType hpRunnerType = MFToolsDetectionExtension.getRunnerType(run);
            if (hpRunnerType.equals((Object)HPRunnerType.UFT) || hpRunnerType.equals((Object)HPRunnerType.UFT_MBT)) {
                getResultsOnController = true;
            }
            FilePath filePath = this.getTestResultsFromWorkspace(run, jenkinsRootUrl, getResultsOnController, workspace, Collections.singletonList(resultFile), hpRunnerType);
            ResultFields detectedFields = this.getResultFields(run);
            return new TestResultContainer(new ObjectStreamIterator<XmlWritableTestResult>(filePath), detectedFields);
        }
        if ("hudson.maven.MavenModuleSetBuild".equals(run.getClass().getName())) {
            logger.debug("MavenModuleSetBuild detected, looking for results in maven modules");
            LinkedList<FilePath> resultFiles = new LinkedList<FilePath>();
            Map moduleLastBuilds = ((MavenModuleSetBuild)run).getModuleLastBuilds();
            for (MavenBuild mavenBuild : moduleLastBuilds.values()) {
                FilePath moduleResultFile;
                AbstractTestResultAction action = (AbstractTestResultAction)mavenBuild.getAction(AbstractTestResultAction.class);
                if (action == null || !(moduleResultFile = new FilePath(mavenBuild.getRootDir()).child(JUNIT_RESULT_XML)).exists()) continue;
                logger.debug("Found results in " + mavenBuild.getFullDisplayName());
                resultFiles.add(moduleResultFile);
            }
            if (!resultFiles.isEmpty()) {
                ResultFields detectedFields = this.getResultFields(run);
                FilePath filePath = this.getTestResultsFromWorkspace(run, jenkinsRootUrl, getResultsOnController, workspace, resultFiles, HPRunnerType.NONE);
                return new TestResultContainer(new ObjectStreamIterator<XmlWritableTestResult>(filePath), detectedFields);
            }
        }
        logger.debug("No JUnit result report found");
        return null;
    }

    private FilePath getTestResultsFromWorkspace(Run<?, ?> run, String jenkinsRootUrl, boolean getResultsOnController, FilePath workspace, List<FilePath> resultFiles, HPRunnerType runnerType) throws IOException, InterruptedException {
        FilePath filePath;
        try {
            if (getResultsOnController) {
                logger.info("Get results from controller");
                filePath = new GetJUnitTestResults(run, runnerType, resultFiles, false, jenkinsRootUrl).invoke(null, null);
            } else {
                logger.info("Get results from agent");
                filePath = (FilePath)workspace.act((FilePath.FileCallable)new GetJUnitTestResults(run, runnerType, resultFiles, false, jenkinsRootUrl));
            }
        }
        catch (Exception e) {
            logger.error(String.format("Failed to get test results from %s, trying to get test results from %s : %s", getResultsOnController ? "controller" : "agent", getResultsOnController ? "agent" : "controller", e.getMessage()), (Throwable)e);
            if (getResultsOnController) {
                logger.info("Get results from agent");
                filePath = (FilePath)workspace.act((FilePath.FileCallable)new GetJUnitTestResults(run, runnerType, resultFiles, false, jenkinsRootUrl));
            }
            logger.info("Get results from controller");
            filePath = new GetJUnitTestResults(run, runnerType, resultFiles, false, jenkinsRootUrl).invoke(null, null);
        }
        return filePath;
    }

    private ResultFields getResultFields(Run<?, ?> build) throws InterruptedException {
        return this.resultFieldsDetectionService.getDetectedFields(build);
    }

    public void _setResultFieldsDetectionService(ResultFieldsDetectionService detectionService) {
        this.resultFieldsDetectionService = detectionService;
    }

    private static class GetJUnitTestResults
    implements FilePath.FileCallable<FilePath> {
        private final List<FilePath> reports;
        private final String jobName;
        private final String buildId;
        private final String jenkinsRootUrl;
        private final HPRunnerType hpRunnerType;
        private FilePath filePath;
        private List<ModuleDetection> moduleDetection;
        private long buildStarted;
        private FilePath workspace;
        private Set<FilePath> allWorkspaces;
        private boolean stripPackageAndClass;
        private String sharedCheckOutDirectory;
        private Pattern testParserRegEx;
        private boolean octaneSupportsSteps;
        private List<Builder> builders;
        private Object additionalContext;
        private final Set<String> nodeNames = new HashSet<String>();

        public GetJUnitTestResults(Run<?, ?> build, HPRunnerType hpRunnerType, List<FilePath> reports, boolean stripPackageAndClass, String jenkinsRootUrl) throws IOException, InterruptedException {
            ParameterValue pv;
            ParametersAction parameterAction;
            this.reports = reports;
            this.filePath = new FilePath(build.getRootDir()).createTempFile(JUnitExtension.TEMP_TEST_RESULTS_FILE_NAME_PREFIX, null);
            this.buildStarted = build.getStartTimeInMillis();
            this.workspace = BuildHandlerUtils.getWorkspace(build);
            this.allWorkspaces = BuildHandlerUtils.getWorkspaces(build);
            this.stripPackageAndClass = stripPackageAndClass;
            this.hpRunnerType = hpRunnerType;
            this.jenkinsRootUrl = jenkinsRootUrl;
            String buildRootDir = build.getRootDir().getCanonicalPath();
            this.sharedCheckOutDirectory = CheckOutSubDirEnvContributor.getSharedCheckOutDirectory(build.getParent());
            if (this.sharedCheckOutDirectory == null && (HPRunnerType.UFT.equals((Object)hpRunnerType) || HPRunnerType.UFT_MBT.equals((Object)hpRunnerType))) {
                parameterAction = (ParametersAction)build.getAction(ParametersAction.class);
                pv = parameterAction != null ? parameterAction.getParameter("UFT_CHECKOUT_FOLDER") : null;
                this.sharedCheckOutDirectory = pv != null && pv instanceof StringParameterValue ? StringUtils.strip((String)((String)pv.getValue()), (String)"\\/") : "";
            }
            this.jobName = JobProcessorFactory.getFlowProcessor(build.getParent()).getTranslatedJobName();
            this.buildId = build.getId();
            this.moduleDetection = Arrays.asList(new MavenBuilderModuleDetection(build), new MavenSetModuleDetection(build), new ModuleDetection.Default());
            this.builders = JobProcessorFactory.getFlowProcessor(build.getParent()).tryGetBuilders();
            if (HPRunnerType.UFT.equals((Object)hpRunnerType) || HPRunnerType.UFT_MBT.equals((Object)hpRunnerType)) {
                List<Node> nodes = this.allWorkspaces.stream().map(JenkinsUtils::getCurrentNode).collect(Collectors.toList());
                nodes.forEach(node -> this.nodeNames.add(node != null && !node.getNodeName().isEmpty() ? node.getNodeName() : ""));
                ArrayList reportFolders = new ArrayList();
                this.nodeNames.forEach(nodeName -> reportFolders.add(buildRootDir + "/archive/UFTReport" + (String)(StringUtils.isNotEmpty((String)nodeName) ? "/" + nodeName : "")));
                ArrayList<String> testFolderNames = new ArrayList<String>();
                testFolderNames.add(build.getRootDir().getAbsolutePath());
                reportFolders.forEach(reportFolder -> {
                    File[] children;
                    File reportFolderFile = new File((String)reportFolder);
                    if (reportFolderFile.exists() && (children = reportFolderFile.listFiles()) != null) {
                        for (File child : children) {
                            testFolderNames.add(child.getParentFile().getName() + "/" + child.getName());
                        }
                    }
                });
                this.additionalContext = testFolderNames;
            }
            if (HPRunnerType.StormRunnerLoad.equals((Object)hpRunnerType)) {
                try {
                    File file = new File(build.getRootDir(), "log");
                    Path path = Paths.get(file.getPath(), new String[0]);
                    this.additionalContext = Files.readAllLines(path, StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    logger.error("Failed to add log file for StormRunnerLoad :" + e.getMessage());
                }
            }
            if (build.getAction(ParametersAction.class) != null && ((ParametersAction)build.getAction(ParametersAction.class)).getParameter(JUnitExtension.TEST_RESULT_NAME_REGEX_PATTERN_PARAMETER_NAME) != null && ((ParametersAction)build.getAction(ParametersAction.class)).getParameter(JUnitExtension.TEST_RESULT_NAME_REGEX_PATTERN_PARAMETER_NAME).getValue() != null) {
                try {
                    this.testParserRegEx = Pattern.compile(Objects.requireNonNull(((ParametersAction)build.getAction(ParametersAction.class)).getParameter(JUnitExtension.TEST_RESULT_NAME_REGEX_PATTERN_PARAMETER_NAME).getValue()).toString());
                }
                catch (IllegalArgumentException e) {
                    logger.error("Failed to parse regular expression pattern for test result name extractor.Job name: {}, Build {}, Input: {}, Error massage: {}.", (Object)this.jobName, (Object)this.buildId, (Object)(Objects.requireNonNull(((ParametersAction)build.getAction(ParametersAction.class)).getParameter(JUnitExtension.TEST_RESULT_NAME_REGEX_PATTERN_PARAMETER_NAME).getValue()).toString() + "\n"), (Object)e.getMessage());
                }
            }
            if (hpRunnerType.equals((Object)HPRunnerType.UFT_MBT)) {
                try {
                    parameterAction = (ParametersAction)build.getAction(ParametersAction.class);
                    pv = parameterAction != null ? parameterAction.getParameter("octaneConfigId") : null;
                    String instanceId = pv instanceof StringParameterValue ? StringUtils.strip((String)((String)pv.getValue()), (String)"\\/") : "";
                    OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
                    this.octaneSupportsSteps = octaneClient.getConfigurationService().isOctaneVersionGreaterOrEqual("16.0.217");
                }
                catch (Exception e) {
                    logger.error("Failed to check octane version to know whether octaneSupportsSteps", (Throwable)e);
                }
            }
        }

        public FilePath invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            OutputStream os = this.filePath.write();
            BufferedOutputStream bos = new BufferedOutputStream(os);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            try {
                for (FilePath report : this.reports) {
                    JUnitXmlIterator iterator = new JUnitXmlIterator(report.read(), this.moduleDetection, this.workspace, this.sharedCheckOutDirectory, this.jobName, this.buildId, this.buildStarted, this.stripPackageAndClass, this.hpRunnerType, this.jenkinsRootUrl, this.additionalContext, this.testParserRegEx, this.octaneSupportsSteps, this.nodeNames, this.builders);
                    while (iterator.hasNext()) {
                        oos.writeObject(iterator.next());
                    }
                }
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
            os.flush();
            oos.close();
            return this.filePath;
        }

        public void checkRoles(RoleChecker roleChecker) throws SecurityException {
            roleChecker.check((RoleSensitive)this, Role.UNKNOWN);
        }
    }
}

