/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.tests.impl;

import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import hudson.FilePath;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.Logger;

public class ObjectStreamIterator<E>
implements Iterator<E> {
    private static Logger logger = SDKBasedLoggerProvider.getLogger(ObjectStreamIterator.class);
    private ObjectInputStream ois;
    private E next;

    public ObjectStreamIterator(FilePath filePath) throws IOException, InterruptedException {
        this.ois = new ObjectInputStream(new BufferedInputStream(filePath.read()));
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        try {
            this.next = this.ois.readObject();
            return true;
        }
        catch (Throwable e) {
            try {
                this.ois.close();
            }
            catch (IOException ioe) {
                logger.error("Failed to close the stream", (Throwable)ioe);
            }
            return false;
        }
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            E value = this.next;
            this.next = null;
            return value;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

