/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.tests.build;

import com.hp.octane.integrations.dto.snapshots.CIBuildResult;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.model.CIEventCausesFactory;
import com.microfocus.application.automation.tools.octane.model.processors.projects.JobProcessorFactory;
import com.microfocus.application.automation.tools.octane.tests.build.BuildDescriptor;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerExtension;
import hudson.FilePath;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.actions.WorkspaceAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class BuildHandlerUtils {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(BuildHandlerUtils.class);
    public static final String JOB_LEVEL_SEPARATOR = "/job/";

    public static BuildDescriptor getBuildType(Run<?, ?> run) {
        for (BuildHandlerExtension ext : BuildHandlerExtension.all()) {
            if (!ext.supports(run)) continue;
            return ext.getBuildType(run);
        }
        return new BuildDescriptor(BuildHandlerUtils.getJobCiId(run), run.getParent().getName(), BuildHandlerUtils.getBuildCiId(run), String.valueOf(run.getNumber()), "");
    }

    @Deprecated
    public static String getProjectFullName(Run<?, ?> run) {
        for (BuildHandlerExtension ext : BuildHandlerExtension.all()) {
            if (!ext.supports(run)) continue;
            return ext.getProjectFullName(run);
        }
        return run.getParent().getFullName();
    }

    public static FilePath getWorkspace(Run<?, ?> run) {
        FlowExecution fe;
        if (run.getExecutor() != null && run.getExecutor().getCurrentWorkspace() != null) {
            return run.getExecutor().getCurrentWorkspace();
        }
        if (run instanceof AbstractBuild) {
            return ((AbstractBuild)run).getWorkspace();
        }
        if (run instanceof WorkflowRun && (fe = ((WorkflowRun)run).getExecution()) != null) {
            FlowGraphWalker w = new FlowGraphWalker(fe);
            for (FlowNode n : w) {
                WorkspaceAction action = (WorkspaceAction)n.getAction(WorkspaceAction.class);
                if (action == null) continue;
                FilePath workspace = action.getWorkspace();
                if (workspace == null) {
                    workspace = BuildHandlerUtils.handleWorkspaceActionWithoutWorkspace(action);
                }
                return workspace;
            }
        }
        logger.error("BuildHandlerUtils.getWorkspace - run is not handled. Run type : " + String.valueOf(run.getClass()));
        return null;
    }

    public static Set<FilePath> getWorkspaces(Run<?, ?> run) {
        FlowExecution fe;
        if (run.getExecutor() != null && run.getExecutor().getCurrentWorkspace() != null) {
            return Collections.singleton(run.getExecutor().getCurrentWorkspace());
        }
        if (run instanceof AbstractBuild) {
            return Collections.singleton(((AbstractBuild)run).getWorkspace());
        }
        HashSet<FilePath> workspaces = new HashSet<FilePath>();
        if (run instanceof WorkflowRun && (fe = ((WorkflowRun)run).getExecution()) != null) {
            FlowGraphWalker w = new FlowGraphWalker(fe);
            for (FlowNode n : w) {
                WorkspaceAction action = (WorkspaceAction)n.getAction(WorkspaceAction.class);
                if (action == null) continue;
                FilePath workspace = action.getWorkspace();
                if (workspace == null) {
                    workspace = BuildHandlerUtils.handleWorkspaceActionWithoutWorkspace(action);
                }
                workspaces.add(workspace);
            }
        }
        if (workspaces.isEmpty()) {
            logger.error("BuildHandlerUtils.getWorkspaces - run is not handled. Run type : " + String.valueOf(run.getClass()));
        }
        return workspaces;
    }

    private static FilePath handleWorkspaceActionWithoutWorkspace(WorkspaceAction action) {
        logger.error("Found WorkspaceAction without workspace");
        logger.warn("Node getPath = " + action.getPath());
        logger.warn("Node getNode = " + action.getNode());
        FilePath workspace = null;
        if (StringUtils.isNotEmpty((String)action.getPath())) {
            logger.warn("Node getPath is not empty, return getPath as workspace");
            workspace = new FilePath(new File(action.getPath()));
        } else {
            logger.warn("Node getPath is empty, return workspace = null");
        }
        return workspace;
    }

    public static String getBuildCiId(Run run) {
        return String.valueOf(run.getNumber());
    }

    public static String getJobCiId(Run run) {
        if (run.getParent() instanceof MatrixConfiguration) {
            return JobProcessorFactory.getFlowProcessor((MatrixConfiguration)((MatrixRun)run).getProject()).getTranslatedJobName();
        }
        if (run.getParent().getClass().getName().equals("org.jenkinsci.plugins.workflow.job.WorkflowJob")) {
            return JobProcessorFactory.getFlowProcessor(run.getParent()).getTranslatedJobName();
        }
        return JobProcessorFactory.getFlowProcessor(((AbstractBuild)run).getProject()).getTranslatedJobName();
    }

    public static String translateFolderJobName(String jobPlainName) {
        return jobPlainName.replaceAll("/", JOB_LEVEL_SEPARATOR);
    }

    public static String revertTranslateFolderJobName(String translatedJobName) {
        return translatedJobName.replaceAll(JOB_LEVEL_SEPARATOR, "/");
    }

    public static String translateFullDisplayName(String fullDisplayName) {
        return fullDisplayName.replaceAll(" \u00bb ", "/");
    }

    public static CIBuildResult translateRunResult(Run run) {
        FlowExecution execution;
        Result runResult = run.getResult();
        if (runResult == null && run instanceof WorkflowRun && (execution = ((WorkflowRun)run).getExecution()) instanceof CpsFlowExecution) {
            runResult = ((CpsFlowExecution)execution).getResult();
        }
        CIBuildResult result = runResult == Result.SUCCESS ? CIBuildResult.SUCCESS : (runResult == Result.ABORTED ? CIBuildResult.ABORTED : (runResult == Result.FAILURE ? CIBuildResult.FAILURE : (runResult == Result.UNSTABLE ? CIBuildResult.UNSTABLE : CIBuildResult.UNAVAILABLE)));
        return result;
    }

    public static boolean isWorkflowStartNode(FlowNode node) {
        return node.getParents().isEmpty() || node.getParents().stream().anyMatch(fn -> fn instanceof FlowStartNode);
    }

    public static boolean isWorkflowEndNode(FlowNode node) {
        return node instanceof FlowEndNode;
    }

    public static boolean isStageStartNode(FlowNode node) {
        return node instanceof StepStartNode && node.getAction(LabelAction.class) != null && node.getAction(ThreadNameAction.class) == null;
    }

    public static boolean isStageEndNode(FlowNode node) {
        return node instanceof StepEndNode && BuildHandlerUtils.isStageStartNode((FlowNode)((StepEndNode)node).getStartNode());
    }

    public static WorkflowRun extractParentRun(FlowNode flowNode) {
        try {
            return (WorkflowRun)flowNode.getExecution().getOwner().getExecutable();
        }
        catch (IOException ioe) {
            logger.error("failed to extract parent workflow run from " + String.valueOf(flowNode), (Throwable)ioe);
            throw new IllegalStateException("failed to extract parent workflow run from " + String.valueOf(flowNode));
        }
    }

    public static String getRootJobCiIds(Run<?, ?> run) {
        HashSet parents = new HashSet();
        CIPluginSDKUtils.getRootJobCiIds((String)BuildHandlerUtils.getJobCiId(run), CIEventCausesFactory.processCauses(run), parents);
        return String.join((CharSequence)";", parents);
    }
}

