/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.tests;

import com.hp.octane.integrations.OctaneSDK;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.tests.OctaneTestsExtension;
import com.microfocus.application.automation.tools.octane.tests.TestResultContainer;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import com.microfocus.application.automation.tools.octane.tests.xml.TestResultXmlWriter;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import javax.xml.stream.XMLStreamException;
import jenkins.model.Jenkins;
import org.apache.logging.log4j.Logger;

@Extension
public class TestListener {
    private static Logger logger = SDKBasedLoggerProvider.getLogger(TestListener.class);
    public static final String TEST_RESULT_FILE = "mqmTests.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processBuild(Run run) {
        FilePath resultPath = new FilePath(new FilePath(run.getRootDir()), TEST_RESULT_FILE);
        TestResultXmlWriter resultWriter = new TestResultXmlWriter(resultPath, run);
        boolean success = true;
        boolean hasTests = false;
        String jenkinsRootUrl = Jenkins.get().getRootUrl();
        try {
            for (OctaneTestsExtension ext : OctaneTestsExtension.all()) {
                TestResultContainer testResultContainer;
                if (!ext.supports(run) || (testResultContainer = ext.getTestResults(run, jenkinsRootUrl)) == null || !testResultContainer.getIterator().hasNext()) continue;
                resultWriter.writeResults(testResultContainer);
                hasTests = true;
            }
        }
        catch (Throwable t) {
            success = false;
            logger.error("failed to process test results", t);
        }
        finally {
            try {
                resultWriter.close();
                if (!"hudson.maven.MavenBuild".equals(run.getClass().getName()) && success && hasTests) {
                    String projectFullName = BuildHandlerUtils.getJobCiId(run);
                    String parents = BuildHandlerUtils.getRootJobCiIds(run);
                    logger.info("enqueued build '" + projectFullName + " #" + run.getNumber() + "' for test result submission");
                    if (projectFullName != null) {
                        OctaneSDK.getClients().forEach(octaneClient -> octaneClient.getTestsService().enqueuePushTestsResult(projectFullName, String.valueOf(run.getNumber()), parents));
                    }
                }
            }
            catch (XMLStreamException xmlse) {
                success = false;
                logger.error("failed to finalize test results processing", (Throwable)xmlse);
            }
        }
        return success && hasTests;
    }
}

