/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.tests;

import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class AbstractSafeLoggingAsyncPeriodWork
extends AsyncPeriodicWork {
    private static Logger logger = Logger.getLogger(AbstractSafeLoggingAsyncPeriodWork.class.getName());

    protected AbstractSafeLoggingAsyncPeriodWork(String name) {
        super(name);
    }

    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        try {
            this.doExecute(listener);
        }
        catch (IOException | InterruptedException e) {
            this.logError(e);
        }
        catch (Throwable t) {
            this.logError(t);
        }
    }

    protected abstract void doExecute(TaskListener var1) throws IOException, InterruptedException;

    private void logError(Throwable t) {
        LogRecord lr = new LogRecord(this.getErrorLoggingLevel(), "{0} thread failed with error");
        lr.setThrown(t);
        lr.setParameters(new Object[]{this.name});
        logger.log(lr);
    }

    protected Level getNormalLoggingLevel() {
        return Level.CONFIG;
    }
}

