/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.pullrequests;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.exceptions.OctaneValidationException;
import com.hp.octane.integrations.exceptions.ResourceNotFoundException;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.FetchFactory;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.FetchHandler;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.PullRequestFetchParameters;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.ScmTool;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.authentication.AuthenticationStrategy;
import com.microfocus.application.automation.tools.octane.GitFetchUtils;
import com.microfocus.application.automation.tools.octane.JellyUtils;
import com.microfocus.application.automation.tools.octane.pullrequests.PullRequestBuildAction;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class PullRequestPublisher
extends Recorder
implements SimpleBuildStep {
    private String configurationId;
    private String workspaceId;
    private String repositoryUrl;
    private String credentialsId;
    private String sourceBranchFilter;
    private String targetBranchFilter;
    private String scmTool;
    private String useSSHFormat;

    @DataBoundConstructor
    public PullRequestPublisher(String configurationId, String workspaceId, String scmTool, String repositoryUrl, String credentialsId, String sourceBranchFilter, String targetBranchFilter) {
        this.configurationId = "none".equalsIgnoreCase(configurationId) ? null : configurationId;
        this.workspaceId = "none".equalsIgnoreCase(workspaceId) ? null : workspaceId;
        this.repositoryUrl = repositoryUrl;
        this.credentialsId = credentialsId;
        this.sourceBranchFilter = sourceBranchFilter;
        this.targetBranchFilter = targetBranchFilter;
        this.scmTool = "none".equalsIgnoreCase(scmTool) ? null : scmTool;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        this.performInternal(run, taskListener);
    }

    public boolean perform(AbstractBuild build, @Nonnull Launcher launcher, BuildListener listener) {
        this.performInternal((Run<?, ?>)build, (TaskListener)listener);
        return build.getResult() == Result.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInternal(@Nonnull Run<?, ?> run, @Nonnull TaskListener taskListener) {
        LogConsumer logConsumer = new LogConsumer(taskListener.getLogger());
        logConsumer.printLog("PullRequestPublisher is started ***********************************************************************");
        if (this.configurationId == null) {
            throw new IllegalArgumentException("Software Delivery Management configuration is not defined.");
        }
        if (this.workspaceId == null) {
            throw new IllegalArgumentException("Software Delivery Management workspace is not defined.");
        }
        if (this.scmTool == null) {
            throw new IllegalArgumentException("SCM Tool is not defined.");
        }
        String myCredentialsId = this.credentialsId;
        String myConfigurationId = this.configurationId;
        String myWorkspaceId = this.workspaceId;
        String myScmTool = this.scmTool;
        String myUseSshFormat = this.useSSHFormat;
        try {
            EnvVars env = run.getEnvironment(taskListener);
            myCredentialsId = env.expand(this.credentialsId);
            myConfigurationId = env.expand(this.configurationId);
            myWorkspaceId = env.expand(this.workspaceId);
            myScmTool = env.expand(this.scmTool);
            myUseSshFormat = env.expand(this.useSSHFormat);
        }
        catch (IOException | InterruptedException e) {
            taskListener.error("Failed loading build environment " + String.valueOf(e));
        }
        PullRequestFetchParameters fp = this.createFetchParameters(run, taskListener, myConfigurationId, myWorkspaceId, myUseSshFormat, logConsumer::printLog);
        StandardCredentials credentials = GitFetchUtils.getCredentialsById(myCredentialsId, run, taskListener.getLogger());
        AuthenticationStrategy authenticationStrategy = GitFetchUtils.getAuthenticationStrategy(credentials);
        String secret = GitFetchUtils.getCredentialsPassword(credentials);
        FetchHandler fetchHandler = FetchFactory.getHandler((ScmTool)ScmTool.fromValue((String)myScmTool), (AuthenticationStrategy)authenticationStrategy, (String)secret);
        try {
            OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)myConfigurationId);
            logConsumer.printLog("Software Delivery Management " + octaneClient.getConfigurationService().getConfiguration().getLocationForLog() + ", workspace - " + myWorkspaceId);
            octaneClient.validateOctaneIsActiveAndSupportVersion("15.0.40");
            List pullRequests = fetchHandler.fetchPullRequests(fp, GitFetchUtils::getUserIdForCommit, logConsumer::printLog);
            Class<PullRequestBuildAction> clazz = PullRequestBuildAction.class;
            synchronized (PullRequestBuildAction.class) {
                long index = run.getActions(PullRequestBuildAction.class).size();
                PullRequestBuildAction buildAction = new PullRequestBuildAction(run, pullRequests, fp.getRepoUrl(), fp.getMinUpdateTime(), fp.getSourceBranchFilter(), fp.getTargetBranchFilter(), index);
                run.addAction((Action)buildAction);
                // ** MonitorExit[var16_20] (shouldn't be in output)
                if (!pullRequests.isEmpty()) {
                    octaneClient.getPullRequestAndBranchService().sendPullRequests(pullRequests, myWorkspaceId, fp, logConsumer::printLog);
                }
                String repoUrlForOctane = fp.isUseSSHFormat() ? fp.getRepoUrlSsh() : fp.getRepoUrl();
                GitFetchUtils.updateRepoTemplates(octaneClient.getPullRequestAndBranchService(), fetchHandler, fp.getRepoUrl(), repoUrlForOctane, Long.parseLong(myWorkspaceId), logConsumer::printLog);
            }
        }
        catch (OctaneValidationException e) {
            logConsumer.printLog("Software Delivery Management pull request collector failed on validation : " + e.getMessage());
            run.setResult(Result.FAILURE);
        }
        catch (ResourceNotFoundException e) {
            logConsumer.printLog(e.getMessage());
            run.setResult(Result.FAILURE);
        }
        catch (Exception e) {
            logConsumer.printLog("Software Delivery Management pull request collector failed : " + e.getMessage());
            e.printStackTrace(taskListener.getLogger());
            run.setResult(Result.FAILURE);
        }
    }

    private PullRequestFetchParameters createFetchParameters(@Nonnull Run<?, ?> run, @Nonnull TaskListener taskListener, String myConfigurationId, String myWorkspaceId, String myUseSshFormat, Consumer<String> logConsumer) {
        PullRequestFetchParameters fp;
        try {
            EnvVars env = run.getEnvironment(taskListener);
            fp = new PullRequestFetchParameters().setRepoUrl(env.expand(this.repositoryUrl)).setSourceBranchFilter(env.expand(this.sourceBranchFilter)).setTargetBranchFilter(env.expand(this.targetBranchFilter)).setUseSSHFormat(Boolean.parseBoolean(env.expand(myUseSshFormat)));
        }
        catch (IOException | InterruptedException e) {
            taskListener.error("Failed loading build environment " + String.valueOf(e));
            fp = new PullRequestFetchParameters().setRepoUrl(this.repositoryUrl).setSourceBranchFilter(this.sourceBranchFilter).setTargetBranchFilter(this.targetBranchFilter).setUseSSHFormat(Boolean.parseBoolean(myUseSshFormat));
        }
        ParametersAction parameterAction = (ParametersAction)run.getAction(ParametersAction.class);
        if (parameterAction != null) {
            fp.setPageSize(this.getIntegerValueParameter(parameterAction, "pullrequests_page_size"));
            fp.setMaxPRsToFetch(this.getIntegerValueParameter(parameterAction, "pullrequests_max_pr_to_collect"));
            fp.setMaxCommitsToFetch(this.getIntegerValueParameter(parameterAction, "pullrequests_max_commits_to_collect"));
            fp.setMinUpdateTime(this.getLongValueParameter(parameterAction, "pullrequests_min_update_time"));
            fp.setSearchBranchOctaneRootRepositoryId(this.getIntegerValueParameter(parameterAction, "search_branch_octane_root_repository_id"));
        }
        if (fp.getMinUpdateTime() == 999L) {
            long lastUpdateTime = OctaneSDK.getClientByInstanceId((String)myConfigurationId).getPullRequestAndBranchService().getPullRequestLastUpdateTime(myWorkspaceId, fp.getRepoUrl());
            fp.setMinUpdateTime(Long.valueOf(lastUpdateTime));
        }
        logConsumer.accept("Repository URL        : " + fp.getRepoUrl());
        logConsumer.accept("Min update date       : " + fp.getMinUpdateTime());
        logConsumer.accept("Source branch filter  : " + fp.getSourceBranchFilter());
        logConsumer.accept("Target branch filter  : " + fp.getTargetBranchFilter());
        logConsumer.accept("Max PRs to collect    : " + fp.getMaxPRsToFetch());
        logConsumer.accept("Max commits to collect: " + fp.getMaxCommitsToFetch());
        logConsumer.accept("Use ssh format        : " + fp.isUseSSHFormat());
        return fp;
    }

    private Integer getIntegerValueParameter(ParametersAction parameterAction, String paramValue) {
        ParameterValue pv = parameterAction.getParameter(paramValue);
        if (pv != null && pv.getValue() instanceof String) {
            try {
                return Integer.valueOf((String)pv.getValue());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private Long getLongValueParameter(ParametersAction parameterAction, String paramValue) {
        ParameterValue pv = parameterAction.getParameter(paramValue);
        if (pv != null && pv.getValue() instanceof String) {
            try {
                return Long.valueOf((String)pv.getValue());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @DataBoundSetter
    public void setUseSSHFormat(boolean useSSHFormat) {
        this.useSSHFormat = Boolean.toString(useSSHFormat);
    }

    public boolean getUseSSHFormat() {
        return Boolean.parseBoolean(this.useSSHFormat);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getSourceBranchFilter() {
        return this.sourceBranchFilter;
    }

    public String getTargetBranchFilter() {
        return this.targetBranchFilter;
    }

    public String getScmTool() {
        return this.scmTool;
    }

    private static class LogConsumer {
        private final PrintStream ps;

        public LogConsumer(PrintStream ps) {
            this.ps = ps;
        }

        public void printLog(String msg) {
            this.ps.println("PullRequestPublisher : " + msg);
        }
    }

    @Symbol(value={"collectPullRequestsToAlmOctane"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        static final CredentialsMatcher CREDENTIALS_MATCHER = CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class)});

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String credentialsId) {
            return JellyUtils.fillCredentialsIdItems(project, credentialsId, CREDENTIALS_MATCHER);
        }

        public ListBoxModel doFillScmToolItems() {
            ListBoxModel m = JellyUtils.createComboModelWithNoneValue();
            for (ScmTool tool : ScmTool.values()) {
                m.add(tool.getDesc(), tool.getValue());
            }
            return m;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public ListBoxModel doFillConfigurationIdItems() {
            return JellyUtils.fillConfigurationIdModel();
        }

        public ListBoxModel doFillWorkspaceIdItems(@QueryParameter String configurationId, @QueryParameter(value="workspaceId") String workspaceId) {
            return JellyUtils.fillWorkspaceModel(configurationId, workspaceId);
        }

        public String getDisplayName() {
            return "Software Delivery Management pull-request collector";
        }
    }
}

