/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model.processors.scm;

import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.scm.SCMChange;
import com.hp.octane.integrations.dto.scm.SCMCommit;
import com.hp.octane.integrations.dto.scm.SCMData;
import com.hp.octane.integrations.dto.scm.SCMRepository;
import com.hp.octane.integrations.dto.scm.SCMType;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.model.processors.scm.CommonOriginRevision;
import com.microfocus.application.automation.tools.octane.model.processors.scm.SCMProcessor;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import hudson.scm.SCM;
import hudson.tasks.Mailer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

class StarTeamSCMProcessor
implements SCMProcessor {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(StarTeamSCMProcessor.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();

    StarTeamSCMProcessor() {
    }

    @Override
    public SCMData getSCMData(AbstractBuild build, SCM scm) {
        ArrayList<ChangeLogSet<? extends ChangeLogSet.Entry>> changes = new ArrayList<ChangeLogSet<? extends ChangeLogSet.Entry>>();
        changes.add(build.getChangeSet());
        return this.extractSCMData((Run)build, scm, changes);
    }

    @Override
    public SCMData getSCMData(WorkflowRun run, SCM scm) {
        return this.extractSCMData((Run)run, scm, run.getChangeSets());
    }

    @Override
    public CommonOriginRevision getCommonOriginRevision(Run run) {
        return null;
    }

    private SCMData extractSCMData(Run run, SCM scm, List<ChangeLogSet<? extends ChangeLogSet.Entry>> changes) {
        if (!scm.getClass().getName().equals("hudson.plugins.starteam.StarTeamSCM")) {
            throw new IllegalArgumentException("SCM type of StarTeamSCM was expected here, found '" + scm.getClass().getName() + "'");
        }
        SCMRepository repository = this.getRepository(scm);
        List<SCMCommit> commits = this.extractCommits(changes);
        return ((SCMData)dtoFactory.newDTO(SCMData.class)).setRepository(repository).setCommits(commits);
    }

    private SCMRepository getRepository(SCM starTeamSCM) {
        SCMRepository result = null;
        if (starTeamSCM != null) {
            try {
                String url = this.getSCMRepositoryURL(starTeamSCM);
                String branch = this.getSCMRepositoryBranch(starTeamSCM);
                result = ((SCMRepository)dtoFactory.newDTO(SCMRepository.class)).setType(SCMType.STARTEAM).setUrl(url).setBranch(branch);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.warn(e.getClass().getSimpleName() + " unable to extract data from starTeamSCM, no SCM repository info will be available.", (Throwable)e);
            }
        } else {
            logger.warn("starTeamSCM is null, no SCM repository info will be available.");
        }
        return result;
    }

    private List<SCMCommit> extractCommits(List<ChangeLogSet<? extends ChangeLogSet.Entry>> changes) {
        LinkedList<SCMCommit> tmpCommits = new LinkedList<SCMCommit>();
        for (ChangeLogSet<? extends ChangeLogSet.Entry> set : changes) {
            for (ChangeLogSet.Entry change : set) {
                if (!change.getClass().getName().equals("hudson.plugins.starteam.changelog.StarTeamChangeLogEntry")) continue;
                ArrayList<SCMChange> tmpChanges = new ArrayList<SCMChange>();
                User user = change.getAuthor();
                String userEmail = null;
                try {
                    SCMChange tmpChange = ((SCMChange)dtoFactory.newDTO(SCMChange.class)).setType(this.getCommitType(change)).setFile(this.getFileName(change));
                    tmpChanges.add(tmpChange);
                    for (UserProperty property : user.getAllProperties()) {
                        if (!(property instanceof Mailer.UserProperty)) continue;
                        userEmail = ((Mailer.UserProperty)property).getAddress();
                    }
                    SCMCommit tmpCommit = ((SCMCommit)dtoFactory.newDTO(SCMCommit.class)).setTime(Long.valueOf(this.getDate(change).getTime())).setUserEmail(userEmail).setUser(change.getAuthor().getId()).setRevId(this.getRevision(change)).setComment(this.getComment(change)).setChanges(tmpChanges);
                    tmpCommits.add(tmpCommit);
                }
                catch (Exception e) {
                    logger.warn("failed to obtain commit information", (Throwable)e);
                }
            }
        }
        return tmpCommits;
    }

    private Object callMethodViaReflection(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> cls = object.getClass();
        Method methodTocall = cls.getDeclaredMethod(methodName, new Class[0]);
        Object returnValue = methodTocall.invoke(object, new Object[0]);
        return returnValue;
    }

    private String getSCMRepositoryBranch(SCM starTeamSCM) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        String branch = this.usingStarTeamURL(starTeamSCM) ? "" : this.getViewName(starTeamSCM);
        return branch;
    }

    private String getViewName(SCM starTeamSCM) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object returnValue = this.callMethodViaReflection(starTeamSCM, "getViewName");
        return (String)returnValue;
    }

    private String getSCMRepositoryURL(SCM starTeamSCM) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object url;
        if (this.usingStarTeamURL(starTeamSCM)) {
            Object returnValue = this.callMethodViaReflection(starTeamSCM, "getStFolderUrl");
            url = (String)returnValue;
        } else {
            String hostname = this.getHostName(starTeamSCM);
            String port = this.getPort(starTeamSCM);
            String projectName = this.getProjectNamer(starTeamSCM);
            url = hostname + ":" + port + "/" + projectName;
        }
        return url;
    }

    private String getProjectNamer(SCM starTeamSCM) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object returnValue = this.callMethodViaReflection(starTeamSCM, "getProjectName");
        return (String)returnValue;
    }

    private String getPort(SCM starTeamSCM) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object returnValue = this.callMethodViaReflection(starTeamSCM, "getPort");
        return (String)returnValue;
    }

    private String getHostName(SCM starTeamSCM) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object returnValue = this.callMethodViaReflection(starTeamSCM, "getHostName");
        return (String)returnValue;
    }

    private boolean usingStarTeamURL(SCM starTeamSCM) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object returnValue = this.callMethodViaReflection(starTeamSCM, "getStFolderUrl");
        String getStFolderUrl = (String)returnValue;
        return getStFolderUrl != null && !getStFolderUrl.isEmpty();
    }

    private String getFileName(ChangeLogSet.Entry change) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Object returnValue = this.callMethodViaReflection(change, "getFileName");
        return (String)returnValue;
    }

    private Date getDate(ChangeLogSet.Entry change) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Object returnValue = this.callMethodViaReflection(change, "getDate");
        return (Date)returnValue;
    }

    private String getRevision(ChangeLogSet.Entry commit) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NoSuchFieldException, SecurityException {
        Integer viewMemberID = this.getViewMemberID(commit);
        Integer revisionNumber = this.getRevisionNumber(commit);
        String changeType = this.getChangeType(commit);
        String revID = "VMID: " + viewMemberID + " Rev: " + revisionNumber;
        if (changeType.equals("DELETE")) {
            revID = revID + " (deleted)";
        }
        return revID;
    }

    private String getChangeType(ChangeLogSet.Entry commit) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NoSuchFieldException, SecurityException {
        Object changeType = this.callMethodViaReflection(commit, "getChangeType");
        return changeType.toString();
    }

    private Integer getRevisionNumber(ChangeLogSet.Entry commit) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object returnValue = this.callMethodViaReflection(commit, "getRevisionNumber");
        return (Integer)returnValue;
    }

    private Integer getViewMemberID(ChangeLogSet.Entry commit) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object returnValue = this.callMethodViaReflection(commit, "getViewMemberId");
        return (Integer)returnValue;
    }

    private String getComment(ChangeLogSet.Entry commit) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NoSuchFieldException, SecurityException {
        String changeType = this.getChangeType(commit);
        if (changeType.equals("DELETE")) {
            return "File deleted";
        }
        return commit.getMsg();
    }

    private String getCommitType(ChangeLogSet.Entry commit) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NoSuchFieldException, SecurityException {
        String changeType = this.getChangeType(commit);
        if ("ADD".equals(changeType)) {
            return EditType.ADD.getName();
        }
        if ("DELETE".equals(changeType)) {
            return EditType.DELETE.getName();
        }
        if ("MODIFIED".equals(changeType)) {
            return EditType.EDIT.getName();
        }
        return null;
    }
}

