/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model.processors.scm;

import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.scm.SCMData;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.model.processors.scm.SCMProcessor;
import hudson.FilePath;
import hudson.matrix.MatrixConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.scm.SCM;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class SCMUtils {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(SCMUtils.class);
    private static final String SCM_DATA_FILE = "scmdata.json";
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();

    private SCMUtils() {
    }

    public static SCMData extractSCMData(Run run, SCM scm, SCMProcessor scmProcessor) {
        WorkflowRun wRun;
        SCMData result = null;
        if (run.getParent() instanceof MatrixConfiguration || run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            if (!build.getChangeSet().isEmptySet()) {
                result = scmProcessor.getSCMData(build, scm);
            }
        } else if (run instanceof WorkflowRun && !(wRun = (WorkflowRun)run).getChangeSets().isEmpty()) {
            result = scmProcessor.getSCMData(wRun, scm);
        }
        return result;
    }

    public static void persistSCMData(Run run, String jobCiId, String buildCiId, SCMData scmData) throws IOException, InterruptedException {
        FilePath resultFile = new FilePath(run.getRootDir()).child(SCM_DATA_FILE);
        ArrayList<SCMData> scmDataList = new ArrayList<SCMData>();
        scmDataList.add(scmData);
        String scmDataContent = dtoFactory.dtoCollectionToJson(scmDataList);
        try {
            resultFile.write(scmDataContent, "UTF-8");
        }
        catch (IOException | InterruptedException e) {
            logger.error("Failed to persist SCMData for jobCiId " + jobCiId + " buildCiId " + buildCiId, (Throwable)e);
            throw e;
        }
    }

    public static InputStream getSCMData(Run run) throws IOException, InterruptedException {
        FilePath resultFile = new FilePath(run.getRootDir()).child(SCM_DATA_FILE);
        return resultFile.read();
    }
}

