/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model.processors.scm;

import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.model.processors.scm.GenericSCMProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.scm.GitSCMProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.scm.SCMProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.scm.StarTeamSCMProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.scm.SvnSCMProcessor;
import org.apache.logging.log4j.Logger;

public enum SCMProcessors {
    NONE("hudson.scm.NullSCM", null),
    GIT("hudson.plugins.git.GitSCM", GitSCMProcessor.class),
    SVN("hudson.scm.SubversionSCM", SvnSCMProcessor.class),
    STARTEAM("hudson.plugins.starteam.StarTeamSCM", StarTeamSCMProcessor.class);

    private static Logger logger;
    private String targetSCMPluginClassName;
    private Class<? extends SCMProcessor> processorClass;

    private SCMProcessors(String targetSCMPluginClassName, Class<? extends SCMProcessor> processorClass) {
        this.targetSCMPluginClassName = targetSCMPluginClassName;
        this.processorClass = processorClass;
    }

    public static SCMProcessor getAppropriate(String className) {
        SCMProcessor result = null;
        if (!className.startsWith(SCMProcessors.NONE.targetSCMPluginClassName)) {
            for (SCMProcessors p : SCMProcessors.values()) {
                if (!className.startsWith(p.targetSCMPluginClassName)) continue;
                try {
                    result = p.processorClass.newInstance();
                    break;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    logger.error("failed to instantiate SCM processor of type '" + p.targetSCMPluginClassName, (Throwable)e);
                }
            }
            if (result == null) {
                result = SCMProcessors.getGenericSCMProcessor(className);
            }
        }
        return result;
    }

    private static SCMProcessor getGenericSCMProcessor(String className) {
        SCMProcessor genericSCMProcessor = null;
        try {
            genericSCMProcessor = (SCMProcessor)GenericSCMProcessor.class.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("failed to instantiate SCM processor of type '" + className, (Throwable)e);
        }
        return genericSCMProcessor;
    }

    static {
        logger = SDKBasedLoggerProvider.getLogger(SCMProcessors.class);
    }
}

