/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model.processors.projects;

import com.microfocus.application.automation.tools.octane.model.processors.projects.AbstractProjectProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.projects.FreeStyleProjectProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.projects.MatrixConfigurationProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.projects.MatrixProjectProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.projects.MavenProjectProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.projects.MultiJobProjectProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.projects.UnsupportedProjectProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.projects.WorkFlowJobProcessor;
import hudson.model.Item;
import hudson.model.Job;

public class JobProcessorFactory {
    public static final String FREE_STYLE_JOB_NAME = "hudson.model.FreeStyleProject";
    public static final String SIMPLE_BUILD_TRIGGER = "hudson.tasks.BuildTrigger";
    public static final String PARAMETRIZED_BUILD_TRIGGER = "hudson.plugins.parameterizedtrigger.BuildTrigger";
    public static final String PARAMETRIZED_TRIGGER_BUILDER = "hudson.plugins.parameterizedtrigger.TriggerBuilder";
    public static final String WORKFLOW_JOB_NAME = "org.jenkinsci.plugins.workflow.job.WorkflowJob";
    public static final String WORKFLOW_RUN_NAME = "org.jenkinsci.plugins.workflow.job.WorkflowRun";
    public static final String WORKFLOW_MULTI_BRANCH_JOB_NAME = "org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject";
    public static final String MULTIJOB_JOB_NAME = "com.tikal.jenkins.plugins.multijob.MultiJobProject";
    public static final String MULTIJOB_BUILDER = "com.tikal.jenkins.plugins.multijob.MultiJobBuilder";
    public static final String MATRIX_JOB_NAME = "hudson.matrix.MatrixProject";
    public static final String MATRIX_CONFIGURATION_NAME = "hudson.matrix.MatrixConfiguration";
    public static final String CONDITIONAL_BUILDER_NAME = "org.jenkinsci.plugins.conditionalbuildstep.ConditionalBuilder";
    public static final String SINGLE_CONDITIONAL_BUILDER_NAME = "org.jenkinsci.plugins.conditionalbuildstep.singlestep.SingleConditionalBuilder";
    public static final String MAVEN_JOB_NAME = "hudson.maven.MavenModuleSet";
    public static final String MAVEN_MODULE_NAME = "hudson.maven.MavenModule";
    public static final String FOLDER_JOB_NAME = "com.cloudbees.hudson.plugins.folder.Folder";
    public static final String GITHUB_ORGANIZATION_FOLDER = "jenkins.branch.OrganizationFolder";

    private JobProcessorFactory() {
    }

    public static <T extends Job> AbstractProjectProcessor<T> getFlowProcessor(T job) {
        return switch (job.getClass().getName()) {
            case FREE_STYLE_JOB_NAME -> new FreeStyleProjectProcessor(job);
            case MATRIX_JOB_NAME -> new MatrixProjectProcessor(job);
            case MATRIX_CONFIGURATION_NAME -> new MatrixConfigurationProcessor(job);
            case MAVEN_JOB_NAME -> new MavenProjectProcessor(job);
            case MULTIJOB_JOB_NAME -> new MultiJobProjectProcessor(job);
            case WORKFLOW_JOB_NAME -> new WorkFlowJobProcessor(job);
            default -> new UnsupportedProjectProcessor(job);
        };
    }

    public static boolean isFolder(Item item) {
        return FOLDER_JOB_NAME.equals(item.getClass().getName());
    }

    public static boolean isMultibranch(Item item) {
        return WORKFLOW_MULTI_BRANCH_JOB_NAME.equals(item.getClass().getName());
    }

    public static boolean isJob(Item item) {
        return item instanceof Job;
    }

    public static boolean isMultibranchChild(Item item) {
        return WORKFLOW_JOB_NAME.equals(item.getClass().getName()) && WORKFLOW_MULTI_BRANCH_JOB_NAME.equals(item.getParent().getClass().getName());
    }
}

