/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model.processors.parameters;

import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.parameters.CIParameter;
import com.hp.octane.integrations.dto.parameters.CIParameterType;
import com.microfocus.application.automation.tools.octane.model.ModelFactory;
import com.microfocus.application.automation.tools.octane.model.processors.parameters.AbstractParametersProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.parameters.UnsupportedParameterProcessor;
import hudson.model.BooleanParameterDefinition;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.FileParameterDefinition;
import hudson.model.FileParameterValue;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.PasswordParameterDefinition;
import hudson.model.StringParameterDefinition;
import hudson.model.TextParameterDefinition;
import java.util.ArrayList;

public class InherentParameterProcessor
extends AbstractParametersProcessor {
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();

    InherentParameterProcessor() {
    }

    @Override
    public CIParameter createParameterConfig(ParameterDefinition pd) {
        CIParameter result;
        if (pd instanceof BooleanParameterDefinition) {
            result = ModelFactory.createParameterConfig(pd, CIParameterType.BOOLEAN);
        } else if (pd instanceof TextParameterDefinition) {
            result = ModelFactory.createParameterConfig(pd, CIParameterType.STRING);
        } else if (pd instanceof StringParameterDefinition) {
            result = ModelFactory.createParameterConfig(pd, CIParameterType.STRING);
        } else if (pd instanceof ChoiceParameterDefinition) {
            ChoiceParameterDefinition choicePd = (ChoiceParameterDefinition)pd;
            result = ModelFactory.createParameterConfig(pd, CIParameterType.STRING, null, new ArrayList<Object>(choicePd.getChoices()));
        } else if (pd instanceof PasswordParameterDefinition) {
            PasswordParameterDefinition passPd = (PasswordParameterDefinition)pd;
            result = ModelFactory.createParameterConfig(pd, CIParameterType.PASSWORD, passPd.getDefaultValue());
        } else {
            result = pd instanceof FileParameterDefinition ? ModelFactory.createParameterConfig(pd, CIParameterType.FILE) : new UnsupportedParameterProcessor().createParameterConfig(pd);
        }
        return result;
    }

    @Override
    public CIParameter createParameterInstance(ParameterDefinition pd, ParameterValue pv) {
        CIParameter result;
        Object value;
        CIParameter pc = this.createParameterConfig(pd);
        Object object = value = pv == null ? null : pv.getValue();
        if (pd instanceof BooleanParameterDefinition) {
            result = ModelFactory.createParameterInstance(pc, value);
        } else if (pd instanceof TextParameterDefinition) {
            result = ModelFactory.createParameterInstance(pc, value);
        } else if (pd instanceof StringParameterDefinition) {
            result = ModelFactory.createParameterInstance(pc, value);
        } else if (pd instanceof ChoiceParameterDefinition) {
            result = ModelFactory.createParameterInstance(pc, value);
        } else if (pd instanceof PasswordParameterDefinition) {
            result = ((CIParameter)dtoFactory.newDTO(CIParameter.class)).setType(pc.getType()).setName(pc.getName()).setDescription(pc.getDescription()).setChoices(pc.getChoices()).setDefaultValue(pc.getDefaultValue()).setValue(null);
        } else if (pd instanceof FileParameterDefinition) {
            FileParameterValue filePv = (FileParameterValue)pv;
            result = ((CIParameter)dtoFactory.newDTO(CIParameter.class)).setType(pc.getType()).setName(pc.getName()).setDescription(pc.getDescription()).setChoices(pc.getChoices()).setDefaultValue(pc.getDefaultValue()).setValue((Object)(filePv != null ? filePv.getOriginalFileName() : null));
        } else {
            result = new UnsupportedParameterProcessor().createParameterInstance(pd, pv);
        }
        return result;
    }
}

