/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model.processors.builders;

import com.hp.octane.integrations.dto.pipelines.PipelinePhase;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.model.processors.builders.ConditionalBuilderProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.builders.MultiJobBuilderProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.builders.ParameterizedTriggerProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.builders.SingleConditionalBuilderProcessor;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.tasks.Builder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public abstract class AbstractBuilderProcessor {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(AbstractBuilderProcessor.class);
    protected ArrayList<PipelinePhase> phases = new ArrayList();

    public List<PipelinePhase> getPhases() {
        return this.phases;
    }

    public static void processInternalBuilders(Builder builder, Job job, String phasesName, List<PipelinePhase> internalPhases, Set<Job> processedJobs) {
        processedJobs.add(job);
        AbstractBuilderProcessor builderProcessor = null;
        try {
            switch (builder.getClass().getName()) {
                case "org.jenkinsci.plugins.conditionalbuildstep.ConditionalBuilder": {
                    builderProcessor = new ConditionalBuilderProcessor(builder, job, phasesName, internalPhases, processedJobs);
                    break;
                }
                case "org.jenkinsci.plugins.conditionalbuildstep.singlestep.SingleConditionalBuilder": {
                    builderProcessor = new SingleConditionalBuilderProcessor(builder, job, phasesName, internalPhases, processedJobs);
                    break;
                }
                case "hudson.plugins.parameterizedtrigger.TriggerBuilder": {
                    builderProcessor = new ParameterizedTriggerProcessor(builder, job, phasesName, processedJobs);
                    break;
                }
                case "com.tikal.jenkins.plugins.multijob.MultiJobBuilder": {
                    builderProcessor = new MultiJobBuilderProcessor(builder, job, processedJobs);
                    break;
                }
                default: {
                    logger.debug("not yet supported build (internal) action: " + builder.getClass().getName());
                    break;
                }
            }
        }
        catch (Throwable e) {
            logger.info("Failed to load build processor for build " + builder.getClass().getName() + ",  " + e.getClass().getName() + " : " + e.getMessage());
        }
        if (builderProcessor != null) {
            internalPhases.addAll(builderProcessor.getPhases());
        }
        processedJobs.remove(job);
    }

    protected void eliminateIllegalItems(Job job, Set<Job> processedJobs, List<AbstractProject> items) {
        Iterator<AbstractProject> iterator = items.iterator();
        while (iterator.hasNext()) {
            AbstractProject next = iterator.next();
            if (next == null) {
                iterator.remove();
                logger.warn("encountered null project reference; considering it as corrupted configuration and skipping");
                continue;
            }
            if (!processedJobs.contains(next)) continue;
            iterator.remove();
            logger.warn(String.format("encountered circular reference from %s to %s", job.getFullName(), next.getFullName()));
        }
    }
}

