/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model;

import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.parameters.CIParameter;
import com.hp.octane.integrations.dto.parameters.CIParameterType;
import com.hp.octane.integrations.dto.pipelines.PipelineNode;
import com.hp.octane.integrations.dto.pipelines.PipelinePhase;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.model.processors.parameters.ParameterProcessors;
import com.microfocus.application.automation.tools.octane.model.processors.projects.AbstractProjectProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.projects.JobProcessorFactory;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class ModelFactory {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(ModelFactory.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();

    public static PipelineNode createStructureItem(Job job) {
        return ModelFactory.createStructureItem(job, new HashSet<Job>());
    }

    public static PipelinePhase createStructurePhase(String name, boolean blocking, List<AbstractProject> items, Set<Job> processedJobs) {
        PipelinePhase pipelinePhase = (PipelinePhase)dtoFactory.newDTO(PipelinePhase.class);
        pipelinePhase.setName(name);
        pipelinePhase.setBlocking(blocking);
        PipelineNode[] tmp = new PipelineNode[items.size()];
        for (int i = 0; i < tmp.length; ++i) {
            if (items.get(i) != null) {
                tmp[i] = ModelFactory.createStructureItem((Job)items.get(i), processedJobs);
                continue;
            }
            logger.warn("One of referenced jobs is null, your Jenkins config probably broken, skipping this job...");
        }
        pipelinePhase.setJobs(Arrays.asList(tmp));
        return pipelinePhase;
    }

    private static PipelineNode createStructureItem(Job job, Set<Job> processedJobs) {
        AbstractProjectProcessor<Job> projectProcessor = JobProcessorFactory.getFlowProcessor(job);
        projectProcessor.buildStructure(processedJobs);
        PipelineNode pipelineNode = (PipelineNode)dtoFactory.newDTO(PipelineNode.class);
        pipelineNode.setJobCiId(projectProcessor.getTranslatedJobName());
        pipelineNode.setName(BuildHandlerUtils.translateFullDisplayName(job.getFullDisplayName()));
        pipelineNode.setParameters(ParameterProcessors.getConfigs(job));
        pipelineNode.setPhasesInternal(projectProcessor.getInternals());
        pipelineNode.setPhasesPostBuild(projectProcessor.getPostBuilds());
        return pipelineNode;
    }

    public static CIParameter createParameterConfig(ParameterDefinition pd) {
        return ModelFactory.createParameterConfig(pd, CIParameterType.UNKNOWN, null, null);
    }

    public static CIParameter createParameterConfig(ParameterDefinition pd, CIParameterType type) {
        return ModelFactory.createParameterConfig(pd, type, pd.getDefaultParameterValue() == null ? null : pd.getDefaultParameterValue().getValue(), null);
    }

    public static CIParameter createParameterConfig(ParameterDefinition pd, CIParameterType type, Object defaultValue) {
        return ModelFactory.createParameterConfig(pd, type, defaultValue, null);
    }

    public static CIParameter createParameterConfig(String name, CIParameterType type, List<Object> choices) {
        CIParameter ciParameter = (CIParameter)dtoFactory.newDTO(CIParameter.class);
        ciParameter.setName(name);
        ciParameter.setType(type);
        ciParameter.setDescription("");
        ciParameter.setChoices(choices.toArray());
        return ciParameter;
    }

    public static CIParameter createParameterConfig(ParameterDefinition pd, CIParameterType type, Object defaultValue, List<Object> choices) {
        CIParameter ciParameter = (CIParameter)dtoFactory.newDTO(CIParameter.class);
        ciParameter.setName(pd.getName());
        ciParameter.setType(type);
        ciParameter.setDescription(pd.getDescription());
        if (type != CIParameterType.UNKNOWN && type != CIParameterType.PASSWORD) {
            if (defaultValue != null) {
                ciParameter.setDefaultValue(defaultValue);
            } else {
                ParameterValue tmp;
                try {
                    tmp = pd.getDefaultParameterValue();
                }
                catch (Throwable e) {
                    tmp = null;
                }
                ciParameter.setDefaultValue(tmp == null ? "" : tmp.getValue());
            }
            if (choices != null) {
                ciParameter.setChoices(choices.toArray());
            }
        }
        return ciParameter;
    }

    public static CIParameter createParameterInstance(CIParameter pc, Object rawValue) {
        String value = rawValue == null ? null : rawValue.toString();
        return ((CIParameter)dtoFactory.newDTO(CIParameter.class)).setName(pc.getName()).setType(pc.getType()).setDescription(pc.getDescription()).setChoices(pc.getChoices()).setDescription(pc.getDescription()).setDefaultValue(pc.getDefaultValue()).setValue((Object)value);
    }

    public static String generateSubBuildName(List<CIParameter> parameters) {
        ArrayList<CIParameter> sortedList = new ArrayList<CIParameter>();
        for (CIParameter p : parameters) {
            if (p.getType() != CIParameterType.AXIS) continue;
            sortedList.add(p);
        }
        sortedList.sort(Comparator.comparing(CIParameter::getName));
        StringBuilder subBuildName = new StringBuilder();
        if (sortedList.size() > 0) {
            int i;
            for (i = 0; i < sortedList.size() - 1; ++i) {
                subBuildName.append(((CIParameter)sortedList.get(i)).getName()).append("=").append(((CIParameter)sortedList.get(i)).getValue().toString()).append(",");
            }
            subBuildName.append(((CIParameter)sortedList.get(i)).getName()).append("=").append(((CIParameter)sortedList.get(i)).getValue().toString());
        }
        return subBuildName.toString();
    }
}

