/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model;

import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.causes.CIEventCause;
import com.hp.octane.integrations.dto.causes.CIEventCauseType;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

public final class CIEventCausesFactory {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(CIEventCausesFactory.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();

    private CIEventCausesFactory() {
    }

    public static List<CIEventCause> processCauses(Run<?, ?> run) {
        if (run == null) {
            throw new IllegalArgumentException("run MUST NOT be null");
        }
        LinkedHashMap<String, CIEventCause> result = new LinkedHashMap<String, CIEventCause>();
        List causes = run.getCauses();
        for (Cause cause : causes) {
            CIEventCause tmpResultCause = (CIEventCause)dtoFactory.newDTO(CIEventCause.class);
            if (cause instanceof SCMTrigger.SCMTriggerCause) {
                tmpResultCause.setType(CIEventCauseType.SCM);
                result.put(tmpResultCause.generateKey(), tmpResultCause);
                continue;
            }
            if (cause instanceof TimerTrigger.TimerTriggerCause) {
                tmpResultCause.setType(CIEventCauseType.TIMER);
                result.put(tmpResultCause.generateKey(), tmpResultCause);
                continue;
            }
            if (cause instanceof Cause.UserIdCause) {
                Cause.UserIdCause tmpUserCause = (Cause.UserIdCause)cause;
                tmpResultCause.setType(CIEventCauseType.USER);
                tmpResultCause.setUser(tmpUserCause.getUserId());
                result.put(tmpResultCause.generateKey(), tmpResultCause);
                continue;
            }
            if (cause instanceof Cause.UpstreamCause) {
                FlowNode enclosingNode;
                WorkflowRun rootWFRun;
                if ("RebuildCause".equals(cause.getClass().getSimpleName())) continue;
                Cause.UpstreamCause tmpUpstreamCause = (Cause.UpstreamCause)cause;
                boolean succeededToBuildFlowCauses = false;
                Run upstreamRun = tmpUpstreamCause.getUpstreamRun();
                if (upstreamRun != null && "org.jenkinsci.plugins.workflow.job.WorkflowRun".equals(upstreamRun.getClass().getName()) && (rootWFRun = (WorkflowRun)upstreamRun).getExecution() != null && rootWFRun.getExecution().getCurrentHeads() != null && (enclosingNode = CIEventCausesFactory.lookupJobEnclosingNode(run, rootWFRun)) != null) {
                    List<CIEventCause> flowCauses = CIEventCausesFactory.processCauses(enclosingNode);
                    flowCauses.forEach(fc -> result.put(fc.generateKey(), (CIEventCause)fc));
                    succeededToBuildFlowCauses = true;
                }
                if (upstreamRun == null || succeededToBuildFlowCauses) continue;
                tmpResultCause.setType(CIEventCauseType.UPSTREAM);
                tmpResultCause.setProject(CIEventCausesFactory.resolveJobCiId(tmpUpstreamCause.getUpstreamProject()));
                tmpResultCause.setBuildCiId(String.valueOf(tmpUpstreamCause.getUpstreamBuild()));
                tmpResultCause.setCauses(CIEventCausesFactory.processCauses(upstreamRun));
                result.put(tmpResultCause.generateKey(), tmpResultCause);
                continue;
            }
            tmpResultCause.setType(CIEventCauseType.UNDEFINED);
            result.put(tmpResultCause.generateKey(), tmpResultCause);
        }
        return new ArrayList<CIEventCause>(result.values());
    }

    public static List<CIEventCause> processCauses(FlowNode flowNode) {
        LinkedList<CIEventCause> causes = new LinkedList<CIEventCause>();
        CIEventCausesFactory.processCauses(flowNode, causes, new LinkedHashSet<FlowNode>(), new HashSet<FlowNode>());
        return causes;
    }

    private static void processCauses(FlowNode flowNode, List<CIEventCause> causes, Set<FlowNode> startStagesToSkip, Set<FlowNode> visitedParents) {
        if (flowNode.getParents().isEmpty() && !visitedParents.contains(flowNode)) {
            WorkflowRun parentRun = BuildHandlerUtils.extractParentRun(flowNode);
            CIEventCause cause = ((CIEventCause)dtoFactory.newDTO(CIEventCause.class)).setType(CIEventCauseType.UPSTREAM).setProject(BuildHandlerUtils.getJobCiId((Run)parentRun)).setBuildCiId(BuildHandlerUtils.getBuildCiId((Run)parentRun)).setCauses(CIEventCausesFactory.processCauses(parentRun));
            visitedParents.add(flowNode);
            causes.add(cause);
        }
        if (BuildHandlerUtils.isStageEndNode(flowNode)) {
            startStagesToSkip.add((FlowNode)((StepEndNode)flowNode).getStartNode());
        }
        for (FlowNode parent : flowNode.getParents()) {
            if (BuildHandlerUtils.isStageEndNode(parent)) {
                startStagesToSkip.add((FlowNode)((StepEndNode)parent).getStartNode());
                CIEventCausesFactory.processCauses(parent, causes, startStagesToSkip, visitedParents);
                continue;
            }
            if (BuildHandlerUtils.isStageStartNode(parent)) {
                if (!startStagesToSkip.contains(parent) && !visitedParents.contains(parent)) {
                    visitedParents.add(parent);
                    CIEventCause cause = ((CIEventCause)dtoFactory.newDTO(CIEventCause.class)).setType(CIEventCauseType.UPSTREAM).setProject(parent.getDisplayName()).setBuildCiId(String.valueOf(BuildHandlerUtils.extractParentRun(parent).getNumber()));
                    causes.add(cause);
                    CIEventCausesFactory.processCauses(parent, cause.getCauses(), startStagesToSkip, visitedParents);
                    continue;
                }
                if (!startStagesToSkip.contains(parent)) continue;
                startStagesToSkip.remove(parent);
                CIEventCausesFactory.processCauses(parent, causes, startStagesToSkip, visitedParents);
                continue;
            }
            CIEventCausesFactory.processCauses(parent, causes, startStagesToSkip, visitedParents);
        }
    }

    private static String resolveJobCiId(String jobPlainName) {
        if (!jobPlainName.contains(",")) {
            return BuildHandlerUtils.translateFolderJobName(jobPlainName);
        }
        return jobPlainName;
    }

    private static FlowNode lookupJobEnclosingNode(Run targetRun, WorkflowRun parentRun) {
        if (parentRun.getExecution() == null) {
            return null;
        }
        FlowNode result = null;
        OctaneParentNodeAction octaneParentNodeAction = (OctaneParentNodeAction)targetRun.getAction(OctaneParentNodeAction.class);
        if (octaneParentNodeAction != null) {
            try {
                result = parentRun.getExecution().getNode(octaneParentNodeAction.parentFlowNodeId);
            }
            catch (IOException ioe) {
                logger.error("failed to extract parent flow node for " + String.valueOf(targetRun), (Throwable)ioe);
            }
        } else {
            List potentialAncestors = parentRun.getExecution().getCurrentHeads();
            if (potentialAncestors != null) {
                for (FlowNode head : potentialAncestors) {
                    String label;
                    if (!(head instanceof StepAtomNode) || head.getAction(LabelAction.class) == null) continue;
                    StepDescriptor descriptor = ((StepAtomNode)head).getDescriptor();
                    LabelAction labelAction = (LabelAction)head.getAction(LabelAction.class);
                    String string = label = labelAction != null ? labelAction.getDisplayName() : null;
                    if (descriptor == null || !descriptor.getId().endsWith("BuildTriggerStep") || label == null || !label.endsWith(targetRun.getParent().getFullDisplayName())) continue;
                    result = head;
                    targetRun.addAction((Action)new OctaneParentNodeAction(result.getId()));
                    break;
                }
            }
        }
        return result;
    }

    private static final class OctaneParentNodeAction
    extends InvisibleAction {
        private final String parentFlowNodeId;

        private OctaneParentNodeAction(String parentFlowNodeId) {
            this.parentFlowNodeId = parentFlowNodeId;
        }
    }
}

