/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.executor;

import com.google.inject.Inject;
import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.executor.impl.TestingToolType;
import com.hp.octane.integrations.exceptions.OctaneRestException;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.uft.UftTestDispatchUtils;
import com.hp.octane.integrations.uft.items.JobRunContext;
import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import com.hp.octane.integrations.utils.SdkStringUtils;
import com.microfocus.application.automation.tools.octane.ResultQueue;
import com.microfocus.application.automation.tools.octane.actions.UFTActionDetectionBuildAction;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.executor.UFTTestDetectionFinalResultSaverCallable;
import com.microfocus.application.automation.tools.octane.executor.UFTTestDetectionService;
import com.microfocus.application.automation.tools.octane.executor.UftTestDiscoveryQueue;
import com.microfocus.application.automation.tools.octane.tests.AbstractSafeLoggingAsyncPeriodWork;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;

@Extension
public class UftTestDiscoveryDispatcher
extends AbstractSafeLoggingAsyncPeriodWork {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(UftTestDiscoveryDispatcher.class);
    private static final int MAX_DISPATCH_TRIALS = 5;
    private UftTestDiscoveryQueue queue;
    private volatile boolean stopped = false;

    public UftTestDiscoveryDispatcher() {
        super("Uft Test Discovery Dispatcher");
    }

    private static void dispatchDetectionResults(ResultQueue.QueueItem item, EntitiesService entitiesService, UftTestDiscoveryResult result, AbstractBuild build) {
        UftTestDispatchUtils.prepareDiscoveryResultForDispatch((EntitiesService)entitiesService, (UftTestDiscoveryResult)result);
        try {
            build.getWorkspace().act((FilePath.FileCallable)new UFTTestDetectionFinalResultSaverCallable(result, build.getNumber()));
        }
        catch (Exception e) {
            logger.info("Failed to save final result : " + e.getMessage());
        }
        JobRunContext jobRunContext = JobRunContext.create((String)item.getProjectName(), (int)item.getBuildNumber());
        UftTestDispatchUtils.dispatchDiscoveryResult((EntitiesService)entitiesService, (UftTestDiscoveryResult)result, (JobRunContext)jobRunContext, null);
        if (result.getTestingToolType().equals((Object)TestingToolType.MBT)) {
            UFTActionDetectionBuildAction action = (UFTActionDetectionBuildAction)build.getAction(UFTActionDetectionBuildAction.class);
            action.setResults(result);
            try {
                build.save();
            }
            catch (IOException e) {
                logger.info("Failed to save build: " + e.getMessage());
            }
        }
    }

    @Override
    protected void doExecute(TaskListener listener) {
        block16: {
            if (this.stopped) {
                return;
            }
            if (this.queue.peekFirst() == null) {
                return;
            }
            if (OctaneSDK.getClients().isEmpty()) {
                logger.warn("There are pending discovered UFT tests, but no Octane configuration is found, results can't be submitted");
                return;
            }
            ResultQueue.QueueItem item = null;
            try {
                while ((item = this.queue.peekFirst()) != null) {
                    OctaneClient client;
                    if (this.queueContainsPostponedItems(item)) {
                        logger.warn("Project [" + item.getProjectName() + "] has postpone items");
                        break;
                    }
                    Job project = (Job)Jenkins.get().getItemByFullName(item.getProjectName());
                    if (project == null) {
                        logger.warn("Project [" + item.getProjectName() + "] no longer exists, pending discovered tests can't be submitted");
                        this.queue.remove();
                        continue;
                    }
                    AbstractBuild build = (AbstractBuild)project.getBuildByNumber(item.getBuildNumber());
                    if (build == null) {
                        logger.warn("Build [" + item.getProjectName() + "#" + item.getBuildNumber() + "] no longer exists, pending discovered tests can't be submitted");
                        this.queue.remove();
                        continue;
                    }
                    UftTestDiscoveryResult result = UFTTestDetectionService.readDetectionResults((Run)build);
                    if (result == null) {
                        logger.warn("Build [" + item.getProjectName() + "#" + item.getBuildNumber() + "] no longer contains valid detection result file");
                        this.queue.remove();
                        continue;
                    }
                    try {
                        client = OctaneSDK.getClientByInstanceId((String)result.getConfigurationId());
                    }
                    catch (Exception e) {
                        logger.error("Build [" + item.getProjectName() + "#" + item.getBuildNumber() + "] does not have valid configuration " + result.getConfigurationId() + " : " + e.getMessage());
                        this.queue.remove();
                        continue;
                    }
                    if (!client.getConfigurationService().isConnected()) {
                        logger.info(client.getConfigurationService().getConfiguration().getLocationForLog() + " - Build [" + item.getProjectName() + "#" + item.getBuildNumber() + "] - octane is down , postponing sending UFT tests ");
                        item.setSendAfter(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L));
                        this.queue.remove();
                        this.queue.add(item);
                        continue;
                    }
                    logger.warn("Persistence [" + item.getProjectName() + "#" + item.getBuildNumber() + "]");
                    UftTestDiscoveryDispatcher.dispatchDetectionResults(item, client.getEntitiesService(), result, build);
                    this.queue.remove();
                }
            }
            catch (OctaneRestException e) {
                String reasonDesc;
                String string = reasonDesc = StringUtils.isNotEmpty((String)e.getData().getDescriptionTranslated()) ? e.getData().getDescriptionTranslated() : e.getData().getDescription();
                if (e.getResponseStatus() == 403) {
                    logger.error("Failed to  persist discovery of [" + item.getProjectName() + "#" + item.getBuildNumber() + "]  because of lacking Octane permission : " + reasonDesc);
                } else {
                    logger.error("Failed to  persist discovery of [" + item.getProjectName() + "#" + item.getBuildNumber() + "]  : " + reasonDesc);
                }
                this.queue.remove();
            }
            catch (Exception e) {
                if (item == null) break block16;
                item.incrementFailCount();
                if (item.incrementFailCount() <= 5) break block16;
                this.queue.remove();
                logger.error("Failed to  persist discovery of [" + item.getProjectName() + "#" + item.getBuildNumber() + "]  after 5 trials");
            }
        }
    }

    private boolean queueContainsPostponedItems(ResultQueue.QueueItem queueItem) {
        return queueItem.getSendAfter() > 0L && queueItem.getSendAfter() > System.currentTimeMillis();
    }

    public void close() {
        logger.info("stopping the UFT dispatcher and closing its queue");
        this.stopped = true;
        this.queue.close();
    }

    public long getRecurrencePeriod() {
        String value = System.getProperty("UftTestDiscoveryDispatcher.Period");
        if (!SdkStringUtils.isEmpty((String)value)) {
            return Long.parseLong(value);
        }
        return TimeUnit.SECONDS.toMillis(30L);
    }

    @Inject
    public void setTestResultQueue(UftTestDiscoveryQueue queue) {
        this.queue = queue;
    }

    public void enqueueResult(String instanceId, String projectName, int buildNumber, String workspace) {
        this.queue.add(instanceId, projectName, buildNumber, workspace);
    }
}

