/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.executor;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.executor.CredentialsInfo;
import com.hp.octane.integrations.dto.executor.TestConnectivityInfo;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.executor.scmmanager.ScmPluginFactory;
import com.microfocus.application.automation.tools.octane.executor.scmmanager.ScmPluginHandler;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.User;
import hudson.security.Permission;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;

public class ExecutorConnectivityService {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(ExecutorConnectivityService.class);
    private static final Map<Permission, String> requirePremissions = ExecutorConnectivityService.initRequirePermissions();
    private static final Map<Permission, String> credentialsPremissions = ExecutorConnectivityService.initCredentialsPermissions();
    private static final String PLUGIN_NAME = "Application Automation Tools";

    public static OctaneResponse checkRepositoryConnectivity(TestConnectivityInfo testConnectivityInfo) {
        logger.info("checkRepositoryConnectivity started to " + testConnectivityInfo.getScmRepository().getUrl());
        OctaneResponse result = (OctaneResponse)DTOFactory.getInstance().newDTO(OctaneResponse.class);
        if (testConnectivityInfo.getScmRepository() != null && StringUtils.isNotEmpty((String)testConnectivityInfo.getScmRepository().getUrl())) {
            boolean needCredentialsPermission = false;
            BaseStandardCredentials credentials = null;
            if (StringUtils.isNotEmpty((String)testConnectivityInfo.getUsername()) && testConnectivityInfo.getPassword() != null) {
                try {
                    credentials = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, null, null, testConnectivityInfo.getUsername(), testConnectivityInfo.getPassword());
                }
                catch (Descriptor.FormException e) {
                    throw new RuntimeException(e);
                }
                needCredentialsPermission = true;
            } else if (StringUtils.isNotEmpty((String)testConnectivityInfo.getCredentialsId())) {
                credentials = ExecutorConnectivityService.getCredentialsById(testConnectivityInfo.getCredentialsId());
            }
            List<String> permissionResult = ExecutorConnectivityService.checkCIPermissions(Jenkins.getInstanceOrNull(), needCredentialsPermission);
            if (!permissionResult.isEmpty()) {
                String user = User.current() != null ? User.current().getId() : Jenkins.ANONYMOUS.getPrincipal().toString();
                String error = String.format("Failed : User '%s' is missing permissions '%s' on CI server", user, permissionResult);
                logger.error(error);
                result.setStatus(403);
                result.setBody(error);
                return result;
            }
            if (!ScmPluginFactory.isPluginInstalled(testConnectivityInfo.getScmRepository().getType())) {
                result.setStatus(400);
                result.setBody(String.format("%s plugin is not installed.", testConnectivityInfo.getScmRepository().getType().value().toUpperCase()));
            } else {
                ScmPluginHandler handler = ScmPluginFactory.getScmHandler(testConnectivityInfo.getScmRepository().getType());
                handler.checkRepositoryConnectivity(testConnectivityInfo, (StandardCredentials)credentials, result);
            }
        } else {
            result.setStatus(400);
            result.setBody("Missing input for testing");
        }
        if (result.getStatus() != 200) {
            logger.info("checkRepositoryConnectivity failed: " + result.getBody());
        } else {
            logger.info("checkRepositoryConnectivity ok");
        }
        return result;
    }

    public static OctaneResponse upsertRepositoryCredentials(CredentialsInfo credentialsInfo) {
        OctaneResponse result = (OctaneResponse)DTOFactory.getInstance().newDTO(OctaneResponse.class);
        result.setStatus(200);
        UsernamePasswordCredentialsImpl jenkinsCredentials = null;
        if (StringUtils.isNotEmpty((String)credentialsInfo.getUsername()) && credentialsInfo.getPassword() != null && (jenkinsCredentials = ExecutorConnectivityService.tryGetCredentialsByUsernamePassword(credentialsInfo.getUsername(), credentialsInfo.getPassword())) == null) {
            UsernamePasswordCredentialsImpl c;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String desc = String.format("Created by the OpenText %s plugin on %s", PLUGIN_NAME, formatter.format(new Date()));
            try {
                c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, credentialsInfo.getCredentialsId(), desc, credentialsInfo.getUsername(), credentialsInfo.getPassword());
            }
            catch (Descriptor.FormException e) {
                throw new RuntimeException(e);
            }
            SystemCredentialsProvider.StoreImpl store = new SystemCredentialsProvider.StoreImpl();
            try {
                if (store.addCredentials(Domain.global(), (Credentials)c)) {
                    jenkinsCredentials = c;
                    result.setStatus(201);
                }
            }
            catch (IOException e) {
                logger.error("Failed to add credentials " + e.getMessage());
                result.setStatus(500);
                result.setBody("Failed to add credentials " + e.getMessage());
            }
        }
        if (jenkinsCredentials != null) {
            result.setBody(jenkinsCredentials.getId());
        }
        return result;
    }

    private static BaseStandardCredentials getCredentialsById(String credentialsId) {
        List list = CredentialsProvider.lookupCredentials(BaseStandardCredentials.class, (Item)null, null, (DomainRequirement[])new DomainRequirement[]{null});
        for (BaseStandardCredentials cred : list) {
            if (!cred.getId().equals(credentialsId)) continue;
            return cred;
        }
        return null;
    }

    private static UsernamePasswordCredentialsImpl tryGetCredentialsByUsernamePassword(String username, String password) {
        List list = CredentialsProvider.lookupCredentials(UsernamePasswordCredentialsImpl.class, (Item)null, null, (DomainRequirement[])new DomainRequirement[]{null});
        for (UsernamePasswordCredentialsImpl cred : list) {
            if (!StringUtils.equalsIgnoreCase((String)cred.getUsername(), (String)username) || !StringUtils.equals((String)cred.getPassword().getPlainText(), (String)password) || cred.getDescription() == null || !cred.getDescription().contains(PLUGIN_NAME)) continue;
            return cred;
        }
        return null;
    }

    private static List<String> checkCIPermissions(Jenkins jenkins, boolean checkCredentialsPermissions) {
        ArrayList<String> result = new ArrayList<String>();
        ExecutorConnectivityService.checkPermissions(jenkins, result, requirePremissions);
        if (checkCredentialsPermissions) {
            ExecutorConnectivityService.checkPermissions(jenkins, result, credentialsPremissions);
        }
        return result;
    }

    private static void checkPermissions(Jenkins jenkins, List<String> result, Map<Permission, String> permissions) {
        for (Permission permission : permissions.keySet()) {
            if (jenkins.hasPermission(permission)) continue;
            result.add(permissions.get(permission));
        }
    }

    private static Map<Permission, String> initRequirePermissions() {
        HashMap<Permission, String> result = new HashMap<Permission, String>();
        result.put(Item.CREATE, "Job.CREATE");
        result.put(Item.READ, "Job.READ");
        return result;
    }

    private static Map<Permission, String> initCredentialsPermissions() {
        HashMap<Permission, String> result = new HashMap<Permission, String>();
        result.put(CredentialsProvider.CREATE, "Credentials.CREATE");
        return result;
    }
}

