/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.executor;

import com.hp.octane.integrations.OctaneSDK;
import com.microfocus.application.automation.tools.octane.executor.scmmanager.ScmPluginFactory;
import com.microfocus.application.automation.tools.octane.executor.scmmanager.ScmPluginHandler;
import com.microfocus.application.automation.tools.run.RunFromFileBuilder;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.FreeStyleProject;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import hudson.tasks.Builder;
import java.util.List;

@Extension
public class CheckOutSubDirEnvContributor
extends EnvironmentContributor {
    public static final String CHECKOUT_SUBDIR_ENV_NAME = "CHECKOUT_SUBDIR";

    public void buildEnvironmentFor(Job j, EnvVars envs, TaskListener listener) {
        if (!OctaneSDK.hasClients()) {
            return;
        }
        String dir = CheckOutSubDirEnvContributor.getSharedCheckOutDirectory(j);
        if (dir != null) {
            envs.put(CHECKOUT_SUBDIR_ENV_NAME, dir);
        }
    }

    public static String getSharedCheckOutDirectory(Job j) {
        if (j instanceof FreeStyleProject) {
            FreeStyleProject proj = (FreeStyleProject)j;
            SCM scm = proj.getScm();
            List builders = proj.getBuilders();
            if (scm != null && !(scm instanceof NullSCM) && builders != null) {
                for (Builder builder : builders) {
                    ScmPluginHandler scmPluginHandler;
                    if (!(builder instanceof RunFromFileBuilder) || (scmPluginHandler = ScmPluginFactory.getScmHandlerByScmPluginName(scm.getClass().getName())) == null) continue;
                    return scmPluginHandler.getSharedCheckOutDirectory(j);
                }
            }
        }
        return null;
    }
}

