/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.events;

import com.google.inject.Inject;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.causes.CIEventCause;
import com.hp.octane.integrations.dto.causes.CIEventCauseType;
import com.hp.octane.integrations.dto.events.CIEvent;
import com.hp.octane.integrations.dto.events.CIEventType;
import com.hp.octane.integrations.dto.events.MultiBranchType;
import com.hp.octane.integrations.dto.events.PhaseType;
import com.hp.octane.integrations.dto.snapshots.CIBuildResult;
import com.microfocus.application.automation.tools.octane.CIJenkinsServicesImpl;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.events.BuildLogHelper;
import com.microfocus.application.automation.tools.octane.events.OutputEnvironmentParametersHelper;
import com.microfocus.application.automation.tools.octane.model.CIEventCausesFactory;
import com.microfocus.application.automation.tools.octane.model.processors.parameters.ParameterProcessors;
import com.microfocus.application.automation.tools.octane.tests.TestListener;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.Run;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class WorkflowListenerOctaneImpl
implements GraphListener {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(WorkflowListenerOctaneImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private static Set<String> workflowJobStarted = new HashSet<String>();
    @Inject
    private TestListener testListener;

    public void onNewHead(FlowNode flowNode) {
        if (!OctaneSDK.hasClients()) {
            return;
        }
        try {
            if (BuildHandlerUtils.isWorkflowStartNode(flowNode)) {
                this.sendPipelineStartedEvent(flowNode);
            } else if (BuildHandlerUtils.isWorkflowEndNode(flowNode)) {
                WorkflowRun parentRun = BuildHandlerUtils.extractParentRun(flowNode);
                this.sendPipelineFinishedEvent(parentRun);
                BuildLogHelper.enqueueBuildLog((Run)parentRun);
            } else if (BuildHandlerUtils.isStageStartNode(flowNode)) {
                this.sendStageStartedEvent((StepStartNode)flowNode);
            } else if (BuildHandlerUtils.isStageEndNode(flowNode)) {
                this.sendStageFinishedEvent((StepEndNode)flowNode);
            }
        }
        catch (Throwable throwable) {
            logger.error("failed to build and/or dispatch STARTED/FINISHED event for " + String.valueOf(flowNode), throwable);
        }
    }

    private void sendPipelineStartedEvent(FlowNode flowNode) {
        WorkflowRun parentRun = BuildHandlerUtils.extractParentRun(flowNode);
        String buildKey = this.getBuildKey(parentRun);
        if (workflowJobStarted.contains(buildKey)) {
            return;
        }
        workflowJobStarted.add(buildKey);
        CIEvent event = ((CIEvent)dtoFactory.newDTO(CIEvent.class)).setEventType(CIEventType.STARTED).setProjectDisplayName(BuildHandlerUtils.translateFullDisplayName(((WorkflowJob)parentRun.getParent()).getFullDisplayName())).setProject(BuildHandlerUtils.getJobCiId((Run)parentRun)).setBuildCiId(BuildHandlerUtils.getBuildCiId((Run)parentRun)).setNumber(String.valueOf(parentRun.getNumber())).setParameters(ParameterProcessors.getInstances((Run)parentRun)).setStartTime(Long.valueOf(parentRun.getStartTimeInMillis())).setEstimatedDuration(Long.valueOf(parentRun.getEstimatedDuration())).setCauses(CIEventCausesFactory.processCauses(parentRun));
        if (this.isInternal(event.getCauses())) {
            event.setPhaseType(PhaseType.INTERNAL);
        }
        if (((WorkflowJob)parentRun.getParent()).getParent().getClass().getName().equals("org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject")) {
            event.setParentCiId(BuildHandlerUtils.translateFolderJobName(((WorkflowJob)parentRun.getParent()).getParent().getFullName())).setMultiBranchType(MultiBranchType.MULTI_BRANCH_CHILD).setProjectDisplayName(BuildHandlerUtils.translateFullDisplayName(((WorkflowJob)parentRun.getParent()).getFullDisplayName()));
        }
        CIJenkinsServicesImpl.publishEventToRelevantClients(event);
    }

    private boolean isInternal(List<CIEventCause> causes) {
        if (causes != null) {
            for (CIEventCause cause : causes) {
                if (!CIEventCauseType.UPSTREAM.equals((Object)cause.getType())) continue;
                return true;
            }
        }
        return false;
    }

    private String getBuildKey(WorkflowRun run) {
        return run.getFullDisplayName();
    }

    private void sendPipelineFinishedEvent(WorkflowRun parentRun) {
        workflowJobStarted.remove(this.getBuildKey(parentRun));
        boolean hasTests = this.testListener.processBuild((Run)parentRun);
        CIEvent event = ((CIEvent)dtoFactory.newDTO(CIEvent.class)).setEventType(CIEventType.FINISHED).setProject(BuildHandlerUtils.getJobCiId((Run)parentRun)).setBuildCiId(BuildHandlerUtils.getBuildCiId((Run)parentRun)).setNumber(String.valueOf(parentRun.getNumber())).setParameters(ParameterProcessors.getInstances((Run)parentRun)).setStartTime(Long.valueOf(parentRun.getStartTimeInMillis())).setEstimatedDuration(Long.valueOf(parentRun.getEstimatedDuration())).setDuration(Long.valueOf(parentRun.getDuration())).setResult(BuildHandlerUtils.translateRunResult((Run)parentRun)).setCauses(CIEventCausesFactory.processCauses(parentRun)).setTestResultExpected(hasTests).setEnvironmentOutputtedParameters(OutputEnvironmentParametersHelper.getOutputEnvironmentParams((Run)parentRun));
        CIJenkinsServicesImpl.publishEventToRelevantClients(event);
    }

    private void sendStageStartedEvent(StepStartNode stepStartNode) {
        logger.debug("node " + String.valueOf(stepStartNode) + " detected as Stage Start node");
        CIEvent event = this.prepareStageEvent(stepStartNode).setEventType(CIEventType.STARTED);
        CIJenkinsServicesImpl.publishEventToRelevantClients(event);
    }

    private void sendStageFinishedEvent(StepEndNode stepEndNode) {
        logger.debug("node " + String.valueOf(stepEndNode) + " detected as Stage End node");
        StepStartNode stepStartNode = (StepStartNode)stepEndNode.getStartNode();
        CIEvent event = this.prepareStageEvent(stepStartNode).setEventType(CIEventType.FINISHED).setDuration(Long.valueOf(TimingAction.getStartTime((FlowNode)stepEndNode) - TimingAction.getStartTime((FlowNode)stepStartNode))).setResult(this.extractFlowNodeResult((FlowNode)stepEndNode));
        CIJenkinsServicesImpl.publishEventToRelevantClients(event);
    }

    private CIEvent prepareStageEvent(StepStartNode stepStartNode) {
        WorkflowRun parentRun = BuildHandlerUtils.extractParentRun((FlowNode)stepStartNode);
        return ((CIEvent)dtoFactory.newDTO(CIEvent.class)).setPhaseType(PhaseType.INTERNAL).setIsVirtualProject(Boolean.valueOf(true)).setProject(stepStartNode.getDisplayName()).setBuildCiId(BuildHandlerUtils.getBuildCiId((Run)parentRun)).setNumber(String.valueOf(parentRun.getNumber())).setStartTime(Long.valueOf(TimingAction.getStartTime((FlowNode)stepStartNode))).setCauses(CIEventCausesFactory.processCauses((FlowNode)stepStartNode));
    }

    private CIBuildResult extractFlowNodeResult(FlowNode node) {
        CIBuildResult result;
        CIBuildResult cIBuildResult = result = node.getError() != null ? CIBuildResult.FAILURE : CIBuildResult.SUCCESS;
        if (CIBuildResult.SUCCESS.equals((Object)result) && this.isChildNodeFailed(node, 0)) {
            result = CIBuildResult.FAILURE;
        }
        return result;
    }

    private boolean isChildNodeFailed(FlowNode node, int iteration) {
        if (iteration >= 2) {
            return false;
        }
        try {
            for (FlowNode temp : node.getParents()) {
                boolean isFailed;
                if (!(temp instanceof StepEndNode)) continue;
                boolean bl = isFailed = temp.getError() != null;
                if (isFailed) {
                    WarningAction warning = (WarningAction)temp.getAction(WarningAction.class);
                    if (warning != null) {
                        return warning.getResult().isWorseThan(Result.UNSTABLE);
                    }
                    return true;
                }
                if (!this.isChildNodeFailed(temp, iteration + 1)) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.error("failed in isChildNodeFailed " + e.getMessage());
        }
        return false;
    }
}

